/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import java.util.Comparator;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Ticket.class})
abstract class TicketMixin<T>
implements ChunkSystemTicket<T>,
Comparable<Ticket> {
    @Shadow
    @Final
    private TicketType type;
    @Shadow
    @Final
    private int ticketLevel;
    @Shadow
    private long ticksLeft;
    @Unique
    private T identifier;

    TicketMixin() {
    }

    @Override
    public final long moonrise$getRemoveDelay() {
        return this.ticksLeft;
    }

    @Override
    public final void moonrise$setRemoveDelay(long removeDelay) {
        this.ticksLeft = removeDelay;
    }

    @Override
    public final T moonrise$getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void moonrise$setIdentifier(T identifier) {
        if (identifier == null != (((ChunkSystemTicketType)this.type).moonrise$getIdentifierComparator() == null)) {
            throw new IllegalStateException("Nullability of identifier should match nullability of comparator");
        }
        this.identifier = identifier;
    }

    @Overwrite
    public String toString() {
        return "Ticket[" + String.valueOf(this.type) + " " + this.ticketLevel + " (" + String.valueOf(this.identifier) + ")] to die in " + this.ticksLeft;
    }

    @Override
    public final int compareTo(Ticket ticket) {
        int levelCompare = Integer.compare(this.ticketLevel, ((TicketMixin)ticket).ticketLevel);
        if (levelCompare != 0) {
            return levelCompare;
        }
        int typeCompare = Long.compare(((ChunkSystemTicketType)this.type).moonrise$getId(), ((ChunkSystemTicketType)((TicketMixin)ticket).type).moonrise$getId());
        if (typeCompare != 0) {
            return typeCompare;
        }
        Comparator<T> comparator = ((ChunkSystemTicketType)this.type).moonrise$getIdentifierComparator();
        return comparator == null ? 0 : comparator.compare(this.identifier, ((TicketMixin)ticket).identifier);
    }
}

