/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
abstract class BlockStateBaseMixin
extends StateHolder<Block, BlockState>
implements CollisionBlockState {
    @Shadow
    protected BlockBehaviour.BlockStateBase.Cache cache;
    @Shadow
    public VoxelShape[] occlusionShapesByFace;
    @Shadow
    public VoxelShape occlusionShape;
    @Unique
    private static final int RANDOM_OFFSET = 704237939;
    @Unique
    private static final Direction[] DIRECTIONS_CACHED = Direction.values();
    @Unique
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    @Unique
    private final int id1 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
    @Unique
    private final int id2 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
    @Unique
    private boolean occludesFullBlock;
    @Unique
    private boolean emptyCollisionShape;
    @Unique
    private boolean emptyConstantCollisionShape;
    @Unique
    private VoxelShape constantCollisionShape;

    @Shadow
    public abstract boolean isAir();

    protected BlockStateBaseMixin(Block object, Reference2ObjectArrayMap<Property<?>, Comparable<?>> reference2ObjectArrayMap, MapCodec<BlockState> mapCodec) {
        super((Object)object, reference2ObjectArrayMap, mapCodec);
    }

    @Unique
    private static void initCaches(VoxelShape shape, boolean neighbours) {
        ((CollisionVoxelShape)shape).moonrise$isFullBlock();
        ((CollisionVoxelShape)shape).moonrise$occludesFullBlock();
        shape.toAabbs();
        if (!shape.isEmpty()) {
            shape.bounds();
        }
        if (neighbours) {
            for (Direction direction : DIRECTIONS_CACHED) {
                BlockStateBaseMixin.initCaches(((CollisionVoxelShape)shape).moonrise$getFaceShapeClamped(direction), false);
                BlockStateBaseMixin.initCaches(shape.getFaceShape(direction), false);
            }
        }
    }

    @Inject(method={"initCache"}, at={@At(value="RETURN")})
    private void initCollisionState(CallbackInfo ci) {
        if (this.cache != null) {
            VoxelShape collisionShape = this.cache.collisionShape;
            this.constantCollisionShape = this.isAir() ? Shapes.empty() : null;
            this.occludesFullBlock = ((CollisionVoxelShape)collisionShape).moonrise$occludesFullBlock();
            this.emptyCollisionShape = collisionShape.isEmpty();
            this.emptyConstantCollisionShape = this.constantCollisionShape != null && this.constantCollisionShape.isEmpty();
            BlockStateBaseMixin.initCaches(collisionShape, true);
            if (this.constantCollisionShape != null) {
                BlockStateBaseMixin.initCaches(this.constantCollisionShape, true);
            }
        } else {
            this.occludesFullBlock = false;
            this.emptyCollisionShape = false;
            this.emptyConstantCollisionShape = false;
            this.constantCollisionShape = null;
        }
        if (this.occlusionShape != null) {
            BlockStateBaseMixin.initCaches(this.occlusionShape, true);
        }
        if (this.occlusionShapesByFace != null) {
            for (VoxelShape shape : this.occlusionShapesByFace) {
                BlockStateBaseMixin.initCaches(shape, true);
            }
        }
    }

    @Override
    public final boolean moonrise$hasCache() {
        return this.cache != null;
    }

    @Override
    public final boolean moonrise$occludesFullBlock() {
        return this.occludesFullBlock;
    }

    @Override
    public final boolean moonrise$emptyCollisionShape() {
        return this.emptyCollisionShape;
    }

    @Override
    public final boolean moonrise$emptyContextCollisionShape() {
        return this.emptyConstantCollisionShape;
    }

    @Override
    public final int moonrise$uniqueId1() {
        return this.id1;
    }

    @Override
    public final int moonrise$uniqueId2() {
        return this.id2;
    }

    @Override
    public final VoxelShape moonrise$getConstantContextCollisionShape() {
        return this.constantCollisionShape;
    }
}

