/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedToAABBs;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.MergedORCache;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VoxelShape.class})
abstract class VoxelShapeMixin
implements CollisionVoxelShape {
    @Shadow
    @Final
    public DiscreteVoxelShape shape;
    @Unique
    private double offsetX;
    @Unique
    private double offsetY;
    @Unique
    private double offsetZ;
    @Unique
    private AABB singleAABBRepresentation;
    @Unique
    private double[] rootCoordinatesX;
    @Unique
    private double[] rootCoordinatesY;
    @Unique
    private double[] rootCoordinatesZ;
    @Unique
    private CachedShapeData cachedShapeData;
    @Unique
    private boolean isEmpty;
    @Unique
    private CachedToAABBs cachedToAABBs;
    @Unique
    private AABB cachedBounds;
    @Unique
    private Boolean isFullBlock;
    @Unique
    private Boolean occludesFullBlock;
    @Unique
    private static final int MERGED_CACHE_SIZE = 16;
    @Unique
    private MergedORCache[] mergedORCache;
    @Unique
    private VoxelShape[] faceShapeClampedCache;

    VoxelShapeMixin() {
    }

    @Shadow
    public abstract DoubleList getCoords(Direction.Axis var1);

    @Override
    public final double moonrise$offsetX() {
        return this.offsetX;
    }

    @Override
    public final double moonrise$offsetY() {
        return this.offsetY;
    }

    @Override
    public final double moonrise$offsetZ() {
        return this.offsetZ;
    }

    @Override
    public final AABB moonrise$getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    @Override
    public final double[] moonrise$rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    @Override
    public final double[] moonrise$rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    @Override
    public final double[] moonrise$rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    @Unique
    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    @Override
    public final void moonrise$initCache() {
        OffsetDoubleList offsetDoubleList;
        this.cachedShapeData = ((CollisionDiscreteVoxelShape)this.shape).moonrise$getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.getCoords(Direction.Axis.X);
        DoubleList yList = this.getCoords(Direction.Axis.Y);
        DoubleList zList = this.getCoords(Direction.Axis.Z);
        if (xList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)xList;
            this.offsetX = offsetDoubleList.offset;
            this.rootCoordinatesX = VoxelShapeMixin.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesX = VoxelShapeMixin.extractRawArray(xList);
        }
        if (yList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)yList;
            this.offsetY = offsetDoubleList.offset;
            this.rootCoordinatesY = VoxelShapeMixin.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesY = VoxelShapeMixin.extractRawArray(yList);
        }
        if (zList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)zList;
            this.offsetZ = offsetDoubleList.offset;
            this.rootCoordinatesZ = VoxelShapeMixin.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesZ = VoxelShapeMixin.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new AABB(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    @Override
    public final CachedShapeData moonrise$getCachedVoxelData() {
        return this.cachedShapeData;
    }

    @Override
    public final VoxelShape moonrise$getFaceShapeClamped(Direction direction) {
        VoxelShape ret;
        if (this.isEmpty) {
            return (VoxelShape)this;
        }
        if ((VoxelShape)this == Shapes.block()) {
            return (VoxelShape)this;
        }
        VoxelShape[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new VoxelShape[6];
        }
        Direction.Axis axis = direction.getAxis();
        VoxelShape ret2 = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (DoubleMath.fuzzyEquals((double)this.max(axis), (double)1.0, (double)1.0E-7) ? CollisionUtil.sliceShape((VoxelShape)this, axis, this.shape.getSize(axis) - 1) : Shapes.empty()) : (DoubleMath.fuzzyEquals((double)this.min(axis), (double)0.0, (double)1.0E-7) ? CollisionUtil.sliceShape((VoxelShape)this, axis, 0) : Shapes.empty());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    @Unique
    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.moonrise$isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.minY <= 1.0E-7 && singleAABB.maxY >= 0.9999999 && singleAABB.minX <= 1.0E-7 && singleAABB.maxX >= 0.9999999 && singleAABB.minZ <= 1.0E-7 && singleAABB.maxZ >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !Shapes.joinIsNotEmpty((VoxelShape)Shapes.block(), (VoxelShape)((VoxelShape)this), (BooleanOp)BooleanOp.ONLY_FIRST);
        this.occludesFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    @Override
    public final boolean moonrise$occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    @Unique
    private static int hash(VoxelShape key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    @Override
    public final VoxelShape moonrise$orUnoptimized(VoxelShape other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if ((VoxelShape)this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.isEmpty()) {
            return (VoxelShape)this;
        }
        int thisCacheKey = VoxelShapeMixin.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShapeMixin.hash((VoxelShape)this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = ((VoxelShapeMixin)other).mergedORCache == null ? null : ((VoxelShapeMixin)other).mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == (VoxelShape)this) {
            return otherCache.result();
        }
        VoxelShape result = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)this), (VoxelShape)other, (BooleanOp)BooleanOp.OR);
        if (cached != null && otherCache == null) {
            if (((VoxelShapeMixin)other).mergedORCache == null) {
                ((VoxelShapeMixin)other).mergedORCache = new MergedORCache[16];
            }
            ((VoxelShapeMixin)other).mergedORCache[otherCacheKey] = new MergedORCache((VoxelShape)this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    @Overwrite
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Overwrite
    public VoxelShape singleEncompassing() {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        return Shapes.create((AABB)this.bounds());
    }

    @Overwrite
    protected double get(Direction.Axis axis, int idx) {
        switch (axis) {
            case X: {
                return this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                return this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                return this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Overwrite
    public int findIndex(Direction.Axis axis, double value) {
        switch (axis) {
            case X: {
                double[] values = this.rootCoordinatesX;
                return CollisionUtil.findFloor(values, this.offsetX, value, 0, values.length - 1);
            }
            case Y: {
                double[] values = this.rootCoordinatesY;
                return CollisionUtil.findFloor(values, this.offsetY, value, 0, values.length - 1);
            }
            case Z: {
                double[] values = this.rootCoordinatesZ;
                return CollisionUtil.findFloor(values, this.offsetZ, value, 0, values.length - 1);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Unique
    private VoxelShape calculateFaceDirect(Direction direction, Direction.Axis axis, double[] coords, double offset) {
        if (coords.length == 2 && DoubleMath.fuzzyEquals((double)(coords[0] + offset), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)(coords[1] + offset), (double)1.0, (double)1.0E-7)) {
            return (VoxelShape)this;
        }
        boolean positiveDir = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        int index = CollisionUtil.findFloor(coords, offset, positiveDir ? 0.9999999 : 1.0E-7, 0, coords.length - 1);
        return CollisionUtil.sliceShape((VoxelShape)this, axis, index);
    }

    @Overwrite
    public VoxelShape calculateFace(Direction direction) {
        Direction.Axis axis = direction.getAxis();
        switch (axis) {
            case X: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesX, this.offsetX);
            }
            case Y: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesY, this.offsetY);
            }
            case Z: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesZ, this.offsetZ);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Overwrite
    public double collide(Direction.Axis axis, AABB source, double source_move) {
        if (this.isEmpty) {
            return source_move;
        }
        if (Math.abs(source_move) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case X: {
                return CollisionUtil.collideX((VoxelShape)this, source, source_move);
            }
            case Y: {
                return CollisionUtil.collideY((VoxelShape)this, source, source_move);
            }
            case Z: {
                return CollisionUtil.collideZ((VoxelShape)this, source, source_move);
            }
        }
        throw new RuntimeException("Unknown axis: " + String.valueOf(axis));
    }

    @Unique
    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new OffsetDoubleList((DoubleList)wrap, by);
    }

    @Overwrite
    public VoxelShape move(double x, double y, double z) {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        ArrayVoxelShape ret = new ArrayVoxelShape(this.shape, VoxelShapeMixin.offsetList(this.rootCoordinatesX, this.offsetX + x), VoxelShapeMixin.offsetList(this.rootCoordinatesY, this.offsetY + y), VoxelShapeMixin.offsetList(this.rootCoordinatesZ, this.offsetZ + z));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ((VoxelShapeMixin)ret).cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, x, y, z);
        }
        return ret;
    }

    @Unique
    private List<AABB> toAabbsUncached() {
        ArrayList<AABB> ret;
        if (this.singleAABBRepresentation != null) {
            ret = new ArrayList(1);
            ret.add(this.singleAABBRepresentation);
        } else {
            ret = new ArrayList<AABB>();
            double[] coordsX = this.rootCoordinatesX;
            double[] coordsY = this.rootCoordinatesY;
            double[] coordsZ = this.rootCoordinatesZ;
            double offX = this.offsetX;
            double offY = this.offsetY;
            double offZ = this.offsetZ;
            this.shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> ret.add(new AABB(coordsX[minX] + offX, coordsY[minY] + offY, coordsZ[minZ] + offZ, coordsX[maxX] + offX, coordsY[maxY] + offY, coordsZ[maxZ] + offZ)), true);
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    @Overwrite
    public List<AABB> toAabbs() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    @Unique
    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if ((VoxelShape)this == Shapes.block()) {
                ret = Boolean.TRUE;
            } else {
                AABB singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x = sMinX; x < sMaxX; ++x) {
                            for (int y = sMinY; y < sMaxY; ++y) {
                                int baseIndex = y * sizeZ + x * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.minX) <= 1.0E-7 && Math.abs(singleAABB.minY) <= 1.0E-7 && Math.abs(singleAABB.minZ) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxX) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxY) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxZ) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    @Unique
    private static BlockHitResult clip(AABB aabb, Vec3 from, Vec3 to, BlockPos offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.x - from.x;
        double diffY = to.y - from.y;
        double diffZ = to.z - from.z;
        Direction direction = AABB.getDirection((AABB)aabb.move(offset), (Vec3)from, (double[])minDistanceArr, null, (double)diffX, (double)diffY, (double)diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new BlockHitResult(from.add(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    @Overwrite
    public BlockHitResult clip(Vec3 from, Vec3 to, BlockPos offset) {
        if (this.isEmpty) {
            return null;
        }
        Vec3 directionOpposite = to.subtract(from);
        if (directionOpposite.lengthSqr() < 1.0E-7) {
            return null;
        }
        Vec3 fromBehind = from.add(directionOpposite.scale(0.001));
        double fromBehindOffsetX = fromBehind.x - (double)offset.getX();
        double fromBehindOffsetY = fromBehind.y - (double)offset.getY();
        double fromBehindOffsetZ = fromBehind.z - (double)offset.getZ();
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.contains(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new BlockHitResult(fromBehind, Direction.getApproximateNearest((double)directionOpposite.x, (double)directionOpposite.y, (double)directionOpposite.z).getOpposite(), offset, true);
            }
            return VoxelShapeMixin.clip(singleAABB, from, to, offset);
        }
        if (CollisionUtil.strictlyContains((VoxelShape)this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new BlockHitResult(fromBehind, Direction.getApproximateNearest((double)directionOpposite.x, (double)directionOpposite.y, (double)directionOpposite.z).getOpposite(), offset, true);
        }
        return AABB.clip((Iterable)((VoxelShape)this).toAabbs(), (Vec3)from, (Vec3)to, (BlockPos)offset);
    }

    @Overwrite
    public AABB bounds() {
        if (this.isEmpty) {
            throw (UnsupportedOperationException)Util.pauseInIde((Throwable)new UnsupportedOperationException("No bounds for empty shape."));
        }
        AABB cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new AABB(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    @Overwrite
    public double min(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Overwrite
    public double max(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Overwrite
    public VoxelShape optimize() {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        if (this.singleAABBRepresentation != null) {
            return this.moonrise$isFullBlock() ? Shapes.block() : (VoxelShape)this;
        }
        List<AABB> aabbs = this.toAabbs();
        if (aabbs.isEmpty()) {
            return Shapes.empty();
        }
        if (aabbs.size() == 1) {
            AABB singleAABB = aabbs.get(0);
            VoxelShape ret = Shapes.create((AABB)singleAABB);
            if (((VoxelShapeMixin)ret).cachedToAABBs == null) {
                ((VoxelShapeMixin)ret).cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        VoxelShape[] tmp = new VoxelShape[aabbs.size()];
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            tmp[i] = Shapes.create((AABB)aabbs.get(i));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.OR);
            }
            size = newSize;
        }
        VoxelShape ret = tmp[0];
        if (((VoxelShapeMixin)ret).cachedToAABBs == null) {
            ((VoxelShapeMixin)ret).cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    @Overwrite
    public Optional<Vec3> closestPointTo(Vec3 point) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        Vec3 ret = null;
        double retDistance = Double.MAX_VALUE;
        List<AABB> aabbs = this.toAabbs();
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            double z;
            double y;
            AABB aabb = aabbs.get(i);
            double x = Mth.clamp((double)point.x, (double)aabb.minX, (double)aabb.maxX);
            double dist = point.distanceToSqr(x, y = Mth.clamp((double)point.y, (double)aabb.minY, (double)aabb.maxY), z = Mth.clamp((double)point.z, (double)aabb.minZ, (double)aabb.maxZ));
            if (!(dist < retDistance)) continue;
            ret = new Vec3(x, y, z);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }
}

