/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.entity_tracker;

import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Entity.class})
abstract class EntityMixin
implements EntityTrackerEntity {
    @Shadow
    private ImmutableList<Entity> passengers;
    @Unique
    private ChunkMap.TrackedEntity trackedEntity;

    EntityMixin() {
    }

    @Override
    public final ChunkMap.TrackedEntity moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(ChunkMap.TrackedEntity trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    @Unique
    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            EntityMixin.collectIndirectPassengers(into, ((EntityMixin)passenger).passengers);
        }
    }

    @Overwrite
    public Iterable<Entity> getIndirectPassengers() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.passengers.isEmpty()) {
            return ret;
        }
        EntityMixin.collectIndirectPassengers(ret, this.passengers);
        return ret;
    }
}

