/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1297;

public final class EntityList
implements Iterable<class_1297> {
    private final Int2IntOpenHashMap entityToIndex = new Int2IntOpenHashMap(2, 0.8f);
    private static final class_1297[] EMPTY_LIST = new class_1297[0];
    private class_1297[] entities;
    private int count;

    public EntityList() {
        this.entityToIndex.defaultReturnValue(Integer.MIN_VALUE);
        this.entities = EMPTY_LIST;
    }

    public int size() {
        return this.count;
    }

    public boolean contains(class_1297 entity) {
        return this.entityToIndex.containsKey(entity.method_5628());
    }

    public boolean remove(class_1297 entity) {
        int index = this.entityToIndex.remove(entity.method_5628());
        if (index == Integer.MIN_VALUE) {
            return false;
        }
        int endIndex = --this.count;
        class_1297 end = this.entities[endIndex];
        if (index != endIndex) {
            this.entityToIndex.put(end.method_5628(), index);
        }
        this.entities[index] = end;
        this.entities[endIndex] = null;
        return true;
    }

    public boolean add(class_1297 entity) {
        int count = this.count;
        int currIndex = this.entityToIndex.putIfAbsent(entity.method_5628(), count);
        if (currIndex != Integer.MIN_VALUE) {
            return false;
        }
        class_1297[] list = this.entities;
        if (list.length == count) {
            list = this.entities = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = entity;
        this.count = count + 1;
        return true;
    }

    public class_1297 getChecked(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds, size: " + this.count);
        }
        return this.entities[index];
    }

    public class_1297 getUnchecked(int index) {
        return this.entities[index];
    }

    public class_1297[] getRawData() {
        return this.entities;
    }

    public void clear() {
        this.entityToIndex.clear();
        Arrays.fill(this.entities, 0, this.count, null);
        this.count = 0;
    }

    @Override
    public Iterator<class_1297> iterator() {
        return new Iterator<class_1297>(){
            private class_1297 lastRet;
            private int current;

            @Override
            public boolean hasNext() {
                return this.current < EntityList.this.count;
            }

            @Override
            public class_1297 next() {
                if (this.current >= EntityList.this.count) {
                    throw new NoSuchElementException();
                }
                this.lastRet = EntityList.this.entities[this.current++];
                return this.lastRet;
            }

            @Override
            public void remove() {
                class_1297 lastRet = this.lastRet;
                if (lastRet == null) {
                    throw new IllegalStateException();
                }
                this.lastRet = null;
                EntityList.this.remove(lastRet);
                --this.current;
            }
        };
    }
}

