/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.config.moonrise.MoonriseConfig;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.config.YamlConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHolder.class);
    private static final File CONFIG_FILE = new File(System.getProperty(PlatformHooks.get().getBrand() + ".ConfigFile", "config/moonrise.yml"));
    private static final TypeAdapterRegistry CONFIG_ADAPTERS = new TypeAdapterRegistry();
    private static final YamlConfig<MoonriseConfig> CONFIG;
    private static final String CONFIG_HEADER;

    public static YamlConfig<MoonriseConfig> getConfigRaw() {
        return CONFIG;
    }

    public static MoonriseConfig getConfig() {
        return (MoonriseConfig)ConfigHolder.CONFIG.config;
    }

    public static boolean reloadConfig() {
        return ConfigHolder.reloadConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reloadConfig(boolean startup) {
        YamlConfig<MoonriseConfig> yamlConfig = CONFIG;
        synchronized (yamlConfig) {
            if (CONFIG_FILE.exists()) {
                try {
                    CONFIG.load(CONFIG_FILE);
                }
                catch (Exception ex) {
                    if (startup) {
                        LOGGER.error("Failed to load configuration, using defaults", (Throwable)ex);
                        CONFIG.callInitialisers();
                    } else {
                        LOGGER.error("Failed to reload configuration", (Throwable)ex);
                    }
                    return false;
                }
            }
            CONFIG.callInitialisers();
            return ConfigHolder.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveConfig() {
        YamlConfig<MoonriseConfig> yamlConfig = CONFIG;
        synchronized (yamlConfig) {
            try {
                CONFIG.save(CONFIG_FILE, CONFIG_HEADER);
                return true;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to save configuration", (Throwable)ex);
                return false;
            }
        }
    }

    private ConfigHolder() {
    }

    static {
        try {
            CONFIG = new YamlConfig<MoonriseConfig>(MoonriseConfig.class, new MoonriseConfig(), CONFIG_ADAPTERS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        CONFIG_HEADER = String.format("This is the configuration file for Moonrise.\n\nEach configuration option is prefixed with a comment to explain what it does. Additional changes to this file\nother than modifying the options, such as adding comments, will be overwritten when Moonrise loads the config.\n\nBelow are the Moonrise startup flags. Note that startup flags must be placed in the JVM arguments, not\nprogram arguments.\n-D%1$s.ConfigFile=<file> - Override the config file location. Might be useful for multiple game versions.\n-D%1$s.WorkerThreadCount=<number> - Override the auto configured worker thread counts (worker-threads).\n-D%1$s.MaxViewDistance=<number> - Overrides the maximum view distance, should only use for debugging purposes.\n", PlatformHooks.get().getBrand());
        ConfigHolder.reloadConfig(true);
    }
}

