/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class ByteTypeAdapter
extends TypeAdapter<Byte, Byte> {
    public static final ByteTypeAdapter INSTANCE = new ByteTypeAdapter();

    private static Byte cast(Object original, long value) {
        if (value < -128L || value > 127L) {
            throw new IllegalArgumentException("Byte value is out of range: " + original.toString());
        }
        return (byte)value;
    }

    @Override
    public Byte deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            long l;
            Number number = (Number)input;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                l = bigInteger.longValueExact();
            } else {
                l = number.longValue();
            }
            return ByteTypeAdapter.cast(input, l);
        }
        if (input instanceof String) {
            String string = (String)input;
            return ByteTypeAdapter.cast(input, (long)Double.parseDouble(string));
        }
        throw new IllegalArgumentException("Not a byte type: " + String.valueOf(input.getClass()));
    }

    @Override
    public Byte serialize(TypeAdapterRegistry registry, Byte value, Type type) {
        return value;
    }
}

