/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.block_counting;

import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingBitStorage;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_3610;
import net.minecraft.class_4970;
import net.minecraft.class_6490;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2826.class})
abstract class LevelChunkSectionMixin
implements BlockCountingChunkSection {
    @Shadow
    @Final
    public class_2841<class_2680> field_12878;
    @Shadow
    private short field_12877;
    @Shadow
    private short field_12882;
    @Shadow
    private short field_12881;
    @Unique
    private static final ShortArrayList FULL_LIST = new ShortArrayList(4096);
    @Unique
    private boolean isClient;
    @Unique
    private static final short CLIENT_FORCED_SPECIAL_COLLIDING_BLOCKS = 9999;
    @Unique
    private short specialCollidingBlocks;
    @Unique
    private final ShortList tickingBlocks = new ShortList();

    LevelChunkSectionMixin() {
    }

    @Shadow
    public abstract boolean method_19523(Predicate<class_2680> var1);

    @Override
    public final boolean moonrise$hasSpecialCollidingBlocks() {
        return this.specialCollidingBlocks != 0;
    }

    @Override
    public final ShortList moonrise$getTickingBlockList() {
        return this.tickingBlocks;
    }

    @Inject(method={"method_12256(IIILnet/minecraft/class_2680;Z)Lnet/minecraft/class_2680;"}, at={@At(value="RETURN")})
    private void updateBlockCallback(int x, int y, int z, class_2680 newState, boolean lock, CallbackInfoReturnable<class_2680> cir, @Local(ordinal=1) class_2680 oldState) {
        boolean newTicking;
        boolean oldTicking;
        boolean isSpecialNew;
        if (oldState == newState) {
            return;
        }
        if (this.isClient) {
            if (CollisionUtil.isSpecialCollidingBlock((class_4970.class_4971)newState)) {
                this.specialCollidingBlocks = (short)9999;
            }
            return;
        }
        boolean isSpecialOld = CollisionUtil.isSpecialCollidingBlock((class_4970.class_4971)oldState);
        if (isSpecialOld != (isSpecialNew = CollisionUtil.isSpecialCollidingBlock((class_4970.class_4971)newState))) {
            this.specialCollidingBlocks = isSpecialOld ? (short)(this.specialCollidingBlocks - 1) : (short)(this.specialCollidingBlocks + 1);
        }
        if ((oldTicking = oldState.method_26229()) != (newTicking = newState.method_26229())) {
            ShortList tickingBlocks = this.tickingBlocks;
            short position = (short)(x | z << 4 | y << 8);
            if (oldTicking) {
                tickingBlocks.remove(position);
            } else {
                tickingBlocks.add(position);
            }
        }
    }

    @Redirect(method={"method_12256(IIILnet/minecraft/class_2680;Z)Lnet/minecraft/class_2680;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3610;method_15769()Z"))
    private boolean fixTickingFluidCount(class_3610 instance) {
        return !instance.method_15773();
    }

    @Overwrite
    public void method_12253() {
        this.field_12877 = 0;
        this.field_12882 = 0;
        this.field_12881 = 0;
        this.specialCollidingBlocks = 0;
        this.tickingBlocks.clear();
        if (this.method_19523(state -> !state.method_26215())) {
            Int2ObjectOpenHashMap counts;
            class_2841.class_6561 data = this.field_12878.field_34560;
            class_2837 palette = data.comp_119();
            int paletteSize = palette.method_12197();
            class_6490 storage = data.comp_118();
            if (paletteSize == 1) {
                counts = new Int2ObjectOpenHashMap(1);
                counts.put(0, (Object)FULL_LIST);
            } else {
                counts = ((BlockCountingBitStorage)storage).moonrise$countEntries();
            }
            ObjectIterator iterator = counts.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                class_3610 fluid;
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int paletteIdx = entry.getIntKey();
                ShortArrayList coordinates = (ShortArrayList)entry.getValue();
                int paletteCount = coordinates.size();
                class_2680 state2 = (class_2680)palette.method_12288(paletteIdx);
                if (state2.method_26215()) continue;
                if (CollisionUtil.isSpecialCollidingBlock((class_4970.class_4971)state2)) {
                    this.specialCollidingBlocks = (short)(this.specialCollidingBlocks + (short)paletteCount);
                }
                this.field_12877 = (short)(this.field_12877 + (short)paletteCount);
                if (state2.method_26229()) {
                    this.field_12882 = (short)(this.field_12882 + (short)paletteCount);
                    short[] raw = coordinates.elements();
                    int rawLen = raw.length;
                    ShortList tickingBlocks = this.tickingBlocks;
                    tickingBlocks.setMinCapacity(Math.min((rawLen + tickingBlocks.size()) * 3 / 2, 4096));
                    Objects.checkFromToIndex(0, paletteCount, rawLen);
                    for (int i = 0; i < paletteCount; ++i) {
                        tickingBlocks.add(raw[i]);
                    }
                }
                if ((fluid = state2.method_26227()).method_15769() || !fluid.method_15773()) continue;
                this.field_12881 = (short)(this.field_12881 + (short)paletteCount);
            }
        }
    }

    @Inject(method={"method_12258(Lnet/minecraft/class_2540;)V"}, at={@At(value="RETURN")})
    private void callRecalcBlocksClient(CallbackInfo ci) {
        this.isClient = true;
        this.specialCollidingBlocks = this.field_12877 != 0 && this.method_19523(CollisionUtil::isSpecialCollidingBlock) ? 9999 : 0;
    }

    static {
        for (short i = 0; i < 4096; i = (short)(i + 1)) {
            FULL_LIST.add(i);
        }
    }
}

