/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3194;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
abstract class EntityMixin
implements ChunkSystemEntity {
    @Shadow
    private ImmutableList<class_1297> field_5979;
    @Shadow
    private class_1937 field_6002;
    @Shadow
    @Nullable
    private class_1297.class_5529 field_26995;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    @Unique
    private class_3194 chunkStatus;
    @Unique
    private ChunkData chunkData;
    @Unique
    private int sectionX = Integer.MIN_VALUE;
    @Unique
    private int sectionY = Integer.MIN_VALUE;
    @Unique
    private int sectionZ = Integer.MIN_VALUE;
    @Unique
    private boolean updatingSectionStatus;

    EntityMixin() {
    }

    @Shadow
    protected abstract Stream<class_1297> method_31484();

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final class_3194 moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(class_3194 status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x) {
        this.sectionX = x;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y) {
        this.sectionY = y;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z) {
        this.sectionZ = z;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.field_5979.isEmpty()) {
            return false;
        }
        return this.method_31484().anyMatch(entity -> entity instanceof class_1657);
    }

    @Inject(method={"method_23327(DDD)V"}, cancellable=true, at={@At(value="HEAD")})
    private void checkUpdatingStatusPoi(double x, double y, double z, CallbackInfo ci) {
        if (this.updatingSectionStatus) {
            LOGGER.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new class_243(x, y, z)) + " since it is processing a section status update", new Throwable());
            ci.cancel();
            return;
        }
    }

    @Inject(method={"method_31745(Lnet/minecraft/class_1297$class_5529;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void checkCanRemove(CallbackInfo ci) {
        if (!((ChunkSystemLevel)this.field_6002).moonrise$getEntityLookup().canRemoveEntity((class_1297)this)) {
            LOGGER.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            ci.cancel();
            return;
        }
    }

    @Redirect(method={"method_31745(Lnet/minecraft/class_1297$class_5529;)V"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"))
    private void avoidDismountOnUnload(List<class_1297> instance, Consumer<? super class_1297> consumer) {
        if (this.field_26995 == class_1297.class_5529.field_27000) {
            return;
        }
        instance.forEach(consumer);
    }

    @Redirect(method={"method_31746()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1297;method_5817()Z"))
    private boolean properlyCheckPlayers(class_1297 instance) {
        return ((ChunkSystemEntity)instance).moonrise$hasAnyPlayerPassengers();
    }
}

