/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2LongChainedHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketStorage;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_10592;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_10592.class})
abstract class TicketStorageMixin
extends class_18
implements ChunkSystemTicketStorage {
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<List<class_3228>> field_55724;
    @Shadow
    private Long2ObjectOpenHashMap<List<class_3228>> field_55723;
    @Shadow
    private LongSet field_55725;
    @Unique
    private class_3898 chunkMap;

    TicketStorageMixin() {
    }

    @Override
    public final class_3898 moonrise$getChunkMap() {
        return this.chunkMap;
    }

    @Override
    public final void moonrise$setChunkMap(class_3898 chunkMap) {
        this.chunkMap = chunkMap;
    }

    @Inject(method={"<init>(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"}, at={@At(value="RETURN")})
    private void destroyFields(Long2ObjectOpenHashMap p_393873_, Long2ObjectOpenHashMap p_394615_, CallbackInfo ci) {
        if (!this.field_55723.isEmpty()) {
            throw new IllegalStateException("Expect tickets to be empty here!");
        }
        this.field_55723 = null;
        this.field_55725 = null;
    }

    @Redirect(method={"<init>(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_10592;method_66385()V"))
    private void avoidUpdatingForcedChunks(class_10592 instance) {
    }

    @Redirect(method={"method_67397(Ljava/util/function/BiConsumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_10592;method_67398(Ljava/util/function/BiConsumer;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", ordinal=0))
    private void redirectRegularTickets(BiConsumer<class_1923, class_3228> consumer, Long2ObjectOpenHashMap<List<class_3228>> ticketsParam) {
        if (ticketsParam != null) {
            throw new IllegalStateException("Bad injection point");
        }
        Long2ObjectOpenHashMap<Collection<class_3228>> tickets = ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsCopy();
        ObjectIterator iterator = tickets.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            Collection chunkTickets = (Collection)entry.getValue();
            class_1923 chunkPos = new class_1923(pos);
            for (class_3228 ticket : chunkTickets) {
                consumer.accept(chunkPos, ticket);
            }
        }
    }

    @Overwrite
    public boolean method_72544() {
        ConcurrentLong2LongChainedHashTable ticketCounters = ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(1L);
        return ticketCounters != null && !ticketCounters.isEmpty();
    }

    @Overwrite
    public void method_66360(class_10592.class_10593 callback) {
    }

    @Overwrite
    public void method_66374(class_10592.class_10593 callback) {
    }

    @Overwrite
    public boolean method_66378() {
        return ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.hasTickets();
    }

    @Overwrite
    public List<class_3228> method_66352(long pos) {
        return ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketsAt(CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos));
    }

    @Overwrite
    public boolean method_66353(long pos, class_3228 ticket) {
        boolean ret = ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ticket.method_14281(), pos, ticket.method_14283(), ((ChunkSystemTicket)ticket).moonrise$getIdentifier());
        this.method_80();
        return ret;
    }

    @Overwrite
    public boolean method_66369(long pos, class_3228 ticket) {
        boolean ret = ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ticket.method_14281(), pos, ticket.method_14283(), ((ChunkSystemTicket)ticket).moonrise$getIdentifier());
        if (ret) {
            this.method_80();
        }
        return ret;
    }

    @Overwrite
    public void method_66381(class_3898 chunkMap) {
        ((ChunkSystemServerLevel)chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.tick();
        this.method_80();
    }

    @Redirect(method={"method_66383()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_10592;method_66364(Lnet/minecraft/class_10592$class_11581;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V"))
    private void avoidRemovingTicketsOnShutdown(class_10592 instance, class_10592.class_11581 predicate, Long2ObjectOpenHashMap<List<class_3228>> tickets) {
    }

    @Overwrite
    public void method_66364(class_10592.class_11581 predicate, Long2ObjectOpenHashMap<List<class_3228>> into) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_66351(int newLevel, class_3230 forType) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public LongSet method_66384() {
        ConcurrentLong2LongChainedHashTable forced = ((ChunkSystemServerLevel)this.chunkMap.field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager.getTicketCounters(0L);
        if (forced == null) {
            return new LongLinkedOpenHashSet();
        }
        LongLinkedOpenHashSet ret = new LongLinkedOpenHashSet(forced.size(), forced.getLoadFactor());
        PrimitiveIterator.OfLong iterator = forced.keyIterator();
        while (iterator.hasNext()) {
            ret.add(iterator.nextLong());
        }
        return ret;
    }

    @Overwrite
    public LongSet method_66363(Predicate<class_3228> predicate) {
        throw new UnsupportedOperationException();
    }
}

