/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1297.class})
abstract class EntityMixin {
    @Shadow
    private class_1937 field_6002;
    @Shadow
    public boolean field_5960;
    @Shadow
    private class_4048 field_18065;
    @Shadow
    private boolean field_5952;

    EntityMixin() {
    }

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public abstract float method_49476();

    @Shadow
    public abstract class_243 method_33571();

    @Unique
    private static float[] calculateStepHeights(class_238 box, List<class_265> voxels, List<class_238> aabbs, float stepHeight, float collidedY) {
        class_265 shape;
        int i;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i = 0; i < len; ++i) {
            double yUnoffset;
            double y;
            float step;
            shape = voxels.get(i);
            double[] yCoords = ((CollisionVoxelShape)shape).moonrise$rootCoordinatesY();
            double yOffset = ((CollisionVoxelShape)shape).moonrise$offsetY();
            double[] dArray = yCoords;
            int n = dArray.length;
            for (int j = 0; j < n && !((step = (float)((y = (yUnoffset = dArray[j]) + yOffset) - box.field_1322)) > stepHeight); ++j) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i = 0; i < len; ++i) {
            shape = aabbs.get(i);
            float step1 = (float)(shape.field_1322 - box.field_1322);
            float step2 = (float)(shape.field_1325 - box.field_1322);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Overwrite
    private class_243 method_17835(class_243 movement) {
        double stepHeight;
        boolean collidedDownwards;
        class_243 collided;
        ArrayList<class_238> entityAABBs;
        class_238 currentBox;
        block7: {
            block6: {
                double d;
                boolean zZero;
                boolean xZero = movement.field_1352 == 0.0;
                boolean yZero = movement.field_1351 == 0.0;
                boolean bl = zZero = movement.field_1350 == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.method_5829();
                ArrayList<class_265> potentialCollisionsVoxel = new ArrayList<class_265>();
                ArrayList<class_238> potentialCollisionsBB = new ArrayList<class_238>();
                class_238 initialCollisionBox = xZero & zZero ? (movement.field_1351 < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.field_1351) : CollisionUtil.cutUpwards(currentBox, movement.field_1351)) : currentBox.method_18804(movement);
                entityAABBs = new ArrayList<class_238>();
                CollisionUtil.getEntityHardCollisions(this.field_6002, (class_1297)this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.field_6002, (class_1297)this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.field_1352 != movement.field_1352;
                boolean collidedY = collided.field_1351 != movement.field_1351;
                boolean collidedZ = collided.field_1350 != movement.field_1350;
                boolean bl2 = collidedDownwards = collidedY && movement.field_1351 < 0.0;
                if (!collidedDownwards && !this.field_5952 || !collidedX && !collidedZ) break block6;
                stepHeight = this.method_49476();
                if (!(d <= 0.0)) break block7;
            }
            return collided;
        }
        class_238 collidedYBox = collidedDownwards ? currentBox.method_989(0.0, collided.field_1351, 0.0) : currentBox;
        class_238 stepRetrievalBox = collidedYBox.method_1012(movement.field_1352, stepHeight, movement.field_1350);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.method_1012(0.0, (double)-1.0E-5f, 0.0);
        }
        ArrayList<class_265> stepVoxels = new ArrayList<class_265>();
        ArrayList<class_238> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.field_6002, (class_1297)this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : EntityMixin.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.field_1351)) {
            class_243 stepResult = CollisionUtil.performCollisions(new class_243(movement.field_1352, (double)step, movement.field_1350), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.method_37268() > collided.method_37268())) continue;
            return stepResult.method_1031(0.0, collidedYBox.field_1322 - currentBox.field_1322, 0.0);
        }
        return collided;
    }

    @Overwrite
    public boolean method_5757() {
        if (this.field_5960) {
            return false;
        }
        double reducedWith = this.field_18065.comp_2185() * 0.8f;
        class_238 boundingBox = class_238.method_30048((class_243)this.method_33571(), (double)reducedWith, (double)1.0E-6, (double)reducedWith);
        class_1937 world = this.field_6002;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = class_3532.method_15357((double)boundingBox.field_1323);
        int minBlockY = class_3532.method_15357((double)boundingBox.field_1322);
        int minBlockZ = class_3532.method_15357((double)boundingBox.field_1321);
        int maxBlockX = class_3532.method_15357((double)boundingBox.field_1320);
        int maxBlockY = class_3532.method_15357((double)boundingBox.field_1325);
        int maxBlockZ = class_3532.method_15357((double)boundingBox.field_1324);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        class_2802 chunkSource = world.method_8398();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                class_2826[] sections = chunkSource.method_12121(currChunkX, currChunkZ, class_2806.field_12803, true).method_12006();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    class_2826 section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).method_38292()) continue;
                    class_2841 blocks = section.field_12878;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.method_33098(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.method_33099(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                class_265 collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.method_33097(blockX);
                                class_2680 blockState = (class_2680)blocks.method_12331(currX | currZ << 4 | currY << 8);
                                if (((CollisionBlockState)blockState).moonrise$emptyCollisionShape() || !blockState.method_26228((class_1922)world, (class_2338)mutablePos) || (collisionShape = blockState.method_26220((class_1922)world, (class_2338)mutablePos)).method_1110()) continue;
                                class_238 toCollide = boundingBox.method_989(-((double)blockX), -((double)blockY), -((double)blockZ));
                                class_238 singleAABB = ((CollisionVoxelShape)collisionShape).moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
}

