/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1937.class})
abstract class LevelMixin
implements class_1936,
AutoCloseable {
    @Unique
    private static final class_3610 AIR_FLUIDSTATE = class_3612.field_15906.method_15785();

    LevelMixin() {
    }

    @Shadow
    public abstract class_2818 method_8497(int var1, int var2);

    public boolean method_8606(class_1297 entity) {
        class_238 boundingBox = entity.method_5829();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return true;
        }
        List entities = this.method_8333(entity, boundingBox.method_1009(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            class_1297 otherEntity = (class_1297)entities.get(i);
            if (otherEntity.method_7325() || otherEntity.method_31481() || !otherEntity.field_23807 || otherEntity.method_5794(entity)) continue;
            return false;
        }
        return true;
    }

    @Unique
    private static class_3965 miss(class_3959 clipContext) {
        class_243 to = clipContext.method_17747();
        class_243 from = clipContext.method_17750();
        return class_3965.method_17778((class_243)to, (class_2350)class_2350.method_10142((double)(from.field_1352 - to.field_1352), (double)(from.field_1351 - to.field_1351), (double)(from.field_1350 - to.field_1350)), (class_2338)class_2338.method_49637((double)to.field_1352, (double)to.field_1351, (double)to.field_1350));
    }

    @Unique
    private static class_3965 fastClip(class_243 from, class_243 to, class_1937 level, class_3959 clipContext) {
        double adjX = 1.0E-7 * (from.field_1352 - to.field_1352);
        double adjY = 1.0E-7 * (from.field_1351 - to.field_1351);
        double adjZ = 1.0E-7 * (from.field_1350 - to.field_1350);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return LevelMixin.miss(clipContext);
        }
        double toXAdj = to.field_1352 - adjX;
        double toYAdj = to.field_1351 - adjY;
        double toZAdj = to.field_1350 - adjZ;
        double fromXAdj = from.field_1352 + adjX;
        double fromYAdj = from.field_1351 + adjY;
        double fromZAdj = from.field_1350 + adjZ;
        int currX = class_3532.method_15357((double)fromXAdj);
        int currY = class_3532.method_15357((double)fromYAdj);
        int currZ = class_3532.method_15357((double)fromZAdj);
        class_2338.class_2339 currPos = new class_2338.class_2339();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - class_3532.method_15385((double)fromXAdj) : class_3532.method_15385((double)fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - class_3532.method_15385((double)fromYAdj) : class_3532.method_15385((double)fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - class_3532.method_15385((double)fromZAdj) : class_3532.method_15385((double)fromZAdj));
        class_2826[] lastChunk = null;
        class_2841 lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            class_2680 blockState;
            currPos.method_10103(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.method_8497(newChunkX, newChunkZ).method_12006();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].field_12878 : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = (class_2680)lastSection.method_12331(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).method_26215()) {
                class_265 fluidCollision;
                class_3965 fluidHit;
                class_3610 fluidState;
                class_3965 blockHit;
                class_265 blockCollision = clipContext.method_17748(blockState, (class_1922)level, (class_2338)currPos);
                class_3965 class_39652 = blockHit = blockCollision.method_1110() ? null : level.method_17745(from, to, (class_2338)currPos, blockCollision, blockState);
                if (clipContext.field_17556 != class_3959.class_242.field_1348 && (fluidState = blockState.method_26227()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.method_17749(fluidState, (class_1922)level, (class_2338)currPos)).method_1092(from, to, (class_2338)currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.method_1025(blockHit.method_17784()) <= from.method_1025(fluidHit.method_17784()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return LevelMixin.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    public class_3965 method_17742(class_3959 clipContext) {
        return LevelMixin.fastClip(clipContext.method_17750(), clipContext.method_17747(), (class_1937)this, clipContext);
    }

    public boolean method_8587(class_1297 entity, class_238 box) {
        int flags;
        int n = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder((class_1937)this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions((class_1937)this, entity, box, null, flags, null);
    }

    public boolean method_39454(class_1297 entity, class_238 box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder((class_1937)this, entity, box, null, null, 8, (state, pos) -> state.method_26228((class_1922)((class_1937)this), pos));
    }

    @Unique
    private static class_265 inflateAABBToVoxel(class_238 aabb, double x, double y, double z) {
        return class_259.method_31943((double)(aabb.field_1323 - x), (double)(aabb.field_1322 - y), (double)(aabb.field_1321 - z), (double)(aabb.field_1320 + x), (double)(aabb.field_1325 + y), (double)(aabb.field_1324 + z));
    }

    public Optional<class_243> method_33594(class_1297 entity, class_265 boundsShape, class_243 fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.method_1110()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        class_238 collectionVolume = boundsShape.method_1107().method_1009(expandByX, expandByY, expandByZ);
        ArrayList<class_238> aabbs = new ArrayList<class_238>();
        ArrayList<class_265> voxels = new ArrayList<class_265>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder((class_1937)this, entity, collectionVolume, voxels, aabbs, 4, null);
        class_2784 worldBorder = this.method_8621();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.method_11966(aabb));
            voxels.removeIf(shape -> !worldBorder.method_11966(shape.method_1107()));
        }
        int len = voxels.size();
        for (int i = 0; i < len; ++i) {
            aabbs.addAll(((class_265)voxels.get(i)).method_1090());
        }
        class_265 first = aabbs.isEmpty() ? class_259.method_1073() : LevelMixin.inflateAABBToVoxel((class_238)aabbs.get(0), expandByX, expandByY, expandByZ);
        class_265[] rest = new class_265[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i = 1; i < len2; ++i) {
            rest[i - 1] = LevelMixin.inflateAABBToVoxel((class_238)aabbs.get(i), expandByX, expandByY, expandByZ);
        }
        class_265 joined = class_259.method_17786((class_265)first, (class_265[])rest);
        class_265 freeSpace = class_259.method_1082((class_265)boundsShape, (class_265)joined, (class_247)class_247.field_16886);
        return freeSpace.method_33661(fromPosition);
    }

    public Optional<class_2338> method_51718(class_1297 entity, class_238 aabb) {
        int minSection = WorldUtil.getMinSection((class_1937)this);
        int minBlockX = class_3532.method_15357((double)(aabb.field_1323 - 1.0E-7)) - 1;
        int maxBlockX = class_3532.method_15357((double)(aabb.field_1320 + 1.0E-7)) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, class_3532.method_15357((double)(aabb.field_1322 - 1.0E-7)) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection((class_1937)this) << 4) + 16, class_3532.method_15357((double)(aabb.field_1325 + 1.0E-7)) + 1);
        int minBlockZ = class_3532.method_15357((double)(aabb.field_1321 - 1.0E-7)) - 1;
        int maxBlockZ = class_3532.method_15357((double)(aabb.field_1324 + 1.0E-7)) + 1;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        class_2338 selected = null;
        double selectedDistance = Double.MAX_VALUE;
        class_243 entityPos = entity.method_73189();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        class_2802 chunkSource = this.method_8398();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                class_2791 chunk = chunkSource.method_12121(currChunkX, currChunkZ, class_2806.field_12803, false);
                if (chunk == null) continue;
                class_2826[] sections = chunk.method_12006();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    class_2826 section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).method_38292()) continue;
                    boolean hasSpecial = ((BlockCountingChunkSection)section).moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    class_2841 blocks = section.field_12878;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.method_33098(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.method_33099(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                class_2680 blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.method_33097(blockX);
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.method_19770((class_2374)entityPos)) > selectedDistance || distance == selectedDistance && selected.method_10265((class_2382)mutablePos) >= 0 || ((CollisionBlockState)(blockData = (class_2680)blocks.method_12331(localBlockIndex))).moonrise$emptyContextCollisionShape()) continue;
                                class_265 blockCollision = ((CollisionBlockState)blockData).moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.method_26209() || edgeCount == 2 && blockData.method_26204() != class_2246.field_10008) || blockCollision == null && (blockCollision = blockData.method_26194((class_1922)((class_1937)this), (class_2338)mutablePos, (class_3726)collisionShape)).method_1110()) continue;
                                class_238 shiftedAABB = aabb.method_989(-((double)blockX), -((double)blockY), -((double)blockZ));
                                class_238 singleAABB = ((CollisionVoxelShape)blockCollision).moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.method_10062();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.method_10062();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }
}

