/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.starlight.lightengine;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2823;
import net.minecraft.class_3558;
import net.minecraft.class_3562;
import net.minecraft.class_3565;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3568.class})
abstract class LevelLightEngineMixin
implements class_3565,
StarLightLightingProvider {
    @Shadow
    @Nullable
    private class_3558<?, ?> field_15814;
    @Shadow
    @Nullable
    private class_3558<?, ?> field_15813;
    @Unique
    protected StarLightInterface lightEngine;
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> blockLightMap = new Long2ObjectOpenHashMap();
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> skyLightMap = new Long2ObjectOpenHashMap();

    LevelLightEngineMixin() {
    }

    @Override
    public final StarLightInterface starlight$getLightEngine() {
        return this.lightEngine;
    }

    @Inject(method={"<init>()V"}, at={@At(value="TAIL")})
    public void constructEmpty(CallbackInfo ci) {
        this.lightEngine = new StarLightInterface(null, false, false, (class_3568)this);
    }

    @Inject(method={"<init>(Lnet/minecraft/class_2823;ZZ)V"}, at={@At(value="TAIL")})
    public void construct(class_2823 chunkProvider, boolean hasBlockLight, boolean hasSkyLight, CallbackInfo ci) {
        this.lightEngine = chunkProvider.method_16399() instanceof class_1937 ? new StarLightInterface(chunkProvider, hasSkyLight, hasBlockLight, (class_3568)this) : new StarLightInterface(null, hasSkyLight, hasBlockLight, (class_3568)this);
        this.field_15814 = null;
        this.field_15813 = null;
    }

    @Overwrite
    public void method_15513(class_2338 pos) {
        this.lightEngine.blockChange(pos.method_10062());
    }

    @Overwrite
    public boolean method_15518() {
        return this.lightEngine.hasUpdates();
    }

    @Overwrite
    public int method_15516() {
        boolean hadUpdates = this.method_15518();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Overwrite
    public void method_15551(class_4076 pos, boolean notReady) {
        this.lightEngine.sectionChange(pos, notReady);
    }

    @Overwrite
    public void method_15512(class_1923 pos, boolean lightEnabled) {
    }

    @Overwrite
    public void method_51471(class_1923 param0) {
    }

    @Overwrite
    public class_3562 method_15562(class_1944 lightType) {
        return lightType == class_1944.field_9282 ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    @Overwrite
    public void method_15558(class_1944 lightType, class_4076 pos, @Nullable class_2804 nibble) {
    }

    @Overwrite
    public String method_22876(class_1944 lightType, class_4076 pos) {
        return "n/a";
    }

    @Overwrite
    public void method_20601(class_1923 pos, boolean retainData) {
    }

    @Overwrite
    public int method_22363(class_2338 pos, int ambientDarkness) {
        return this.lightEngine.getRawBrightness(pos, ambientDarkness);
    }

    @Overwrite
    public boolean method_62874(long pos) {
        long key = CoordinateUtils.getChunkKey(CoordinateUtils.getChunkSectionX(pos), CoordinateUtils.getChunkSectionZ(pos));
        return !(this.lightEngine.hasBlockLight() && this.blockLightMap.get(key) == null || this.lightEngine.hasSkyLight() && this.skyLightMap.get(key) == null);
    }

    @Override
    public void starlight$clientUpdateLight(class_1944 lightType, class_4076 pos, class_2804 nibble, boolean trustEdges) {
        if (this.getClass() != class_3568.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        class_2791 chunk = this.starlight$getLightEngine().getAnyChunkNow(pos.method_10263(), pos.method_10260());
        switch (lightType) {
            case field_9282: {
                SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((class_5539)this.lightEngine.getWorld()));
                blockNibbles[pos.method_10264() - WorldUtil.getMinLightSection((class_5539)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((StarlightChunk)chunk).starlight$setBlockNibbles(blockNibbles);
                this.lightEngine.getLightAccess().method_12247(class_1944.field_9282, pos);
                break;
            }
            case field_9284: {
                SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((class_5539)this.lightEngine.getWorld()));
                skyNibbles[pos.method_10264() - WorldUtil.getMinLightSection((class_5539)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((StarlightChunk)chunk).starlight$setSkyNibbles(skyNibbles);
                this.lightEngine.getLightAccess().method_12247(class_1944.field_9284, pos);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown light type: " + String.valueOf(lightType));
            }
        }
    }

    @Override
    public void starlight$clientRemoveLightData(class_1923 chunkPos) {
        if (this.getClass() != class_3568.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        this.blockLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
        this.skyLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
    }

    @Override
    public void starlight$clientChunkLoad(class_1923 pos, class_2818 chunk) {
        if (this.getClass() != class_3568.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        long key = CoordinateUtils.getChunkKey(pos);
        SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.get(key);
        SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.get(key);
        if (blockNibbles != null) {
            ((StarlightChunk)chunk).starlight$setBlockNibbles(blockNibbles);
        }
        if (skyNibbles != null) {
            ((StarlightChunk)chunk).starlight$setSkyNibbles(skyNibbles);
        }
    }
}

