/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.player;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter;
import ca.spottedleaf.moonrise.common.misc.SingleUserAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import ca.spottedleaf.moonrise.patches.chunk_system.util.ParallelSearchRadiusIteration;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2666;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3244;
import net.minecraft.class_4273;
import net.minecraft.class_4282;
import net.minecraft.class_6682;
import net.minecraft.class_6746;
import net.minecraft.class_8603;
import net.minecraft.class_8608;

public final class RegionizedPlayerChunkLoader {
    public static final class_3230 PLAYER_TICKET = ChunkSystemTicketType.create("chunk_system:player_ticket", Long::compareTo, 0L, 14);
    public static final class_3230 PLAYER_TICKET_DELAYED = ChunkSystemTicketType.create("chunk_system:player_ticket_delayed", Long::compareTo, 1L, 14);
    public static final int GENERATED_TICKET_LEVEL = 33;
    public static final int LOADED_TICKET_LEVEL = ChunkTaskScheduler.getTicketLevel(class_2806.field_12798);
    public static final int TICK_TICKET_LEVEL = 31;
    private final class_3218 world;

    public static void setUnloadDelay(long ticks) {
        ((ChunkSystemTicketType)PLAYER_TICKET_DELAYED).moonrise$setTimeout(Math.max(1L, ticks));
    }

    public static int getAPITickViewDistance(class_3222 player) {
        class_3218 level = player.method_51469();
        PlayerChunkLoaderData data = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (data == null) {
            return ((ChunkSystemServerLevel)level).moonrise$getPlayerChunkLoader().getAPITickDistance();
        }
        return data.lastTickDistance;
    }

    public static int getAPIViewDistance(class_3222 player) {
        class_3218 level = player.method_51469();
        PlayerChunkLoaderData data = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (data == null) {
            return ((ChunkSystemServerLevel)level).moonrise$getPlayerChunkLoader().getAPIViewDistance();
        }
        return data.lastLoadDistance - 1;
    }

    public static int getAPISendViewDistance(class_3222 player) {
        class_3218 level = player.method_51469();
        PlayerChunkLoaderData data = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (data == null) {
            return ((ChunkSystemServerLevel)level).moonrise$getPlayerChunkLoader().getAPISendViewDistance();
        }
        return data.lastSendDistance;
    }

    public RegionizedPlayerChunkLoader(class_3218 world) {
        this.world = world;
    }

    public void addPlayer(class_3222 player) {
        TickThread.ensureTickThread((class_1297)player, "Cannot add player to player chunk loader async");
        if (!((ChunkSystemServerPlayer)player).moonrise$isRealPlayer()) {
            return;
        }
        if (((ChunkSystemServerPlayer)player).moonrise$getChunkLoader() != null) {
            throw new IllegalStateException("Player is already added to player chunk loader");
        }
        PlayerChunkLoaderData loader = new PlayerChunkLoaderData(this.world, player);
        ((ChunkSystemServerPlayer)player).moonrise$setChunkLoader(loader);
        loader.add();
    }

    public void updatePlayer(class_3222 player) {
        PlayerChunkLoaderData loader = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (loader != null) {
            loader.update();
            ((ChunkSystemServerLevel)loader.world).moonrise$getNearbyPlayers().tickPlayer(player);
        }
    }

    public void removePlayer(class_3222 player) {
        TickThread.ensureTickThread((class_1297)player, "Cannot remove player from player chunk loader async");
        if (!((ChunkSystemServerPlayer)player).moonrise$isRealPlayer()) {
            return;
        }
        PlayerChunkLoaderData loader = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (loader == null) {
            return;
        }
        loader.remove();
        ((ChunkSystemServerPlayer)player).moonrise$setChunkLoader(null);
    }

    public void setSendDistance(int distance) {
        ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().setSendViewDistance(distance);
    }

    public void setLoadDistance(int distance) {
        ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().setLoadViewDistance(distance);
    }

    public void setTickDistance(int distance) {
        ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().setTickViewDistance(distance);
    }

    public int getAPITickDistance() {
        ViewDistances distances = ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        return tickViewDistance;
    }

    public int getAPIViewDistance() {
        ViewDistances distances = ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        return loadDistance - 1;
    }

    public int getAPISendViewDistance() {
        ViewDistances distances = ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance, -1, distances.loadViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadDistance, -1, -1, distances.sendViewDistance);
        return sendViewDistance;
    }

    public boolean isChunkSent(class_3222 player, int chunkX, int chunkZ, boolean borderOnly) {
        return borderOnly ? this.isChunkSentBorderOnly(player, chunkX, chunkZ) : this.isChunkSent(player, chunkX, chunkZ);
    }

    public boolean isChunkSent(class_3222 player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (loader == null) {
            return false;
        }
        return loader.sentChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public boolean isChunkSentBorderOnly(class_3222 player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
        if (loader == null) {
            return false;
        }
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (loader.sentChunks.contains(CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ))) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        TickThread.ensureTickThread("Cannot tick player chunk loader async");
        long currTime = System.nanoTime();
        for (class_3222 player : new ArrayList(this.world.method_18456())) {
            PlayerChunkLoaderData loader = ((ChunkSystemServerPlayer)player).moonrise$getChunkLoader();
            if (loader == null || loader.removed || loader.world != this.world) continue;
            loader.update();
            loader.updateQueues(currTime);
        }
    }

    public static final class PlayerChunkLoaderData {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.incrementAndGet();
        private final Long idBoxed = this.id;
        private static final long MAX_RATE = 10000L;
        private final class_3222 player;
        private final class_3218 world;
        private int lastChunkX = Integer.MIN_VALUE;
        private int lastChunkZ = Integer.MIN_VALUE;
        private int lastSendDistance = Integer.MIN_VALUE;
        private int lastLoadDistance = Integer.MIN_VALUE;
        private int lastTickDistance = Integer.MIN_VALUE;
        private int lastSentChunkCenterX = Integer.MIN_VALUE;
        private int lastSentChunkCenterZ = Integer.MIN_VALUE;
        private int lastSentChunkRadius = Integer.MIN_VALUE;
        private int lastSentSimulationDistance = Integer.MIN_VALUE;
        private boolean canGenerateChunks = true;
        private final ArrayDeque<ChunkHolderManager.TicketOperation<?, ?>> delayedTicketOps = new ArrayDeque();
        private final LongOpenHashSet sentChunks = new LongOpenHashSet();
        private static final byte CHUNK_TICKET_STAGE_NONE = 0;
        private static final byte CHUNK_TICKET_STAGE_LOADING = 1;
        private static final byte CHUNK_TICKET_STAGE_LOADED = 2;
        private static final byte CHUNK_TICKET_STAGE_GENERATING = 3;
        private static final byte CHUNK_TICKET_STAGE_GENERATED = 4;
        private static final byte CHUNK_TICKET_STAGE_TICK = 5;
        private static final int[] TICKET_STAGE_TO_LEVEL = new int[]{ChunkHolderManager.MAX_TICKET_LEVEL + 1, LOADED_TICKET_LEVEL, LOADED_TICKET_LEVEL, 33, 33, 31};
        private final Long2ByteOpenHashMap chunkTicketStage = new Long2ByteOpenHashMap();
        private static final long ALLOCATION_GRANULARITY = TimeUnit.SECONDS.toNanos(1L);
        private final AllocatingRateLimiter chunkSendLimiter;
        private final AllocatingRateLimiter chunkLoadTicketLimiter;
        private final AllocatingRateLimiter chunkGenerateTicketLimiter;
        private final LongComparator CLOSEST_MANHATTAN_DIST;
        private final LongHeapPriorityQueue sendQueue;
        private final LongHeapPriorityQueue tickingQueue;
        private final LongHeapPriorityQueue generatingQueue;
        private final LongHeapPriorityQueue genQueue;
        private final LongHeapPriorityQueue loadingQueue;
        private final LongHeapPriorityQueue loadQueue;
        private volatile boolean removed;
        private final SingleUserAreaMap<PlayerChunkLoaderData> broadcastMap;
        private final SingleUserAreaMap<PlayerChunkLoaderData> loadTicketCleanup;
        private final SingleUserAreaMap<PlayerChunkLoaderData> tickMap;

        public PlayerChunkLoaderData(class_3218 world, class_3222 player) {
            this.chunkTicketStage.defaultReturnValue((byte)0);
            this.chunkSendLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.chunkLoadTicketLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.chunkGenerateTicketLimiter = new AllocatingRateLimiter(ALLOCATION_GRANULARITY);
            this.CLOSEST_MANHATTAN_DIST = (c1, c2) -> {
                int c1x = CoordinateUtils.getChunkX(c1);
                int c1z = CoordinateUtils.getChunkZ(c1);
                int c2x = CoordinateUtils.getChunkX(c2);
                int c2z = CoordinateUtils.getChunkZ(c2);
                int centerX = this.lastChunkX;
                int centerZ = this.lastChunkZ;
                return Integer.compare(Math.abs(c1x - centerX) + Math.abs(c1z - centerZ), Math.abs(c2x - centerX) + Math.abs(c2z - centerZ));
            };
            this.sendQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.tickingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.generatingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.genQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.broadcastMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    parameter.sendUnloadChunk(chunkX, chunkZ);
                }
            };
            this.loadTicketCleanup = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    byte ticketStage = parameter.chunkTicketStage.remove(chunk);
                    int level = TICKET_STAGE_TO_LEVEL[ticketStage];
                    if (level > ChunkHolderManager.MAX_TICKET_LEVEL) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, PLAYER_TICKET_DELAYED, level, parameter.idBoxed, PLAYER_TICKET, level, parameter.idBoxed));
                }
            };
            this.tickMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    if (!parameter.chunkTicketStage.replace(chunk, (byte)5, (byte)4)) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, PLAYER_TICKET_DELAYED, 31, parameter.idBoxed, PLAYER_TICKET, 31, parameter.idBoxed));
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk, PLAYER_TICKET, 33, parameter.idBoxed));
                }
            };
            this.world = world;
            this.player = player;
        }

        private void flushDelayedTicketOps() {
            if (this.delayedTicketOps.isEmpty()) {
                return;
            }
            ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.performTicketUpdates(this.delayedTicketOps);
            this.delayedTicketOps.clear();
        }

        private void pushDelayedTicketOp(ChunkHolderManager.TicketOperation<?, ?> op) {
            this.delayedTicketOps.addLast(op);
        }

        private void sendChunk(int chunkX, int chunkZ) {
            if (this.sentChunks.add(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                ((ChunkSystemChunkHolder)((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder((int)chunkX, (int)chunkZ).vanillaChunkHolder).moonrise$addReceivedChunk(this.player);
                class_2818 chunk = ((ChunkSystemLevel)this.world).moonrise$getFullChunkIfLoaded(chunkX, chunkZ);
                PlatformHooks.get().onChunkWatch(this.world, chunk, this.player);
                class_8608.method_52388((class_3244)this.player.field_13987, (class_3218)this.world, (class_2818)chunk);
                return;
            }
            throw new IllegalStateException();
        }

        private void sendUnloadChunk(int chunkX, int chunkZ) {
            if (!this.sentChunks.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                return;
            }
            this.sendUnloadChunkRaw(chunkX, chunkZ);
        }

        private void sendUnloadChunkRaw(int chunkX, int chunkZ) {
            PlatformHooks.get().onChunkUnWatch(this.world, new class_1923(chunkX, chunkZ), this.player);
            ((ChunkSystemChunkHolder)((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder((int)chunkX, (int)chunkZ).vanillaChunkHolder).moonrise$removeReceivedChunk(this.player);
            this.player.field_13987.method_14364((class_2596)new class_2666(new class_1923(chunkX, chunkZ)));
        }

        private static boolean wantChunkLoaded(int centerX, int centerZ, int chunkX, int chunkZ, int sendRadius) {
            return class_8603.method_52358((int)centerX, (int)centerZ, (int)sendRadius, (int)chunkX, (int)chunkZ, (boolean)true);
        }

        private static int getClientViewDistance(class_3222 player) {
            Integer vd = player.method_52371();
            return vd == null ? -1 : Math.max(0, vd);
        }

        private static int getTickDistance(int playerTickViewDistance, int worldTickViewDistance, int playerLoadViewDistance, int worldLoadViewDistance) {
            return Math.min(playerTickViewDistance < 0 ? worldTickViewDistance : playerTickViewDistance, playerLoadViewDistance < 0 ? worldLoadViewDistance - 1 : playerLoadViewDistance - 1);
        }

        private static int getLoadViewDistance(int tickViewDistance, int playerLoadViewDistance, int worldLoadViewDistance) {
            return Math.max(tickViewDistance + 1, playerLoadViewDistance < 0 ? worldLoadViewDistance : playerLoadViewDistance);
        }

        private static int getSendViewDistance(int loadViewDistance, int clientViewDistance, int playerSendViewDistance, int worldSendViewDistance) {
            return Math.min(loadViewDistance - 1, playerSendViewDistance < 0 ? (!PlatformHooks.get().configAutoConfigSendDistance() || clientViewDistance < 0 ? (worldSendViewDistance < 0 ? loadViewDistance - 1 : worldSendViewDistance) : clientViewDistance + 1) : playerSendViewDistance);
        }

        private class_2596<?> updateClientChunkRadius(int radius) {
            this.lastSentChunkRadius = radius;
            return new class_4273(radius);
        }

        private class_2596<?> updateClientSimulationDistance(int distance) {
            this.lastSentSimulationDistance = distance;
            return new class_6682(distance);
        }

        private class_2596<?> updateClientChunkCenter(int chunkX, int chunkZ) {
            this.lastSentChunkCenterX = chunkX;
            this.lastSentChunkCenterZ = chunkZ;
            return new class_4282(chunkX, chunkZ);
        }

        private boolean canPlayerGenerateChunks() {
            return !this.player.method_7325() || this.world.method_64395().method_8355(class_1928.field_19402);
        }

        private double getMaxChunkLoadRate() {
            double configRate = PlatformHooks.get().configPlayerMaxLoadRate();
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkGenRate() {
            double configRate = PlatformHooks.get().configPlayerMaxGenRate();
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkSendRate() {
            double configRate = PlatformHooks.get().configPlayerMaxSendRate();
            return configRate <= 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private long getMaxChunkLoads() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = PlatformHooks.get().configPlayerMaxConcurrentLoads();
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.loadingQueue.size();
        }

        private long getMaxChunkGenerates() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = PlatformHooks.get().configPlayerMaxConcurrentGens();
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.generatingQueue.size();
        }

        private boolean wantChunkSent(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastSendDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(this.lastChunkX, this.lastChunkZ, chunkX, chunkZ, this.lastSendDistance);
        }

        private boolean wantChunkTicked(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastTickDistance;
        }

        private boolean areNeighboursGenerated(int chunkX, int chunkZ, int radius) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    long neighbour;
                    byte stage;
                    if ((dx | dz) == 0 || (stage = this.chunkTicketStage.get(neighbour = CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ))) == 4 || stage == 5) continue;
                    return false;
                }
            }
            return true;
        }

        void updateQueues(long time) {
            int pendingChunkZ;
            long pendingTicking;
            int pendingChunkX;
            int pendingChunkZ2;
            long pendingGenChunk;
            int pendingChunkX2;
            class_2818 pending;
            int pendingChunkZ3;
            long pendingLoadChunk;
            int pendingChunkX3;
            class_2791 pending2;
            TickThread.ensureTickThread((class_1297)this.player, "Cannot tick player chunk loader async");
            if (this.removed) {
                throw new IllegalStateException("Ticking removed player chunk loader");
            }
            double loadRate = this.getMaxChunkLoadRate();
            double genRate = this.getMaxChunkGenRate();
            double sendRate = this.getMaxChunkSendRate();
            this.chunkLoadTicketLimiter.tickAllocation(time, loadRate, loadRate);
            this.chunkGenerateTicketLimiter.tickAllocation(time, genRate, genRate);
            this.chunkSendLimiter.tickAllocation(time, sendRate, sendRate);
            while (!this.loadingQueue.isEmpty() && (pending2 = ((ChunkSystemLevel)this.world).moonrise$getAnyChunkIfLoaded(pendingChunkX3 = CoordinateUtils.getChunkX(pendingLoadChunk = this.loadingQueue.firstLong()), pendingChunkZ3 = CoordinateUtils.getChunkZ(pendingLoadChunk))) != null) {
                this.loadingQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(pendingLoadChunk, (byte)2);
                if (prev != 1) {
                    throw new IllegalStateException("Previous state should be 1, not " + prev);
                }
                if (!this.canGenerateChunks && !this.isLoadedChunkGeneratable(pending2)) continue;
                this.genQueue.enqueue(pendingLoadChunk);
            }
            long maxLoads = Math.max(0L, Math.min(10000L, Math.min((long)this.loadQueue.size(), this.getMaxChunkLoads())));
            int maxLoadsThisTick = (int)this.chunkLoadTicketLimiter.takeAllocation(time, loadRate, maxLoads);
            if (maxLoadsThisTick > 0) {
                int i;
                LongArrayList chunks = new LongArrayList(maxLoadsThisTick);
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long chunk = this.loadQueue.dequeueLong();
                    byte prev = this.chunkTicketStage.put(chunk, (byte)1);
                    if (prev != 0) {
                        throw new IllegalStateException("Previous state should be 0, not " + prev);
                    }
                    this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk, PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                    chunks.add(chunk);
                    this.loadingQueue.enqueue(chunk);
                }
                this.flushDelayedTicketOps();
                ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
                if (this.removed) {
                    return;
                }
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long queuedLoadChunk = chunks.getLong(i);
                    int queuedChunkX = CoordinateUtils.getChunkX(queuedLoadChunk);
                    int queuedChunkZ = CoordinateUtils.getChunkZ(queuedLoadChunk);
                    ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().scheduleChunkLoad(queuedChunkX, queuedChunkZ, class_2806.field_12798, false, Priority.NORMAL, null);
                    if (!this.removed) continue;
                    return;
                }
            }
            while (!this.generatingQueue.isEmpty() && (pending = ((ChunkSystemLevel)this.world).moonrise$getFullChunkIfLoaded(pendingChunkX2 = CoordinateUtils.getChunkX(pendingGenChunk = this.generatingQueue.firstLong()), pendingChunkZ2 = CoordinateUtils.getChunkZ(pendingGenChunk))) != null) {
                this.generatingQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(pendingGenChunk, (byte)4);
                if (prev != 3) {
                    throw new IllegalStateException("Previous state should be 3, not " + prev);
                }
                if (this.wantChunkSent(pendingChunkX2, pendingChunkZ2)) {
                    this.sendQueue.enqueue(pendingGenChunk);
                }
                if (!this.wantChunkTicked(pendingChunkX2, pendingChunkZ2)) continue;
                this.tickingQueue.enqueue(pendingGenChunk);
            }
            long maxGens = Math.max(0L, Math.min(10000L, Math.min((long)this.genQueue.size(), this.getMaxChunkGenerates())));
            long maxGensThisTick = this.chunkGenerateTicketLimiter.previewAllocation(time, genRate, maxGens);
            long ratedGensThisTick = 0L;
            while (!this.genQueue.isEmpty()) {
                int chunkZ;
                long chunkKey = this.genQueue.firstLong();
                int chunkX = CoordinateUtils.getChunkX(chunkKey);
                class_2791 chunk = ((ChunkSystemLevel)this.world).moonrise$getAnyChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkZ(chunkKey));
                if (chunk.method_12009() != class_2806.field_12803) {
                    if (ratedGensThisTick + 1L > maxGensThisTick) break;
                    ++ratedGensThisTick;
                }
                this.genQueue.dequeueLong();
                byte prev = this.chunkTicketStage.put(chunkKey, (byte)3);
                if (prev != 2) {
                    throw new IllegalStateException("Previous state should be 2, not " + prev);
                }
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunkKey, PLAYER_TICKET, 33, this.idBoxed, PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                this.generatingQueue.enqueue(chunkKey);
            }
            this.chunkGenerateTicketLimiter.takeAllocation(time, genRate, ratedGensThisTick);
            while (!this.tickingQueue.isEmpty() && this.areNeighboursGenerated(pendingChunkX = CoordinateUtils.getChunkX(pendingTicking = this.tickingQueue.firstLong()), pendingChunkZ = CoordinateUtils.getChunkZ(pendingTicking), 2)) {
                this.tickingQueue.dequeueLong();
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(pendingTicking, PLAYER_TICKET, 31, this.idBoxed, PLAYER_TICKET, 33, this.idBoxed));
                byte prev = this.chunkTicketStage.put(pendingTicking, (byte)5);
                if (prev == 4) continue;
                throw new IllegalStateException("Previous state should be 4, not " + prev);
            }
            long maxSends = Math.max(0L, Math.min(10000L, Integer.MAX_VALUE));
            int maxSendsThisTick = Math.min((int)this.chunkSendLimiter.takeAllocation(time, sendRate, maxSends), this.sendQueue.size());
            for (int i = 0; i < maxSendsThisTick; ++i) {
                long pendingSend = this.sendQueue.firstLong();
                int pendingSendX = CoordinateUtils.getChunkX(pendingSend);
                int pendingSendZ = CoordinateUtils.getChunkZ(pendingSend);
                class_2818 chunk = ((ChunkSystemLevel)this.world).moonrise$getFullChunkIfLoaded(pendingSendX, pendingSendZ);
                if (!this.areNeighboursGenerated(pendingSendX, pendingSendZ, 1) || !TickThread.isTickThreadFor((class_1937)this.world, pendingSendX, pendingSendZ)) break;
                if (!((ChunkSystemLevelChunk)chunk).moonrise$isPostProcessingDone()) {
                    chunk.method_12221(this.world);
                    if (this.removed || this.sendQueue.isEmpty() || this.sendQueue.firstLong() != pendingSend) {
                        return;
                    }
                }
                this.sendQueue.dequeueLong();
                this.sendChunk(pendingSendX, pendingSendZ);
                if (!this.removed) continue;
                return;
            }
            this.flushDelayedTicketOps();
        }

        void add() {
            TickThread.ensureTickThread((class_1297)this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Adding removed player chunk loader");
            }
            ViewDistances playerDistances = ((ChunkSystemServerPlayer)this.player).moonrise$getViewDistanceHolder().getViewDistances();
            ViewDistances worldDistances = ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().getViewDistances();
            int chunkX = this.player.method_31476().field_9181;
            int chunkZ = this.player.method_31476().field_9180;
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            this.player.field_13987.method_14364(this.updateClientChunkRadius(sendViewDistance));
            this.player.field_13987.method_14364(this.updateClientSimulationDistance(tickViewDistance));
            this.broadcastMap.add(chunkX, chunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.add(chunkX, chunkZ, loadViewDistance + 1);
            this.tickMap.add(chunkX, chunkZ, tickViewDistance);
            this.player.field_13987.method_14364(this.updateClientChunkCenter(chunkX, chunkZ));
            long time = System.nanoTime();
            this.chunkLoadTicketLimiter.reset(time);
            this.chunkGenerateTicketLimiter.reset(time);
            this.chunkSendLimiter.reset(time);
            this.update();
        }

        private boolean isLoadedChunkGeneratable(int chunkX, int chunkZ) {
            return this.isLoadedChunkGeneratable(((ChunkSystemLevel)this.world).moonrise$getAnyChunkIfLoaded(chunkX, chunkZ));
        }

        private boolean isLoadedChunkGeneratable(class_2791 chunkAccess) {
            class_6746 belowZeroRetrogen;
            return chunkAccess != null && (chunkAccess.method_12009() == class_2806.field_12803 || (belowZeroRetrogen = chunkAccess.method_39300()) != null && belowZeroRetrogen.method_39319().method_12165(class_2806.field_12786));
        }

        void update() {
            long[] toIterate;
            TickThread.ensureTickThread((class_1297)this.player, "Cannot update player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Updating removed player chunk loader");
            }
            ViewDistances playerDistances = ((ChunkSystemServerPlayer)this.player).moonrise$getViewDistanceHolder().getViewDistances();
            ViewDistances worldDistances = ((ChunkSystemServerLevel)this.world).moonrise$getViewDistanceHolder().getViewDistances();
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            class_1923 playerPos = this.player.method_31476();
            boolean canGenerateChunks = this.canPlayerGenerateChunks();
            int currentChunkX = playerPos.field_9181;
            int currentChunkZ = playerPos.field_9180;
            int prevChunkX = this.lastChunkX;
            int prevChunkZ = this.lastChunkZ;
            if (sendViewDistance == this.lastSendDistance && loadViewDistance == this.lastLoadDistance && tickViewDistance == this.lastTickDistance && prevChunkX == currentChunkX && prevChunkZ == currentChunkZ && this.canGenerateChunks == canGenerateChunks) {
                return;
            }
            this.broadcastMap.update(currentChunkX, currentChunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.update(currentChunkX, currentChunkZ, loadViewDistance + 1);
            this.tickMap.update(currentChunkX, currentChunkZ, tickViewDistance);
            if (sendViewDistance > loadViewDistance || tickViewDistance > loadViewDistance) {
                throw new IllegalStateException();
            }
            if (this.lastSentChunkRadius != sendViewDistance) {
                this.player.field_13987.method_14364(this.updateClientChunkRadius(sendViewDistance));
            }
            if (this.lastSentSimulationDistance != tickViewDistance) {
                this.player.field_13987.method_14364(this.updateClientSimulationDistance(tickViewDistance));
            }
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.lastChunkX = currentChunkX;
            this.lastChunkZ = currentChunkZ;
            this.lastSendDistance = sendViewDistance;
            this.lastLoadDistance = loadViewDistance;
            this.lastTickDistance = tickViewDistance;
            this.canGenerateChunks = canGenerateChunks;
            block8: for (long deltaChunk : toIterate = ParallelSearchRadiusIteration.getSearchIteration(loadViewDistance + 1)) {
                boolean sentChunk;
                int dx = CoordinateUtils.getChunkX(deltaChunk);
                int dz = CoordinateUtils.getChunkZ(deltaChunk);
                int chunkX = dx + currentChunkX;
                int chunkZ = dz + currentChunkZ;
                long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                int squareDistance = Math.max(Math.abs(dx), Math.abs(dz));
                int manhattanDistance = Math.abs(dx) + Math.abs(dz);
                boolean sendChunk = squareDistance <= sendViewDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(currentChunkX, currentChunkZ, chunkX, chunkZ, sendViewDistance);
                boolean bl = sentChunk = sendChunk ? this.sentChunks.contains(chunk) : this.sentChunks.remove(chunk);
                if (!sendChunk && sentChunk) {
                    this.sendUnloadChunkRaw(chunkX, chunkZ);
                }
                byte stage = this.chunkTicketStage.get(chunk);
                switch (stage) {
                    case 0: {
                        this.loadQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 1: {
                        this.loadingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 2: {
                        if (!canGenerateChunks && !this.isLoadedChunkGeneratable(chunkX, chunkZ)) continue block8;
                        this.genQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 3: {
                        this.generatingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 4: {
                        if (sendChunk && !sentChunk) {
                            this.sendQueue.enqueue(chunk);
                        }
                        if (squareDistance > tickViewDistance) continue block8;
                        this.tickingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 5: {
                        if (!sendChunk || sentChunk) continue block8;
                        this.sendQueue.enqueue(chunk);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unknown stage: " + stage);
                    }
                }
            }
            if (this.lastSentChunkCenterX != currentChunkX || this.lastSentChunkCenterZ != currentChunkZ) {
                this.player.field_13987.method_14364(this.updateClientChunkCenter(currentChunkX, currentChunkZ));
            }
            this.flushDelayedTicketOps();
        }

        void remove() {
            TickThread.ensureTickThread((class_1297)this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Removing removed player chunk loader");
            }
            this.removed = true;
            this.broadcastMap.remove();
            this.loadTicketCleanup.remove();
            this.tickMap.remove();
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.flushDelayedTicketOps();
        }

        public LongOpenHashSet getSentChunksRaw() {
            return this.sentChunks;
        }
    }

    public static final class ViewDistanceHolder {
        private volatile ViewDistances viewDistances;
        private static final VarHandle VIEW_DISTANCES_HANDLE = ConcurrentUtil.getVarHandle(ViewDistanceHolder.class, "viewDistances", ViewDistances.class);

        public ViewDistanceHolder() {
            VIEW_DISTANCES_HANDLE.setVolatile(this, new ViewDistances(-1, -1, -1));
        }

        public ViewDistances getViewDistances() {
            return VIEW_DISTANCES_HANDLE.getVolatile(this);
        }

        public ViewDistances compareAndExchangeViewDistance(ViewDistances expect, ViewDistances update) {
            return VIEW_DISTANCES_HANDLE.compareAndExchange(this, expect, update);
        }

        public void updateViewDistance(Function<ViewDistances, ViewDistances> update) {
            int failures = 0;
            ViewDistances curr = this.getViewDistances();
            while (true) {
                for (int i = 0; i < failures; ++i) {
                    ConcurrentUtil.backoff();
                }
                if (curr == (curr = this.compareAndExchangeViewDistance(curr, update.apply(curr)))) {
                    return;
                }
                ++failures;
            }
        }

        public void setTickViewDistance(int distance) {
            this.updateViewDistance(param -> param.setTickViewDistance(distance));
        }

        public void setLoadViewDistance(int distance) {
            this.updateViewDistance(param -> param.setLoadViewDistance(distance));
        }

        public void setSendViewDistance(int distance) {
            this.updateViewDistance(param -> param.setSendViewDistance(distance));
        }

        public JsonObject toJson() {
            return this.getViewDistances().toJson();
        }
    }

    public record ViewDistances(int tickViewDistance, int loadViewDistance, int sendViewDistance) {
        public ViewDistances setTickViewDistance(int distance) {
            if (distance != -1 && (distance < 0 || distance > MoonriseConstants.MAX_VIEW_DISTANCE)) {
                throw new IllegalArgumentException(Integer.toString(distance));
            }
            return new ViewDistances(distance, this.loadViewDistance, this.sendViewDistance);
        }

        public ViewDistances setLoadViewDistance(int distance) {
            if (distance != -1 && (distance < 3 || distance > MoonriseConstants.MAX_VIEW_DISTANCE + 1)) {
                throw new IllegalArgumentException(Integer.toString(distance));
            }
            return new ViewDistances(this.tickViewDistance, distance, this.sendViewDistance);
        }

        public ViewDistances setSendViewDistance(int distance) {
            if (distance != -1 && (distance < 0 || distance > MoonriseConstants.MAX_VIEW_DISTANCE)) {
                throw new IllegalArgumentException(Integer.toString(distance));
            }
            return new ViewDistances(this.tickViewDistance, this.loadViewDistance, distance);
        }

        public JsonObject toJson() {
            JsonObject ret = new JsonObject();
            ret.addProperty("tick-view-distance", (Number)this.tickViewDistance);
            ret.addProperty("load-view-distance", (Number)this.loadViewDistance);
            ret.addProperty("send-view-distance", (Number)this.sendViewDistance);
            return ret;
        }
    }
}

