/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_244;
import net.minecraft.class_245;
import net.minecraft.class_247;
import net.minecraft.class_251;
import net.minecraft.class_259;
import net.minecraft.class_261;
import net.minecraft.class_263;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4970;

public final class CollisionUtil {
    public static final double COLLISION_EPSILON = 1.0E-7;
    public static final DoubleArrayList ZERO_ONE = DoubleArrayList.wrap((double[])new double[]{0.0, 1.0});
    private static final boolean DEBUG_SLICE_SHAPE = false;
    public static final int COLLISION_FLAG_LOAD_CHUNKS = 1;
    public static final int COLLISION_FLAG_COLLIDE_WITH_UNLOADED_CHUNKS = 2;
    public static final int COLLISION_FLAG_CHECK_BORDER = 4;
    public static final int COLLISION_FLAG_CHECK_ONLY = 8;

    public static boolean isSpecialCollidingBlock(class_4970.class_4971 block) {
        return block.method_26209() || block.method_26204() == class_2246.field_10008;
    }

    public static boolean isEmpty(class_238 aabb) {
        return aabb.field_1320 - aabb.field_1323 < 1.0E-7 || aabb.field_1325 - aabb.field_1322 < 1.0E-7 || aabb.field_1324 - aabb.field_1321 < 1.0E-7;
    }

    public static boolean isEmpty(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7;
    }

    public static class_238 getBoxForChunk(int chunkX, int chunkZ) {
        double x = chunkX << 4;
        double z = chunkZ << 4;
        return new class_238(x - 3.0E-7, Double.NEGATIVE_INFINITY, z - 3.0E-7, x + 16.0000003, Double.POSITIVE_INFINITY, z + 16.0000003);
    }

    public static boolean voxelShapeIntersect(double minX1, double minY1, double minZ1, double maxX1, double maxY1, double maxZ1, double minX2, double minY2, double minZ2, double maxX2, double maxY2, double maxZ2) {
        return minX1 - maxX2 < -1.0E-7 && maxX1 - minX2 > 1.0E-7 && minY1 - maxY2 < -1.0E-7 && maxY1 - minY2 > 1.0E-7 && minZ1 - maxZ2 < -1.0E-7 && maxZ1 - minZ2 > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(class_238 box, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return box.field_1323 - maxX < -1.0E-7 && box.field_1320 - minX > 1.0E-7 && box.field_1322 - maxY < -1.0E-7 && box.field_1325 - minY > 1.0E-7 && box.field_1321 - maxZ < -1.0E-7 && box.field_1324 - minZ > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(class_238 box1, class_238 box2) {
        return box1.field_1323 - box2.field_1320 < -1.0E-7 && box1.field_1320 - box2.field_1323 > 1.0E-7 && box1.field_1322 - box2.field_1325 < -1.0E-7 && box1.field_1325 - box2.field_1322 > 1.0E-7 && box1.field_1321 - box2.field_1324 < -1.0E-7 && box1.field_1324 - box2.field_1321 > 1.0E-7;
    }

    public static double collideX(class_238 target, class_238 source, double source_move) {
        if (source.field_1322 - target.field_1325 < -1.0E-7 && source.field_1325 - target.field_1322 > 1.0E-7 && source.field_1321 - target.field_1324 < -1.0E-7 && source.field_1324 - target.field_1321 > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.field_1323 - source.field_1320;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.field_1320 - source.field_1323;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideY(class_238 target, class_238 source, double source_move) {
        if (source.field_1323 - target.field_1320 < -1.0E-7 && source.field_1320 - target.field_1323 > 1.0E-7 && source.field_1321 - target.field_1324 < -1.0E-7 && source.field_1324 - target.field_1321 > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.field_1322 - source.field_1325;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.field_1325 - source.field_1322;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideZ(class_238 target, class_238 source, double source_move) {
        if (source.field_1323 - target.field_1320 < -1.0E-7 && source.field_1320 - target.field_1323 > 1.0E-7 && source.field_1322 - target.field_1325 < -1.0E-7 && source.field_1325 - target.field_1322 > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.field_1321 - source.field_1324;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.field_1324 - source.field_1321;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static int findFloor(double[] values, double offset, double value, int startIndex, int endIndex) {
        Objects.checkFromToIndex(startIndex, endIndex + 1, values.length);
        do {
            int middle;
            double middleVal;
            if (value < (middleVal = values[middle = startIndex + endIndex >>> 1] + offset)) {
                endIndex = middle - 1;
                continue;
            }
            startIndex = middle + 1;
        } while (startIndex <= endIndex);
        return startIndex - 1;
    }

    private static class_265 sliceShapeVanilla(class_265 src, class_2350.class_2351 axis, int index) {
        return new class_263(src, axis, index);
    }

    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new class_261((DoubleList)wrap, by);
    }

    private static class_265 sliceShapeOptimised(class_265 src, class_2350.class_2351 axis, int index) {
        int shape_ez;
        int shape_sz;
        int shape_ey;
        int shape_sy;
        int shape_ex;
        int shape_sx;
        DoubleList list_z;
        DoubleList list_y;
        DoubleArrayList list_x;
        double off_x = ((CollisionVoxelShape)src).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)src).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)src).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)src).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)src).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)src).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)src).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        long[] bitset = cached_shape_data.voxelSet();
        switch (axis) {
            case field_11048: {
                if (index < 0 || index >= size_x) {
                    return class_259.method_1073();
                }
                if (coords_x.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0) {
                    return src;
                }
                if (coords_y.length == 2 && coords_z.length == 2 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    int bitIdx = 0 + 0 * size_z + index * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? class_259.method_1073() : class_259.method_1077();
                }
                list_x = ZERO_ONE;
                list_y = CollisionUtil.offsetList(coords_y, off_y);
                list_z = CollisionUtil.offsetList(coords_z, off_z);
                shape_sx = index;
                shape_ex = index + 1;
                shape_sy = 0;
                shape_ey = size_y;
                shape_sz = 0;
                shape_ez = size_z;
                break;
            }
            case field_11052: {
                if (index < 0 || index >= size_y) {
                    return class_259.method_1073();
                }
                if (coords_y.length == 2 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0) {
                    return src;
                }
                if (coords_x.length == 2 && coords_z.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    int bitIdx = 0 + index * size_z + 0 * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? class_259.method_1073() : class_259.method_1077();
                }
                list_x = CollisionUtil.offsetList(coords_x, off_x);
                list_y = ZERO_ONE;
                list_z = CollisionUtil.offsetList(coords_z, off_z);
                shape_sx = 0;
                shape_ex = size_x;
                shape_sy = index;
                shape_ey = index + 1;
                shape_sz = 0;
                shape_ez = size_z;
                break;
            }
            case field_11051: {
                if (index < 0 || index >= size_z) {
                    return class_259.method_1073();
                }
                if (coords_z.length == 2 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    return src;
                }
                if (coords_x.length == 2 && coords_y.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0) {
                    int bitIdx = index + 0 * size_z + 0 * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? class_259.method_1073() : class_259.method_1077();
                }
                list_x = CollisionUtil.offsetList(coords_x, off_x);
                list_y = CollisionUtil.offsetList(coords_y, off_y);
                list_z = ZERO_ONE;
                shape_sx = 0;
                shape_ex = size_x;
                shape_sy = 0;
                shape_ey = size_y;
                shape_sz = index;
                shape_ez = index + 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
            }
        }
        int local_len_x = shape_ex - shape_sx;
        int local_len_y = shape_ey - shape_sy;
        int local_len_z = shape_ez - shape_sz;
        class_244 shape = new class_244(local_len_x, local_len_y, local_len_z);
        int bitset_mul_x = size_z * size_y;
        int idx_off = shape_sz + shape_sy * size_z + shape_sx * bitset_mul_x;
        int shape_mul_x = local_len_y * local_len_z;
        for (int x = 0; x < local_len_x; ++x) {
            boolean setX = false;
            for (int y = 0; y < local_len_y; ++y) {
                boolean setY = false;
                for (int z = 0; z < local_len_z; ++z) {
                    int unslicedIdx = idx_off + z + y * size_z + x * bitset_mul_x;
                    if ((bitset[unslicedIdx >>> 6] & 1L << unslicedIdx) == 0L) continue;
                    setY = true;
                    setX = true;
                    shape.field_1356 = Math.min(shape.field_1356, z);
                    shape.field_1360 = Math.max(shape.field_1360, z + 1);
                    shape.field_1359.set(z + y * local_len_z + x * shape_mul_x);
                }
                if (!setY) continue;
                shape.field_1357 = Math.min(shape.field_1357, y);
                shape.field_1354 = Math.max(shape.field_1354, y + 1);
            }
            if (!setX) continue;
            shape.field_1358 = Math.min(shape.field_1358, x);
            shape.field_1355 = Math.max(shape.field_1355, x + 1);
        }
        return shape.method_1056() ? class_259.method_1073() : new class_245((class_251)shape, (DoubleList)list_x, list_y, list_z);
    }

    public static class_265 sliceShape(class_265 src, class_2350.class_2351 axis, int index) {
        class_265 ret = CollisionUtil.sliceShapeOptimised(src, axis, index);
        return ret;
    }

    public static boolean voxelShapeIntersectNoEmpty(class_265 voxel, class_238 aabb) {
        if (voxel.method_1110()) {
            return false;
        }
        double off_x = ((CollisionVoxelShape)voxel).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)voxel).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)voxel).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)voxel).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, aabb.field_1323 + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return false;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, aabb.field_1320 - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return false;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, aabb.field_1322 + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return false;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, aabb.field_1325 - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return false;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, aabb.field_1321 + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return false;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, aabb.field_1324 - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return false;
        }
        long[] bitset = cached_shape_data.voxelSet();
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double collideX(class_265 target, class_238 source, double source_move) {
        class_238 single_aabb = ((CollisionVoxelShape)target).moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideX(single_aabb, source, source_move);
        }
        double off_x = ((CollisionVoxelShape)target).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)target).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)target).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)target).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)target).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)target).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)target).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, source.field_1322 + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, source.field_1325 - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, source.field_1321 + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, source.field_1324 - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.field_1320;
            int ceil_max_x = CollisionUtil.findFloor(coords_x, off_x, source_max - 1.0E-7, 0, size_x) + 1;
            int mul_x = size_y * size_z;
            for (int curr_x = ceil_max_x; curr_x < size_x; ++curr_x) {
                double max_dist = coords_x[curr_x] + off_x - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.field_1323;
        int floor_min_x = CollisionUtil.findFloor(coords_x, off_x, source_min + 1.0E-7, 0, size_x);
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x - 1; curr_x >= 0; --curr_x) {
            double max_dist = coords_x[curr_x + 1] + off_x - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideY(class_265 target, class_238 source, double source_move) {
        class_238 single_aabb = ((CollisionVoxelShape)target).moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideY(single_aabb, source, source_move);
        }
        double off_x = ((CollisionVoxelShape)target).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)target).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)target).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)target).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)target).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)target).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)target).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, source.field_1323 + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, source.field_1320 - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, source.field_1321 + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, source.field_1324 - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.field_1325;
            int ceil_max_y = CollisionUtil.findFloor(coords_y, off_y, source_max - 1.0E-7, 0, size_y) + 1;
            int mul_x = size_y * size_z;
            for (int curr_y = ceil_max_y; curr_y < size_y; ++curr_y) {
                double max_dist = coords_y[curr_y] + off_y - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.field_1322;
        int floor_min_y = CollisionUtil.findFloor(coords_y, off_y, source_min + 1.0E-7, 0, size_y);
        int mul_x = size_y * size_z;
        for (int curr_y = floor_min_y - 1; curr_y >= 0; --curr_y) {
            double max_dist = coords_y[curr_y + 1] + off_y - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideZ(class_265 target, class_238 source, double source_move) {
        class_238 single_aabb = ((CollisionVoxelShape)target).moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideZ(single_aabb, source, source_move);
        }
        double off_x = ((CollisionVoxelShape)target).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)target).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)target).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)target).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)target).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)target).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)target).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, source.field_1323 + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, source.field_1320 - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, source.field_1322 + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, source.field_1325 - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.field_1324;
            int ceil_max_z = CollisionUtil.findFloor(coords_z, off_z, source_max - 1.0E-7, 0, size_z) + 1;
            int mul_x = size_y * size_z;
            for (int curr_z = ceil_max_z; curr_z < size_z; ++curr_z) {
                double max_dist = coords_z[curr_z] + off_z - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.field_1321;
        int floor_min_z = CollisionUtil.findFloor(coords_z, off_z, source_min + 1.0E-7, 0, size_z);
        int mul_x = size_y * size_z;
        for (int curr_z = floor_min_z - 1; curr_z >= 0; --curr_z) {
            double max_dist = coords_z[curr_z + 1] + off_z - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static boolean strictlyContains(class_265 voxel, class_243 point) {
        return CollisionUtil.strictlyContains(voxel, point.field_1352, point.field_1351, point.field_1350);
    }

    public static boolean strictlyContains(class_265 voxel, double x, double y, double z) {
        class_238 single_aabb = ((CollisionVoxelShape)voxel).moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return single_aabb.method_1008(x, y, z);
        }
        if (voxel.method_1110()) {
            return false;
        }
        double off_x = ((CollisionVoxelShape)voxel).moonrise$offsetX();
        double off_y = ((CollisionVoxelShape)voxel).moonrise$offsetY();
        double off_z = ((CollisionVoxelShape)voxel).moonrise$offsetZ();
        double[] coords_x = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesX();
        double[] coords_y = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesY();
        double[] coords_z = ((CollisionVoxelShape)voxel).moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = ((CollisionVoxelShape)voxel).moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int index_x = CollisionUtil.findFloor(coords_x, off_x, x, 0, size_x);
        if (index_x < 0 || index_x >= size_x) {
            return false;
        }
        int index_y = CollisionUtil.findFloor(coords_y, off_y, y, 0, size_y);
        if (index_y < 0 || index_y >= size_y) {
            return false;
        }
        int index_z = CollisionUtil.findFloor(coords_z, off_z, z, 0, size_z);
        if (index_z < 0 || index_z >= size_z) {
            return false;
        }
        int index = index_z + index_y * size_z + index_x * (size_z * size_y);
        long[] bitset = cached_shape_data.voxelSet();
        return (bitset[index >>> 6] & 1L << index) != 0L;
    }

    private static int makeBitset(boolean ft, boolean tf, boolean tt) {
        return (ft ? 1 : 0) << 1 | (tf ? 1 : 0) << 2 | (tt ? 1 : 0) << 3;
    }

    private static class_244 merge(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        class_244 ret = new class_244(sizeX, sizeY, sizeZ);
        boolean empty = true;
        int mergedIdx = 0;
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            boolean setX = false;
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                boolean setY = false;
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    int n;
                    int isS1Full;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        int idx1 = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx1 >>> 6] >>> idx1 & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n = 0;
                    } else {
                        int idx2 = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n = (int)(s2Voxels[idx2 >>> 6] >>> idx2 & 1L);
                    }
                    int isS2Full = n;
                    boolean res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    setY |= res;
                    setX |= res;
                    if (res) {
                        empty = false;
                        ret.field_1356 = Math.min(ret.field_1356, idxZ);
                        ret.field_1360 = Math.max(ret.field_1360, idxZ + 1);
                        ret.field_1359.set(mergedIdx);
                    }
                    ++mergedIdx;
                }
                if (!setY) continue;
                ret.field_1357 = Math.min(ret.field_1357, idxY);
                ret.field_1354 = Math.max(ret.field_1354, idxY + 1);
            }
            if (!setX) continue;
            ret.field_1358 = Math.min(ret.field_1358, idxX);
            ret.field_1355 = Math.max(ret.field_1355, idxX + 1);
        }
        return empty ? null : ret;
    }

    private static boolean isMergeEmpty(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    boolean res;
                    int n;
                    int isS1Full;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        int idx1 = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx1 >>> 6] >>> idx1 & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n = 0;
                    } else {
                        int idx2 = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n = (int)(s2Voxels[idx2 >>> 6] >>> idx2 & 1L);
                    }
                    int isS2Full = n;
                    boolean bl = res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    if (!res) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static class_265 joinOptimized(class_265 first, class_265 second, class_247 operator) {
        return CollisionUtil.joinUnoptimized(first, second, operator).method_1097();
    }

    public static class_265 joinUnoptimized(class_265 first, class_265 second, class_247 operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt ? first : class_259.method_1073();
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        if (first.method_1110()) {
            return ft ? second : class_259.method_1073();
        }
        if (second.method_1110()) {
            return tf ? first : class_259.method_1073();
        }
        if (!tt) {
            boolean hasAABBS;
            class_238 aabbF = ((CollisionVoxelShape)first).moonrise$getSingleAABBRepresentation();
            class_238 aabbS = ((CollisionVoxelShape)second).moonrise$getSingleAABBRepresentation();
            boolean hasAABBF = aabbF != null;
            boolean bl = hasAABBS = aabbS != null;
            boolean intersect = hasAABBF | hasAABBS ? (hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS))) : CollisionUtil.voxelShapeIntersect(first.method_1107(), second.method_1107());
            if (!intersect) {
                if (!tf & !ft) {
                    return class_259.method_1073();
                }
                if (!tf | !ft) {
                    return tf ? first : second;
                }
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesX(), ((CollisionVoxelShape)first).moonrise$offsetX(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesX(), ((CollisionVoxelShape)second).moonrise$offsetX(), ft, tf)) == null) {
            return class_259.method_1073();
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesY(), ((CollisionVoxelShape)first).moonrise$offsetY(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesY(), ((CollisionVoxelShape)second).moonrise$offsetY(), ft, tf);
        if (mergedY == null) {
            return class_259.method_1073();
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesZ(), ((CollisionVoxelShape)first).moonrise$offsetZ(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesZ(), ((CollisionVoxelShape)second).moonrise$offsetZ(), ft, tf);
        if (mergedZ == null) {
            return class_259.method_1073();
        }
        CachedShapeData shapeDataFirst = ((CollisionVoxelShape)first).moonrise$getCachedVoxelData();
        class_244 mergedShape = CollisionUtil.merge(shapeDataFirst, shapeDataSecond = ((CollisionVoxelShape)second).moonrise$getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
        if (mergedShape == null) {
            return class_259.method_1073();
        }
        return new class_245((class_251)mergedShape, mergedX.wrapCoords(), mergedY.wrapCoords(), mergedZ.wrapCoords());
    }

    public static boolean isJoinNonEmpty(class_265 first, class_265 second, class_247 operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean hasAABBS;
        boolean secondEmpty;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean firstEmpty = first.method_1110();
        if (firstEmpty | (secondEmpty = second.method_1110())) {
            return operator.apply(!firstEmpty, !secondEmpty);
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt;
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        class_238 aabbF = ((CollisionVoxelShape)first).moonrise$getSingleAABBRepresentation();
        class_238 aabbS = ((CollisionVoxelShape)second).moonrise$getSingleAABBRepresentation();
        boolean hasAABBF = aabbF != null;
        boolean bl = hasAABBS = aabbS != null;
        if (hasAABBF | hasAABBS) {
            boolean intersect = hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS));
            if (!intersect) {
                return tf | ft;
            }
            if (tt) {
                return true;
            }
        } else {
            boolean intersect = CollisionUtil.voxelShapeIntersect(first.method_1107(), second.method_1107());
            if (!intersect) {
                return tf | ft;
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesX(), ((CollisionVoxelShape)first).moonrise$offsetX(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesX(), ((CollisionVoxelShape)second).moonrise$offsetX(), ft, tf)) == null) {
            return false;
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesY(), ((CollisionVoxelShape)first).moonrise$offsetY(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesY(), ((CollisionVoxelShape)second).moonrise$offsetY(), ft, tf);
        if (mergedY == null) {
            return false;
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(((CollisionVoxelShape)first).moonrise$rootCoordinatesZ(), ((CollisionVoxelShape)first).moonrise$offsetZ(), ((CollisionVoxelShape)second).moonrise$rootCoordinatesZ(), ((CollisionVoxelShape)second).moonrise$offsetZ(), ft, tf);
        if (mergedZ == null) {
            return false;
        }
        CachedShapeData shapeDataFirst = ((CollisionVoxelShape)first).moonrise$getCachedVoxelData();
        return !CollisionUtil.isMergeEmpty(shapeDataFirst, shapeDataSecond = ((CollisionVoxelShape)second).moonrise$getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
    }

    public static boolean equals(class_251 shape1, class_251 shape2) {
        boolean isEmpty2;
        CachedShapeData cachedShapeData1 = ((CollisionDiscreteVoxelShape)shape1).moonrise$getOrCreateCachedShapeData();
        CachedShapeData cachedShapeData2 = ((CollisionDiscreteVoxelShape)shape2).moonrise$getOrCreateCachedShapeData();
        boolean isEmpty1 = cachedShapeData1.isEmpty();
        if (isEmpty1 & (isEmpty2 = cachedShapeData2.isEmpty())) {
            return true;
        }
        if (isEmpty1 ^ isEmpty2) {
            return false;
        }
        if (cachedShapeData1.hasSingleAABB() != cachedShapeData2.hasSingleAABB()) {
            return false;
        }
        if (cachedShapeData1.sizeX() != cachedShapeData2.sizeX()) {
            return false;
        }
        if (cachedShapeData1.sizeY() != cachedShapeData2.sizeY()) {
            return false;
        }
        if (cachedShapeData1.sizeZ() != cachedShapeData2.sizeZ()) {
            return false;
        }
        return Arrays.equals(cachedShapeData1.voxelSet(), cachedShapeData2.voxelSet());
    }

    public static boolean equals(class_265 shape1, class_265 shape2) {
        if (shape1.method_1110() & shape2.method_1110()) {
            return true;
        }
        if (shape1.method_1110() ^ shape2.method_1110()) {
            return false;
        }
        if (!CollisionUtil.equals(shape1.field_1401, shape2.field_1401)) {
            return false;
        }
        return shape1.method_1109(class_2350.class_2351.field_11048).equals((Object)shape2.method_1109(class_2350.class_2351.field_11048)) && shape1.method_1109(class_2350.class_2351.field_11052).equals((Object)shape2.method_1109(class_2350.class_2351.field_11052)) && shape1.method_1109(class_2350.class_2351.field_11051).equals((Object)shape2.method_1109(class_2350.class_2351.field_11051));
    }

    public static boolean areAnyFull(class_251 shape) {
        if (shape.method_1056()) {
            return false;
        }
        int sizeX = shape.method_1050();
        int sizeY = shape.method_1047();
        int sizeZ = shape.method_1048();
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    if (!shape.method_1063(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String shapeMismatch(class_251 shape1, class_251 shape2) {
        boolean isEmpty2;
        CachedShapeData cachedShapeData1 = ((CollisionDiscreteVoxelShape)shape1).moonrise$getOrCreateCachedShapeData();
        CachedShapeData cachedShapeData2 = ((CollisionDiscreteVoxelShape)shape2).moonrise$getOrCreateCachedShapeData();
        boolean isEmpty1 = cachedShapeData1.isEmpty();
        if (isEmpty1 & (isEmpty2 = cachedShapeData2.isEmpty())) {
            return null;
        }
        if (isEmpty1 ^ isEmpty2) {
            return null;
        }
        if (cachedShapeData1.sizeX() != cachedShapeData2.sizeX()) {
            return "size x: " + cachedShapeData1.sizeX() + " != " + cachedShapeData2.sizeX();
        }
        if (cachedShapeData1.sizeY() != cachedShapeData2.sizeY()) {
            return "size y: " + cachedShapeData1.sizeY() + " != " + cachedShapeData2.sizeY();
        }
        if (cachedShapeData1.sizeZ() != cachedShapeData2.sizeZ()) {
            return "size z: " + cachedShapeData1.sizeZ() + " != " + cachedShapeData2.sizeZ();
        }
        StringBuilder ret = new StringBuilder();
        int sizeX = cachedShapeData1.sizeX();
        int sizeY = cachedShapeData1.sizeY();
        int sizeZ = cachedShapeData1.sizeZ();
        boolean first = true;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    boolean isFull2;
                    boolean isFull1 = shape1.method_1063(x, y, z);
                    if (isFull1 == (isFull2 = shape2.method_1063(x, y, z))) continue;
                    if (first) {
                        first = false;
                    } else {
                        ret.append(", ");
                    }
                    ret.append("(").append(x).append(",").append(y).append(",").append(z).append("): shape1: ").append(isFull1).append(", shape2: ").append(isFull2);
                }
            }
        }
        return ret.isEmpty() ? null : ret.toString();
    }

    public static class_238 offsetX(class_238 box, double dx) {
        return new class_238(box.field_1323 + dx, box.field_1322, box.field_1321, box.field_1320 + dx, box.field_1325, box.field_1324);
    }

    public static class_238 offsetY(class_238 box, double dy) {
        return new class_238(box.field_1323, box.field_1322 + dy, box.field_1321, box.field_1320, box.field_1325 + dy, box.field_1324);
    }

    public static class_238 offsetZ(class_238 box, double dz) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321 + dz, box.field_1320, box.field_1325, box.field_1324 + dz);
    }

    public static class_238 expandRight(class_238 box, double dx) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320 + dx, box.field_1325, box.field_1324);
    }

    public static class_238 expandLeft(class_238 box, double dx) {
        return new class_238(box.field_1323 - dx, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
    }

    public static class_238 expandUpwards(class_238 box, double dy) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325 + dy, box.field_1324);
    }

    public static class_238 expandDownwards(class_238 box, double dy) {
        return new class_238(box.field_1323, box.field_1322 - dy, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
    }

    public static class_238 expandForwards(class_238 box, double dz) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324 + dz);
    }

    public static class_238 expandBackwards(class_238 box, double dz) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321 - dz, box.field_1320, box.field_1325, box.field_1324);
    }

    public static class_238 cutRight(class_238 box, double dx) {
        return new class_238(box.field_1320, box.field_1322, box.field_1321, box.field_1320 + dx, box.field_1325, box.field_1324);
    }

    public static class_238 cutLeft(class_238 box, double dx) {
        return new class_238(box.field_1323 + dx, box.field_1322, box.field_1321, box.field_1323, box.field_1325, box.field_1324);
    }

    public static class_238 cutUpwards(class_238 box, double dy) {
        return new class_238(box.field_1323, box.field_1325, box.field_1321, box.field_1320, box.field_1325 + dy, box.field_1324);
    }

    public static class_238 cutDownwards(class_238 box, double dy) {
        return new class_238(box.field_1323, box.field_1322 + dy, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
    }

    public static class_238 cutForwards(class_238 box, double dz) {
        return new class_238(box.field_1323, box.field_1322, box.field_1324, box.field_1320, box.field_1325, box.field_1324 + dz);
    }

    public static class_238 cutBackwards(class_238 box, double dz) {
        return new class_238(box.field_1323, box.field_1322, box.field_1321 + dz, box.field_1320, box.field_1325, box.field_1321);
    }

    public static double performAABBCollisionsX(class_238 currentBoundingBox, double value, List<class_238> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_238 target = potentialCollisions.get(i);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsY(class_238 currentBoundingBox, double value, List<class_238> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_238 target = potentialCollisions.get(i);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsZ(class_238 currentBoundingBox, double value, List<class_238> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_238 target = potentialCollisions.get(i);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsX(class_238 currentBoundingBox, double value, List<class_265> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_265 target = potentialCollisions.get(i);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsY(class_238 currentBoundingBox, double value, List<class_265> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_265 target = potentialCollisions.get(i);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsZ(class_238 currentBoundingBox, double value, List<class_265> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            class_265 target = potentialCollisions.get(i);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static class_243 performVoxelCollisions(class_243 moveVector, class_238 axisalignedbb, List<class_265> potentialCollisions) {
        boolean xSmaller;
        double x = moveVector.field_1352;
        double y = moveVector.field_1351;
        double z = moveVector.field_1350;
        if (y != 0.0 && (y = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0 && (z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
        }
        if (x != 0.0) {
            x = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x, potentialCollisions);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, potentialCollisions);
        }
        return new class_243(x, y, z);
    }

    public static class_243 performAABBCollisions(class_243 moveVector, class_238 axisalignedbb, List<class_238> potentialCollisions) {
        boolean xSmaller;
        double x = moveVector.field_1352;
        double y = moveVector.field_1351;
        double z = moveVector.field_1350;
        if (y != 0.0 && (y = CollisionUtil.performAABBCollisionsY(axisalignedbb, y, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0 && (z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
        }
        if (x != 0.0) {
            x = CollisionUtil.performAABBCollisionsX(axisalignedbb, x, potentialCollisions);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, potentialCollisions);
        }
        return new class_243(x, y, z);
    }

    public static class_243 performCollisions(class_243 moveVector, class_238 axisalignedbb, List<class_265> voxels, List<class_238> aabbs) {
        boolean xSmaller;
        if (voxels.isEmpty()) {
            return CollisionUtil.performAABBCollisions(moveVector, axisalignedbb, aabbs);
        }
        double x = moveVector.field_1352;
        double y = moveVector.field_1351;
        double z = moveVector.field_1350;
        if (y != 0.0) {
            y = CollisionUtil.performAABBCollisionsY(axisalignedbb, y, aabbs);
            if ((y = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
            }
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, aabbs);
            if ((z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
            }
        }
        if (x != 0.0) {
            x = CollisionUtil.performAABBCollisionsX(axisalignedbb, x, aabbs);
            x = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x, voxels);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, aabbs);
            z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, voxels);
        }
        return new class_243(x, y, z);
    }

    public static boolean isCollidingWithBorder(class_2784 worldborder, class_238 boundingBox) {
        return CollisionUtil.isCollidingWithBorder(worldborder, boundingBox.field_1323, boundingBox.field_1320, boundingBox.field_1321, boundingBox.field_1324);
    }

    public static boolean isCollidingWithBorder(class_2784 worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMinX = Math.floor(worldborder.method_11976());
        double borderMaxX = Math.ceil(worldborder.method_11963());
        double borderMinZ = Math.floor(worldborder.method_11958());
        double borderMaxZ = Math.ceil(worldborder.method_11977());
        return borderMinX - boxMinX > 1.0E-7 || borderMaxX - boxMaxX < -1.0E-7 || borderMinZ - boxMinZ > 1.0E-7 || borderMaxZ - boxMaxZ < -1.0E-7;
    }

    private static double min(double x, double y) {
        return x < y ? x : y;
    }

    private static double max(double x, double y) {
        return x > y ? x : y;
    }

    public static boolean getCollisionsForBlocksOrWorldBorder(class_1937 world, class_1297 entity, class_238 aabb, List<class_265> intoVoxel, List<class_238> intoAABB, int collisionFlags, BiPredicate<class_2680, class_2338> predicate) {
        class_2784 worldBorder;
        boolean checkOnly = (collisionFlags & 8) != 0;
        boolean ret = false;
        if ((collisionFlags & 4) != 0 && CollisionUtil.isCollidingWithBorder(worldBorder = world.method_8621(), aabb) && entity != null && worldBorder.method_39459(entity, aabb)) {
            if (checkOnly) {
                return true;
            }
            class_265 borderShape = worldBorder.method_17903();
            intoVoxel.add(borderShape);
            ret = true;
        }
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = class_3532.method_15357((double)(aabb.field_1323 - 1.0E-7)) - 1;
        int maxBlockX = class_3532.method_15357((double)(aabb.field_1320 + 1.0E-7)) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, class_3532.method_15357((double)(aabb.field_1322 - 1.0E-7)) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(world) << 4) + 16, class_3532.method_15357((double)(aabb.field_1325 + 1.0E-7)) + 1);
        int minBlockZ = class_3532.method_15357((double)(aabb.field_1321 - 1.0E-7)) - 1;
        int maxBlockZ = class_3532.method_15357((double)(aabb.field_1324 + 1.0E-7)) + 1;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        LazyEntityCollisionContext collisionShape = new LazyEntityCollisionContext(entity);
        boolean useEntityCollisionShape = LazyEntityCollisionContext.useEntityCollisionShape(world, entity);
        if (minBlockY > maxBlockY) {
            return ret;
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        boolean loadChunks = (collisionFlags & 1) != 0;
        class_2802 chunkSource = world.method_8398();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                class_2791 chunk = chunkSource.method_12121(currChunkX, currChunkZ, class_2806.field_12803, loadChunks);
                if (chunk == null) {
                    if ((collisionFlags & 2) == 0) continue;
                    if (checkOnly) {
                        return true;
                    }
                    intoAABB.add(CollisionUtil.getBoxForChunk(currChunkX, currChunkZ));
                    ret = true;
                    continue;
                }
                class_2826[] sections = chunk.method_12006();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    class_2826 section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).method_38292()) continue;
                    boolean hasSpecial = ((BlockCountingChunkSection)section).moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    class_2841 blocks = section.field_12878;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                class_265 blockCollisionOffset;
                                class_2680 blockData;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || ((CollisionBlockState)(blockData = (class_2680)blocks.method_12331(localBlockIndex))).moonrise$emptyContextCollisionShape()) continue;
                                class_265 blockCollision = ((CollisionBlockState)blockData).moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.method_26209() || edgeCount == 2 && blockData.method_26204() != class_2246.field_10008)) continue;
                                mutablePos.method_10103(blockX, blockY, blockZ);
                                if (useEntityCollisionShape) {
                                    blockCollision = collisionShape.method_62878(blockData, (class_1941)world, (class_2338)mutablePos);
                                } else if (blockCollision == null) {
                                    blockCollision = blockData.method_26194((class_1922)world, (class_2338)mutablePos, (class_3726)collisionShape);
                                }
                                class_238 singleAABB = ((CollisionVoxelShape)blockCollision).moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(aabb, singleAABB = singleAABB.method_989((double)blockX, (double)blockY, (double)blockZ)) || predicate != null && !predicate.test(blockData, (class_2338)mutablePos)) continue;
                                    if (checkOnly) {
                                        return true;
                                    }
                                    ret = true;
                                    intoAABB.add(singleAABB);
                                    continue;
                                }
                                if (blockCollision.method_1110() || !CollisionUtil.voxelShapeIntersectNoEmpty(blockCollisionOffset = blockCollision.method_1096((double)blockX, (double)blockY, (double)blockZ), aabb) || predicate != null && !predicate.test(blockData, (class_2338)mutablePos)) continue;
                                if (checkOnly) {
                                    return true;
                                }
                                ret = true;
                                intoVoxel.add(blockCollisionOffset);
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static boolean getEntityHardCollisions(class_1937 world, class_1297 entity, class_238 aabb, List<class_238> into, int collisionFlags, Predicate<class_1297> predicate) {
        boolean checkOnly = (collisionFlags & 8) != 0;
        boolean ret = false;
        aabb = aabb.method_1009(-1.0E-7, -1.0E-7, -1.0E-7);
        List entities = entity != null && ((ChunkSystemEntity)entity).moonrise$isHardColliding() ? world.method_8333(entity, aabb, predicate) : ((ChunkSystemEntityGetter)world).moonrise$getHardCollidingEntities(entity, aabb, predicate);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            class_1297 otherEntity = (class_1297)entities.get(i);
            if (otherEntity.method_7325() || (entity != null || !otherEntity.method_30948(entity)) && (entity == null || !entity.method_30949(otherEntity))) continue;
            if (checkOnly) {
                return true;
            }
            into.add(otherEntity.method_5829());
            ret = true;
        }
        return ret;
    }

    public static boolean getCollisions(class_1937 world, class_1297 entity, class_238 aabb, List<class_265> intoVoxel, List<class_238> intoAABB, int collisionFlags, BiPredicate<class_2680, class_2338> blockPredicate, Predicate<class_1297> entityPredicate) {
        if ((collisionFlags & 8) != 0) {
            return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) || CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
        }
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) | CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
    }

    private CollisionUtil() {
        throw new RuntimeException();
    }

    private static final class MergedVoxelCoordinateList {
        private static final int[][] SIMPLE_INDICES_CACHE = new int[64][];
        public final double[] coordinates;
        public final double coordinateOffset;
        public final int[] firstIndices;
        public final int[] secondIndices;
        public final int voxels;

        private static int[] getIndices(int length) {
            int[] ret = new int[length];
            for (int i = 1; i < length; ++i) {
                ret[i] = i;
            }
            return ret;
        }

        private MergedVoxelCoordinateList(double[] coordinates, double coordinateOffset, int[] firstIndices, int[] secondIndices, int voxels) {
            this.coordinates = coordinates;
            this.coordinateOffset = coordinateOffset;
            this.firstIndices = firstIndices;
            this.secondIndices = secondIndices;
            this.voxels = voxels;
        }

        public DoubleList wrapCoords() {
            if (this.coordinateOffset == 0.0) {
                return DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1));
            }
            return new class_261((DoubleList)DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1)), this.coordinateOffset);
        }

        public static MergedVoxelCoordinateList getForSingle(double[] coordinates, double offset) {
            int voxels = coordinates.length - 1;
            int[] indices = voxels < SIMPLE_INDICES_CACHE.length ? SIMPLE_INDICES_CACHE[voxels] : MergedVoxelCoordinateList.getIndices(voxels);
            return new MergedVoxelCoordinateList(coordinates, offset, indices, indices, voxels);
        }

        public static MergedVoxelCoordinateList merge(double[] firstCoordinates, double firstOffset, double[] secondCoordinates, double secondOffset, boolean ft, boolean tf) {
            if (firstCoordinates == secondCoordinates && firstOffset == secondOffset) {
                return MergedVoxelCoordinateList.getForSingle(firstCoordinates, firstOffset);
            }
            int firstCount = firstCoordinates.length;
            int secondCount = secondCoordinates.length;
            int voxelsFirst = firstCount - 1;
            int voxelsSecond = secondCount - 1;
            int maxCount = firstCount + secondCount;
            double[] coordinates = new double[maxCount];
            int[] firstIndices = new int[maxCount];
            int[] secondIndices = new int[maxCount];
            boolean notTF = !tf;
            boolean notFT = !ft;
            int firstIndex = 0;
            int secondIndex = 0;
            int resultSize = 0;
            double last = Double.NaN;
            while (true) {
                double select;
                boolean secondZero;
                boolean noneLeftSecond;
                boolean noneLeftFirst = firstIndex >= firstCount;
                boolean bl = noneLeftSecond = secondIndex >= secondCount;
                if (noneLeftFirst & noneLeftSecond | noneLeftSecond & notTF | noneLeftFirst & notFT) break;
                boolean firstZero = firstIndex == 0;
                boolean bl2 = secondZero = secondIndex == 0;
                if (noneLeftFirst) {
                    select = secondCoordinates[secondIndex] + secondOffset;
                    ++secondIndex;
                } else if (noneLeftSecond) {
                    select = firstCoordinates[firstIndex] + firstOffset;
                    ++firstIndex;
                } else {
                    boolean breakFirst = notTF & secondZero;
                    boolean breakSecond = notFT & firstZero;
                    double first = firstCoordinates[firstIndex] + firstOffset;
                    double second = secondCoordinates[secondIndex] + secondOffset;
                    boolean useFirst = first < second + 1.0E-7;
                    boolean cont = useFirst & breakFirst | !useFirst & breakSecond;
                    select = useFirst ? first : second;
                    firstIndex += useFirst ? 1 : 0;
                    secondIndex += 1 ^ (useFirst ? 1 : 0);
                    if (cont) continue;
                }
                int prevFirst = firstIndex - 1;
                prevFirst = prevFirst >= voxelsFirst ? -1 : prevFirst;
                int prevSecond = secondIndex - 1;
                int n = prevSecond = prevSecond >= voxelsSecond ? -1 : prevSecond;
                if (last >= select - 1.0E-7) {
                    firstIndices[resultSize - 1] = prevFirst;
                    secondIndices[resultSize - 1] = prevSecond;
                    continue;
                }
                firstIndices[resultSize] = prevFirst;
                secondIndices[resultSize] = prevSecond;
                coordinates[resultSize] = select;
                ++resultSize;
                last = select;
            }
            return resultSize <= 1 ? null : new MergedVoxelCoordinateList(coordinates, 0.0, firstIndices, secondIndices, resultSize - 1);
        }

        static {
            for (int i = 0; i < SIMPLE_INDICES_CACHE.length; ++i) {
                MergedVoxelCoordinateList.SIMPLE_INDICES_CACHE[i] = MergedVoxelCoordinateList.getIndices(i);
            }
        }
    }

    public static final class LazyEntityCollisionContext
    extends class_3727 {
        private class_3726 delegate;
        private boolean delegated;

        public LazyEntityCollisionContext(class_1297 entity) {
            super(false, false, 0.0, null, false, entity);
        }

        public static boolean useEntityCollisionShape(class_1937 world, class_1297 entity) {
            return entity instanceof class_1688 && class_1688.method_61566((class_1937)world);
        }

        public boolean isDelegated() {
            boolean delegated = this.delegated;
            this.delegated = false;
            return delegated;
        }

        public class_3726 getDelegate() {
            this.delegated = true;
            class_1297 entity = super.method_32480();
            return this.delegate == null ? (this.delegate = entity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)entity)) : this.delegate;
        }

        public class_1297 method_32480() {
            this.getDelegate();
            return super.method_32480();
        }

        public boolean method_16193() {
            return this.getDelegate().method_16193();
        }

        public boolean method_67716() {
            return this.getDelegate().method_67716();
        }

        public boolean method_16192(class_265 shape, class_2338 pos, boolean defaultValue) {
            return this.getDelegate().method_16192(shape, pos, defaultValue);
        }

        public boolean method_17785(class_1792 item) {
            return this.getDelegate().method_17785(item);
        }

        public boolean method_73328() {
            return this.getDelegate().method_73328();
        }

        public boolean method_27866(class_3610 state, class_3610 fluidState) {
            return this.getDelegate().method_27866(state, fluidState);
        }

        public class_265 method_62878(class_2680 blockState, class_1941 collisionGetter, class_2338 blockPos) {
            return this.getDelegate().method_62878(blockState, collisionGetter, blockPos);
        }
    }
}

