/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.profiler;

public record TickTime(long previousTickStart, long scheduledTickStart, long tickStart, long tickStartCPU, long tickEnd, long tickEndCPU, boolean supportCPUTime) {
    public static final long CPU_TIME_UNSUPPORTED = Long.MIN_VALUE;
    public static final long DEADLINE_NOT_SET = Long.MIN_VALUE;

    public final long startOvershoot() {
        return this.tickStart - this.scheduledTickStart;
    }

    public final long tickLength() {
        return this.tickEnd - this.tickStart;
    }

    public final long tickCpuTime() {
        if (!this.supportCPUTime()) {
            return Long.MIN_VALUE;
        }
        return this.tickEndCPU - this.tickStartCPU;
    }

    public final long differenceFromLastTick(long defaultTime) {
        if (this.hasLastTick()) {
            return this.tickStart - this.previousTickStart;
        }
        return Math.max(defaultTime, this.tickLength());
    }

    public final boolean hasLastTick() {
        return this.previousTickStart != Long.MIN_VALUE;
    }
}

