/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10209;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3194;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
abstract class LevelMixin
implements ChunkSystemLevel,
ChunkSystemEntityGetter,
class_1936,
AutoCloseable {
    @Unique
    private EntityLookup entityLookup;
    @Unique
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();

    LevelMixin() {
    }

    @Shadow
    public abstract class_2818 method_8497(int var1, int var2);

    @Shadow
    public abstract int method_8624(class_2902.class_2903 var1, int var2, int var3);

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public final void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_5269;Lnet/minecraft/class_5321;Lnet/minecraft/class_5455;Lnet/minecraft/class_6880;ZZJI)V"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.entityLookup = new DefaultEntityLookup((class_1937)this);
    }

    @Overwrite
    public List<class_1297> method_8333(class_1297 entity, class_238 boundingBox, Predicate<? super class_1297> predicate) {
        class_10209.method_64146().method_39278("getEntities");
        ArrayList<class_1297> ret = new ArrayList<class_1297>();
        this.moonrise$getEntityLookup().getEntities(entity, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities((class_1937)this, entity, boundingBox, predicate, ret);
        return ret;
    }

    @Overwrite
    public <T extends class_1297> void method_47575(class_5575<class_1297, T> entityTypeTest, class_238 boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        class_10209.method_64146().method_39278("getEntities");
        if (entityTypeTest instanceof class_1299) {
            class_1299 byType = (class_1299)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((class_1297)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((class_1297)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class base = entityTypeTest.method_31794();
        Predicate<class_1297> modifiedPredicate = predicate == null ? obj -> entityTypeTest.method_31796(obj) != null : obj -> {
            class_1297 casted = (class_1297)entityTypeTest.method_31796(obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == class_1297.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((class_1297)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((class_1297)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities((class_1937)this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public final <T extends class_1297> List<T> method_8390(Class<T> entityClass, class_238 boundingBox, Predicate<? super T> predicate) {
        class_10209.method_64146().method_39278("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities((class_1937)this, class_5575.method_31795(entityClass), boundingBox, predicate, ret, Integer.MAX_VALUE);
        return ret;
    }

    @Override
    public final List<class_1297> moonrise$getHardCollidingEntities(class_1297 entity, class_238 box, Predicate<? super class_1297> predicate) {
        class_10209.method_64146().method_39278("getEntities");
        ArrayList<class_1297> ret = new ArrayList<class_1297>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public class_2818 moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (class_2818)this.method_8398().method_12121(chunkX, chunkZ, class_2806.field_12803, false);
    }

    @Override
    public class_2791 moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.method_8398().method_12121(chunkX, chunkZ, class_2806.field_12798, false);
    }

    @Override
    public class_2791 moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, class_2806 leastStatus) {
        return this.method_8398().method_12121(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        class_2802 chunkSource = this.method_8398();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.method_12123(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean method_8393(int x, int z) {
        return this.method_8398().method_12123(x, z);
    }

    public boolean method_33597(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    public class_2791 method_22342(int x, int z, class_2806 status) {
        return ((class_1937)this).method_8402(x, z, status, true);
    }

    public class_2338 method_8598(class_2902.class_2903 types, class_2338 blockPos) {
        return new class_2338(blockPos.method_10263(), this.method_8624(types, blockPos.method_10263(), blockPos.method_10260()), blockPos.method_10260());
    }

    @Redirect(method={"method_30092(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;II)Z", "markAndNotifyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3194;method_14014(Lnet/minecraft/class_3194;)Z"))
    private boolean sendUpdatesForFullChunks(class_3194 instance, class_3194 fullChunkStatus) {
        return instance.method_14014(class_3194.field_44855);
    }

    @Inject(method={"method_18472(Ljava/util/function/Consumer;Lnet/minecraft/class_1297;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private void midTickEntity(CallbackInfo ci) {
        this.moonrise$midTickTasks();
    }
}

