/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.tick_loop;

import ca.spottedleaf.moonrise.common.config.moonrise.MoonriseConfig;
import ca.spottedleaf.moonrise.common.time.Schedule;
import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopBlockableEventLoop;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopMinecraftServer;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopPacketProcessor;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_10209;
import net.minecraft.class_11980;
import net.minecraft.class_156;
import net.minecraft.class_2165;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3738;
import net.minecraft.class_4093;
import net.minecraft.class_8599;
import net.minecraft.class_8915;
import net.minecraft.class_9820;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin
extends class_4093<class_3738>
implements class_8599,
class_2165,
class_9820,
TickLoopMinecraftServer {
    @Shadow
    @Final
    private class_11980 field_62766;
    @Shadow
    private long field_47139;
    @Shadow
    @Final
    private class_8915 field_47142;
    @Shadow
    private long field_47138;
    @Shadow
    private boolean field_53718;
    @Shadow
    private long field_48775;
    @Unique
    private final Schedule tickSchedule = new Schedule(0L);
    @Unique
    private final TickData tickTimes5s = new TickData(TimeUnit.SECONDS.toNanos(5L));
    @Unique
    private final TickData tickTimes10s = new TickData(TimeUnit.SECONDS.toNanos(10L));
    @Unique
    private final TickData tickTimes1m = new TickData(TimeUnit.MINUTES.toNanos(1L));
    @Unique
    private final TickData tickTimes5m = new TickData(TimeUnit.MINUTES.toNanos(5L));
    @Unique
    private final TickData tickTimes15m = new TickData(TimeUnit.MINUTES.toNanos(15L));
    @Unique
    private long lastTickStart;
    @Unique
    private long currentTickStart;
    @Unique
    private long scheduledTickStart;

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    @Shadow
    public abstract boolean method_54809();

    @Shadow
    protected abstract void method_56604();

    @Shadow
    protected abstract void method_56605();

    @Shadow
    public abstract boolean method_16075();

    @Shadow
    public abstract boolean method_56626();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Override
    public final TickData moonrise$getTickData5s() {
        return this.tickTimes5s;
    }

    @Override
    public final TickData moonrise$getTickData10s() {
        return this.tickTimes10s;
    }

    @Override
    public final TickData moonrise$getTickData1m() {
        return this.tickTimes1m;
    }

    @Override
    public final TickData moonrise$getTickData5m() {
        return this.tickTimes5m;
    }

    @Override
    public final TickData moonrise$getTickData15m() {
        return this.tickTimes15m;
    }

    @Unique
    private void addTickTime(TickTime time) {
        this.tickTimes5s.addDataFrom(time);
        this.tickTimes10s.addDataFrom(time);
        this.tickTimes1m.addDataFrom(time);
        this.tickTimes5m.addDataFrom(time);
        this.tickTimes15m.addDataFrom(time);
    }

    @Inject(method={"method_29741()V"}, at={@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;field_47139:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
    private void initTickSchedule(CallbackInfo ci) {
        long interval = this.method_54809() || !this.field_47142.method_54670() ? this.field_47142.method_54750() : 0L;
        this.tickSchedule.setNextPeriod(this.field_47139, interval);
        this.lastTickStart = Long.MIN_VALUE;
        this.scheduledTickStart = this.tickSchedule.getDeadline(interval);
    }

    @Redirect(method={"method_29741()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_54809()Z", ordinal=0))
    private boolean shortSprintBranch(MinecraftServer instance) {
        return true;
    }

    @Redirect(method={"method_29741()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_8915;method_54750()J", ordinal=0))
    private long updateTickSchedule(class_8915 tickRateManager) {
        long interval;
        boolean sprint;
        long now = class_156.method_648();
        boolean bl = sprint = !this.method_54809() && tickRateManager.method_54670() && tickRateManager.method_54679();
        if (sprint) {
            interval = 0L;
            this.tickSchedule.setNextPeriod(now, interval);
        } else {
            long catchup;
            interval = tickRateManager.method_54750();
            long ticksBehind = Math.max(1L, this.tickSchedule.getPeriodsAhead(interval, now));
            if (ticksBehind > (catchup = (long)Math.max(1, ConfigHolder.getConfig().tickLoop.catchupTicks.getOrDefault(MoonriseConfig.TickLoop.DEFAULT_CATCHUP_TICKS)))) {
                long difference = ticksBehind - catchup;
                this.tickSchedule.advanceBy(difference, interval);
            }
            this.tickSchedule.advanceBy(1L, interval);
        }
        this.field_47138 = this.field_47139 = this.tickSchedule.getDeadline(interval);
        this.currentTickStart = now;
        return interval;
    }

    @Inject(method={"method_29741()V"}, at={@At(value="INVOKE", target="Lcom/mojang/jtracy/DiscontinuousFrame;end()V", ordinal=0, shift=At.Shift.AFTER)})
    private void hookEndOfTick(CallbackInfo ci) {
        long prevStart = this.lastTickStart;
        long currStart = this.currentTickStart;
        this.lastTickStart = this.currentTickStart;
        long scheduledStart = this.scheduledTickStart;
        this.scheduledTickStart = this.field_47139;
        long now = class_156.method_648();
        TickTime time = new TickTime(prevStart, scheduledStart, currStart, 0L, now, 0L, false, true);
        this.addTickTime(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"method_29741()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_16208()V", ordinal=0))
    private void recordTaskExecutionTimeWhileWaiting(MinecraftServer instance) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("moonrise:execute_tasks_until_tick");
        this.field_53718 = true;
        boolean isLoggingEnabled = this.method_56626();
        try {
            long deadline = this.field_47139;
            while (true) {
                long start;
                if ((start = class_156.method_648()) - deadline >= 0L) {
                } else {
                    while (this.method_16075() && class_156.method_648() - deadline < 0L) {
                    }
                    long now = class_156.method_648();
                    this.addTickTime(new TickTime(Long.MIN_VALUE, Long.MIN_VALUE, start, 0L, now, 0L, false, false));
                    long toWait = deadline - now;
                    if (toWait > 0L) {
                        LockSupport.parkNanos("waiting for tick or tasks", toWait);
                        if (!isLoggingEnabled) continue;
                        this.field_48775 += class_156.method_648() - now;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.field_53718 = false;
        }
        profiler.method_15407();
    }

    @Redirect(method={"method_29741()V"}, at=@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;field_47139:J", opcode=181, ordinal=3))
    private void dropNextTickTimeInc(MinecraftServer instance, long value) {
    }

    @ModifyConstant(method={"method_19464(Lnet/minecraft/class_3738;)Z"}, constant={@Constant(intValue=3, ordinal=0)})
    private int changeMaxTaskDelay(int constant) {
        return 1;
    }

    @Redirect(method={"method_29741()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_11980;method_74449()V"))
    private void dropVanillaPacketProcessing(class_11980 instance) {
    }

    @Inject(method={"method_29741()V"}, at={@At(value="INVOKE", target="Lcom/mojang/jtracy/DiscontinuousFrame;start()V", shift=At.Shift.AFTER)})
    private void runAllTasksAtStart(CallbackInfo ci) {
        this.method_56604();
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("moonrise:run_all_tasks");
        profiler.method_15396("moonrise:run_all_server");
        while (super.method_16075()) {
            ((ChunkSystemMinecraftServer)((Object)this)).moonrise$executeMidTickTasks();
            ((TickLoopPacketProcessor)this.field_62766).moonrise$executeSinglePacket();
        }
        profiler.method_15405("moonrise:run_all_packets");
        while (((TickLoopPacketProcessor)this.field_62766).moonrise$executeSinglePacket()) {
            ((ChunkSystemMinecraftServer)((Object)this)).moonrise$executeMidTickTasks();
        }
        profiler.method_15405("moonrise:run_all_chunk");
        for (class_3218 world : this.method_3738()) {
            profiler.method_15396(world.toString() + " " + String.valueOf(world.method_27983().method_29177()));
            profiler.method_15396("moonrise:distance_manager_update");
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
            profiler.method_15405("moonrise:legacy_chunk_tasks");
            ((TickLoopBlockableEventLoop)world.method_14178().field_18809).moonrise$executeAllRecentInternalTasks();
            profiler.method_15405("moonrise:chunk_system_tasks");
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().executeAllRecentlyQueuedMainThreadTasks();
            profiler.method_15407();
            profiler.method_15407();
        }
        profiler.method_15407();
        profiler.method_15407();
        this.method_56605();
    }

    @Overwrite
    public void method_16208() {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("moonrise:wait_for_next_tick");
        this.field_53718 = true;
        try {
            this.method_18857(() -> class_156.method_648() - this.field_47139 >= 0L);
        }
        finally {
            this.field_53718 = false;
        }
        profiler.method_15407();
    }

    @WrapOperation(method={"method_16075()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_20415()Z")})
    private boolean makePollExecutePacket(MinecraftServer instance, Operation<Boolean> original) {
        return ((TickLoopPacketProcessor)instance.method_74432()).moonrise$executeSinglePacket() | (Boolean)original.call(new Object[]{instance});
    }
}

