/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.client;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3194;
import net.minecraft.class_5576;

public final class ClientEntityLookup
extends EntityLookup {
    private final LongOpenHashSet tickingChunks = new LongOpenHashSet();

    public ClientEntityLookup(class_1937 world, class_5576<class_1297> worldCallback) {
        super(world, worldCallback);
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return null;
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
    }

    @Override
    protected void checkThread(class_1297 entity, String reason) {
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        boolean ticking = this.tickingChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkEntitySlices ret = new ChunkEntitySlices(this.world, chunkX, chunkZ, ticking ? class_3194.field_13877 : class_3194.field_44855, null, WorldUtil.getMinSection(this.world), WorldUtil.getMaxSection(this.world));
        this.addChunk(chunkX, chunkZ, ret);
        return ret;
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
        this.removeChunk(chunkX, chunkZ);
    }

    @Override
    protected void entitySectionChangeCallback(class_1297 entity, int oldSectionX, int oldSectionY, int oldSectionZ, int newSectionX, int newSectionY, int newSectionZ) {
        PlatformHooks.get().entityMove(entity, CoordinateUtils.getChunkSectionKey(oldSectionX, oldSectionY, oldSectionZ), CoordinateUtils.getChunkSectionKey(newSectionX, newSectionY, newSectionZ));
    }

    @Override
    protected void addEntityCallback(class_1297 entity) {
    }

    @Override
    protected void removeEntityCallback(class_1297 entity) {
    }

    @Override
    protected void entityStartLoaded(class_1297 entity) {
    }

    @Override
    protected void entityEndLoaded(class_1297 entity) {
    }

    @Override
    protected void entityStartTicking(class_1297 entity) {
    }

    @Override
    protected void entityEndTicking(class_1297 entity) {
    }

    @Override
    protected boolean screenEntity(class_1297 entity, boolean fromDisk, boolean event) {
        return true;
    }

    public void markTicking(long pos) {
        int chunkZ;
        int chunkX;
        if (this.tickingChunks.add(pos) && this.getChunk(chunkX = CoordinateUtils.getChunkX(pos), chunkZ = CoordinateUtils.getChunkZ(pos)) != null) {
            this.chunkStatusChange(chunkX, chunkZ, class_3194.field_13877);
        }
    }

    public void markNonTicking(long pos) {
        int chunkZ;
        int chunkX;
        if (this.tickingChunks.remove(pos) && this.getChunk(chunkX = CoordinateUtils.getChunkX(pos), chunkZ = CoordinateUtils.getChunkZ(pos)) != null) {
            this.chunkStatusChange(chunkX, chunkZ, class_3194.field_44855);
        }
    }
}

