/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.config.moonrise;

import ca.spottedleaf.moonrise.common.config.ui.ClothConfig;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.InitialiseHook;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.annotation.Adaptable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.annotation.Serializable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.type.DefaultedValue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.type.Duration;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;

@Adaptable
public final class MoonriseConfig {
    private static final String BUG_FIX_SECTION = "category.moonrise.bugfixes";
    private static final String CHUNK_SYSTEM_SECTION = "category.moonrise.chunksystem";
    @Serializable(comment="Do not change, used internally.\n")
    public int version = 1;
    @Serializable
    public ChunkLoading chunkLoading = new ChunkLoading();
    @Serializable
    public ChunkSaving chunkSaving = new ChunkSaving();
    @Serializable(comment="Configuration options which control the behavior of the common threadpool workers.\n")
    public WorkerPool workerPool = new WorkerPool();
    @Serializable
    public ChunkSystem chunkSystem = new ChunkSystem();
    @Serializable
    public BugFixes bugFixes = new BugFixes();
    @Serializable
    public Misc misc = new Misc();
    @Serializable
    public TickLoop tickLoop = new TickLoop();

    @Adaptable
    public static final class ChunkLoading {
        @Serializable(comment="Chunk loading/generation/sending rate targets for the chunk system.  These values are the\nmaximum rates at which the player chunk loader will attempt to load/generate/send chunks to\nplayers. Actual resulting rates will depend on hardware.\n")
        public Basic basic = new Basic();
        @Serializable(comment="Advanced configuration options for player chunk loading. You shouldn't be touching these\nunless you have a reason.\n")
        public Advanced advanced = new Advanced();

        @Adaptable
        public static final class Basic
        implements InitialiseHook {
            @Serializable(comment="The maximum rate of chunks to send to any given player, per second. If this value is <= 0,\nthen there is no rate limit.\n")
            public double playerMaxSendRate = -1.0;
            @Serializable(comment="The maximum rate of chunks to load from disk for any given player, per second. If this value is <= 0,\nthen there is no rate limit.\n")
            @ClothConfig(tooltip="tooltip.moonrise.loadrate", fieldKeyName="option.moonrise.loadrate", section="category.moonrise.chunksystem")
            public double playerMaxLoadRate = -1.0;
            @Serializable(comment="The maximum rate of chunks to generate for given player, per second. If this value is <= 0,\nthen there is no rate limit.\n")
            @ClothConfig(tooltip="tooltip.moonrise.genrate", fieldKeyName="option.moonrise.genrate", section="category.moonrise.chunksystem")
            public double playerMaxGenRate = -1.0;
            @Serializable(comment="The delay before chunks are unloaded around players once they leave their view distance.\nThe Vanilla value is 0 ticks. Setting this value higher (i.e 5s) will allow pets to teleport\nto their owners when they teleport.\n")
            public Duration playerChunkUnloadDelay = Duration.parse("0t");

            @Override
            public void initialise() {
                RegionizedPlayerChunkLoader.setUnloadDelay(this.playerChunkUnloadDelay.getTimeTicks());
            }
        }

        @Adaptable
        public static final class Advanced {
            @Serializable(comment="Whether to avoid sending chunks to players who have a view distance\nconfigured lower than the server's.\n")
            public boolean autoConfigSendDistance = true;
            @Serializable(comment="The maximum amount of pending chunk loads per player. If\nthis value is 0, then the player chunk loader will automatically determine a value. If\nthis value is less-than 0, then there is no limit.\n\nThis value should be used to tune the saturation of the chunk system.\n")
            public int playerMaxConcurrentChunkLoads = 0;
            @Serializable(comment="The maximum amount of pending chunk generations per player. If\nthis value is 0, then the player chunk loader will automatically determine a value. If\nthis value is less-than 0, then there is no limit.\n\nThis value should be used to tune the saturation of the chunk system.\n")
            public int playerMaxConcurrentChunkGenerates = 0;
        }
    }

    @Adaptable
    public static final class ChunkSaving {
        @Serializable(comment="The interval at which chunks should be incrementally autosaved.\n")
        public Duration autoSaveInterval = Duration.parse("5m");
        @Serializable(comment="The maximum number of chunks to incrementally autosave each tick. If\nthe value is <= 0, then no chunks will be incrementally saved.\n")
        public int maxAutoSaveChunksPerTick = 12;
    }

    @Adaptable
    public static final class WorkerPool
    implements InitialiseHook {
        @Serializable(comment="Set the number of shared worker threads to be used by chunk rendering,\nchunk loading, chunk generation. If the value is <= 0, then the number\nof threads will automatically be determined.\n")
        @ClothConfig(tooltip="tooltip.moonrise.workerthreads", fieldKeyName="option.moonrise.workerthreads", section="category.moonrise.chunksystem")
        public int workerThreads = -1;
        @Serializable(comment="Set the number of threads dedicated to RegionFile I/O operations.\nIf the value is <= 0, then the number of threads used is 1. Configuring\na higher value than 1 is only recommended on SSDs (HDDs scale negatively)\nand when you have determined that I/O is the bottleneck for chunk loading/saving.\n")
        @ClothConfig(tooltip="tooltip.moonrise.iothreads", fieldKeyName="option.moonrise.iothreads", section="category.moonrise.chunksystem")
        public int ioThreads = -1;

        @Override
        public void initialise() {
            MoonriseCommon.adjustWorkerThreads(this.workerThreads, this.ioThreads);
        }
    }

    @Adaptable
    public static final class ChunkSystem {
    }

    @Adaptable
    public static final class BugFixes {
        @Serializable(serializedKey="fix-MC-224294", comment="Fixes https://bugs.mojang.com/browse/MC-224294. By avoiding double ticking lava blocks during\nchunk random ticking, the cost of world random ticking is significantly reduced.\nThis configuration has two options:\ntrue    -> Does not double tick lava. This is different from Vanilla behavior.\nfalse   -> Does double tick lava. This is the same behavior as Vanilla.\n")
        @ClothConfig(tooltip="tooltip.moonrise.fixMC224294", fieldKeyName="option.moonrise.fixMC224294", section="category.moonrise.bugfixes")
        public boolean fixMC224294 = false;
        @Serializable(serializedKey="fix-MC-159283", comment="Fixes https://bugs.mojang.com/browse/MC-159283. This fixes a bug resulting in the end islands\nnot properly generating at far enough distances in the end. Note that toggling this config option\nwill not affect already generated areas.\nThis configuration has two options:\ntrue    -> Fixes the end islands generation. This is different from Vanilla behavior.\nfalse   -> Does not fix the end islands generation. This is the same behavior as Vanilla.\n")
        @ClothConfig(tooltip="tooltip.moonrise.fixMC159283", fieldKeyName="option.moonrise.fixMC159283", section="category.moonrise.bugfixes")
        public boolean fixMC159283 = false;
    }

    @Adaptable
    public static final class Misc {
    }

    @Adaptable
    public static final class TickLoop {
        public static final Integer DEFAULT_CATCHUP_TICKS = 5;
        @Serializable(comment="Configures the maximum number of ticks the server will attempt to catch up on.\nThe server will attempt to catch up by \"sprinting.\" This is visually apparent by\nwatching mobs move/attack quickly after the server lags.\n\nIf the server falls behind by 10 ticks and the configured value is 5, then the server\nwill only attempt to catch up by 5 ticks.\n\nTick catchup exists so that temporary spikes in server lag do not cause the server time\nto fall behind wall time over a long period. However, the speedup caused by the catchup\nprocess may be disruptive to players.\n\nThe default value is set to 5 so that players are not unnecessarily disrupted if the server\nhappens to lag for any reason, and so that small lag spikes do not cause de-sync from wall\ntime. Note that this value is smaller than Vanilla, which is at least 20 ticks.\n\nTo disable tick catchup, set the configured value to 1.\n")
        public DefaultedValue<Integer> catchupTicks = new DefaultedValue();
    }
}

