/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.misc;

public final class AllocatingRateLimiter {
    private final long maxGranularity;
    private double allocation = 0.0;
    private long lastAllocationUpdate;
    private double takeCarry = 0.0;
    private long lastTakeUpdate;

    public AllocatingRateLimiter(long maxGranularity) {
        this.maxGranularity = maxGranularity;
    }

    public void reset(long time) {
        this.allocation = 0.0;
        this.lastAllocationUpdate = time;
        this.takeCarry = 0.0;
        this.lastTakeUpdate = time;
    }

    public void tickAllocation(long time, double rate, double maxAllocation) {
        long diff = Math.min(this.maxGranularity, time - this.lastAllocationUpdate);
        this.lastAllocationUpdate = time;
        this.allocation = Math.min(maxAllocation - this.takeCarry, this.allocation + rate * ((double)diff * 1.0E-9));
    }

    public long previewAllocation(long time, double rate, long maxTake) {
        if (maxTake < 1L) {
            return 0L;
        }
        long diff = Math.min(this.maxGranularity, time - this.lastTakeUpdate);
        double take = Math.min(Math.min((double)maxTake - this.takeCarry, this.allocation), rate * ((double)diff * 1.0E-9));
        return (long)Math.floor(this.takeCarry + take);
    }

    public long takeAllocation(long time, double rate, long maxTake) {
        if (maxTake < 1L) {
            return 0L;
        }
        double ret = this.takeCarry;
        long diff = Math.min(this.maxGranularity, time - this.lastTakeUpdate);
        this.lastTakeUpdate = time;
        double take = Math.min(Math.min((double)maxTake - this.takeCarry, this.allocation), rate * ((double)diff * 1.0E-9));
        this.allocation -= take;
        long retInteger = (long)Math.floor(ret += take);
        this.takeCarry = ret - (double)retInteger;
        return retInteger;
    }
}

