/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.thread.BalancedPrioritisedThreadPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoonriseCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoonriseCommon.class);
    public static final long WORKER_QUEUE_HOLD_TIME = 20000000L;
    public static final BalancedPrioritisedThreadPool WORKER_POOL = new BalancedPrioritisedThreadPool(20000000L, new Consumer<Thread>(){
        private final AtomicInteger idGenerator = new AtomicInteger();

        @Override
        public void accept(Thread thread) {
            thread.setDaemon(true);
            thread.setName(PlatformHooks.get().getBrand() + " Common Worker #" + this.idGenerator.getAndIncrement());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
                }
            });
        }
    });
    public static final BalancedPrioritisedThreadPool.OrderedStreamGroup CLIENT_GROUP = WORKER_POOL.createOrderedStreamGroup();
    public static final BalancedPrioritisedThreadPool.OrderedStreamGroup SERVER_GROUP = WORKER_POOL.createOrderedStreamGroup();
    public static final long IO_QUEUE_HOLD_TIME = 25000000L;
    public static final BalancedPrioritisedThreadPool IO_POOL = new BalancedPrioritisedThreadPool(25000000L, new Consumer<Thread>(){
        private final AtomicInteger idGenerator = new AtomicInteger();

        @Override
        public void accept(Thread thread) {
            thread.setDaemon(true);
            thread.setName(PlatformHooks.get().getBrand() + " I/O Worker #" + this.idGenerator.getAndIncrement());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
                }
            });
        }
    });
    public static final BalancedPrioritisedThreadPool.OrderedStreamGroup CLIENT_IO_GROUP = IO_POOL.createOrderedStreamGroup();
    public static final BalancedPrioritisedThreadPool.OrderedStreamGroup SERVER_IO_GROUP = IO_POOL.createOrderedStreamGroup();

    public static void adjustWorkerThreads(int configWorkerThreads, int configIoThreads) {
        int defaultWorkerThreads = Runtime.getRuntime().availableProcessors() / 2;
        defaultWorkerThreads = defaultWorkerThreads <= 4 ? (defaultWorkerThreads <= 3 ? 1 : 2) : (defaultWorkerThreads /= 2);
        defaultWorkerThreads = Integer.getInteger(PlatformHooks.get().getBrand() + ".WorkerThreadCount", (Integer)defaultWorkerThreads);
        int workerThreads = configWorkerThreads;
        if (workerThreads <= 0) {
            workerThreads = defaultWorkerThreads;
        }
        int ioThreads = Math.max(1, configIoThreads);
        WORKER_POOL.adjustThreadCount(workerThreads);
        IO_POOL.adjustThreadCount(ioThreads);
        LOGGER.info(PlatformHooks.get().getBrand() + " is using " + workerThreads + " worker threads, " + ioThreads + " I/O threads");
    }

    public static void haltExecutors() {
        WORKER_POOL.shutdown(false);
        LOGGER.info("Awaiting termination of worker pool for up to 60s...");
        if (!WORKER_POOL.join(TimeUnit.SECONDS.toMillis(60L))) {
            LOGGER.error("Worker pool did not shut down in time!");
            WORKER_POOL.halt(false);
        }
        IO_POOL.shutdown(false);
        LOGGER.info("Awaiting termination of I/O pool for up to 60s...");
        if (!IO_POOL.join(TimeUnit.SECONDS.toMillis(60L))) {
            LOGGER.error("I/O pool did not shut down in time!");
            IO_POOL.halt(false);
        }
    }

    private MoonriseCommon() {
    }
}

