/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.queue;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class PrioritisedTaskQueue
implements PrioritisedExecutor {
    public static final long FLAG_ORDER_BY_STREAM = 1L;
    private final AtomicLong taskIdGenerator = new AtomicLong();
    private final AtomicLong scheduledTasks = new AtomicLong();
    private final AtomicLong executedTasks = new AtomicLong();
    private final AtomicLong subOrderGenerator;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final ConcurrentSkipListMap<PrioritisedQueuedTask.Holder, Boolean> tasks;

    public PrioritisedTaskQueue() {
        this(new AtomicLong());
    }

    public PrioritisedTaskQueue(AtomicLong subOrderGenerator) {
        this(subOrderGenerator, 0L);
    }

    public PrioritisedTaskQueue(AtomicLong subOrderGenerator, long flags) {
        this.subOrderGenerator = subOrderGenerator;
        this.tasks = new ConcurrentSkipListMap((flags & 1L) != 0L ? PrioritisedQueuedTask.COMPARATOR_STREAM : PrioritisedQueuedTask.COMPARATOR);
    }

    @Override
    public long getTotalTasksScheduled() {
        return this.scheduledTasks.get();
    }

    @Override
    public long getTotalTasksExecuted() {
        return this.executedTasks.get();
    }

    @Override
    public long generateNextSubOrder() {
        return this.subOrderGenerator.getAndIncrement();
    }

    @Override
    public boolean shutdown() {
        return this.shutdown.compareAndSet(false, true);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public PrioritisedExecutor.PrioritisedTask peekFirst() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        return firstEntry == null ? null : firstEntry.getKey().task;
    }

    public Priority getHighestPriority() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        return firstEntry == null ? null : Priority.getPriority(firstEntry.getKey().priority);
    }

    public boolean hasNoScheduledTasks() {
        long scheduledTasks;
        long executedTasks = this.executedTasks.get();
        return executedTasks == (scheduledTasks = this.scheduledTasks.get());
    }

    public PrioritisedExecutor.PriorityState getHighestPriorityState() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry = this.tasks.firstEntry();
        if (firstEntry == null) {
            return null;
        }
        PrioritisedQueuedTask.Holder holder = firstEntry.getKey();
        return new PrioritisedExecutor.PriorityState(Priority.getPriority(holder.priority), holder.subOrder, holder.stream);
    }

    public Runnable pollTask() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry;
        while ((firstEntry = this.tasks.pollFirstEntry()) != null) {
            PrioritisedQueuedTask.Holder task = firstEntry.getKey();
            task.markRemoved();
            if (!task.task.cancel()) continue;
            return task.task.execute;
        }
        return null;
    }

    @Override
    public boolean executeTask() {
        Map.Entry<PrioritisedQueuedTask.Holder, Boolean> firstEntry;
        while ((firstEntry = this.tasks.pollFirstEntry()) != null) {
            PrioritisedQueuedTask.Holder task = firstEntry.getKey();
            task.markRemoved();
            if (!task.task.execute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
        return this.createTask(task, Priority.NORMAL);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
        return this.createTask(task, priority, this.generateNextSubOrder(), 0L);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder, long stream) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        return new PrioritisedQueuedTask(task, priority, subOrder, stream, this.taskIdGenerator.getAndIncrement());
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder, long stream) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority, subOrder, stream);
        ret.queue();
        return ret;
    }

    private final class PrioritisedQueuedTask
    implements PrioritisedExecutor.PrioritisedTask {
        public static final Comparator<Holder> COMPARATOR = (t1, t2) -> {
            int priorityCompare = t1.priority - t2.priority;
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            int subOrderCompare = Long.compare(t1.subOrder, t2.subOrder);
            if (subOrderCompare != 0) {
                return subOrderCompare;
            }
            return Long.signum(t1.id - t2.id);
        };
        public static final Comparator<Holder> COMPARATOR_STREAM = (t1, t2) -> {
            int priorityCompare = t1.priority - t2.priority;
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            int streamCompare = Long.compare(t1.stream, t2.stream);
            if (streamCompare != 0) {
                return streamCompare;
            }
            int subOrderCompare = Long.compare(t1.subOrder, t2.subOrder);
            if (subOrderCompare != 0) {
                return subOrderCompare;
            }
            return Long.signum(t1.id - t2.id);
        };
        private final long id;
        private final Runnable execute;
        private Priority priority;
        private long subOrder;
        private long stream;
        private Holder holder;

        public PrioritisedQueuedTask(Runnable execute, Priority priority, long subOrder, long stream, long id) {
            this.execute = execute;
            this.priority = priority;
            this.subOrder = subOrder;
            this.stream = stream;
            this.id = id;
        }

        @Override
        public PrioritisedExecutor getExecutor() {
            return PrioritisedTaskQueue.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean queue() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                Holder holder;
                if (this.holder != null || this.priority == Priority.COMPLETING) {
                    return false;
                }
                if (PrioritisedTaskQueue.this.isShutdown()) {
                    throw new IllegalStateException("Queue is shutdown");
                }
                this.holder = holder = new Holder(this, this.priority.priority, this.subOrder, this.stream, this.id);
                PrioritisedTaskQueue.this.scheduledTasks.getAndIncrement();
                PrioritisedTaskQueue.this.tasks.put(holder, Boolean.TRUE);
            }
            if (PrioritisedTaskQueue.this.isShutdown() && this.cancel()) {
                throw new IllegalStateException("Queue is shutdown");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isQueued() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.holder != null && this.priority != Priority.COMPLETING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING) {
                    return false;
                }
                this.priority = Priority.COMPLETING;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    PrioritisedTaskQueue.this.executedTasks.getAndIncrement();
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute() {
            boolean increaseExecuted;
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING) {
                    return false;
                }
                this.priority = Priority.COMPLETING;
                increaseExecuted = this.holder != null;
                if (increaseExecuted && this.holder.markRemoved()) {
                    PrioritisedTaskQueue.this.tasks.remove(this.holder);
                }
            }
            try {
                this.execute.run();
                boolean bl = true;
                return bl;
            }
            finally {
                if (increaseExecuted) {
                    PrioritisedTaskQueue.this.executedTasks.getAndIncrement();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Priority getPriority() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.priority;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority == priority) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean raisePriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority.isHigherOrEqualPriority(priority)) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean lowerPriority(Priority priority) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority.isLowerOrEqualPriority(priority)) {
                    return false;
                }
                this.priority = priority;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSubOrder() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.priority == Priority.COMPLETING ? 0L : this.subOrder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder == subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean raiseSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder >= subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean lowerSubOrder(long subOrder) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.subOrder <= subOrder) {
                    return false;
                }
                this.subOrder = subOrder;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getStream() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                return this.priority == Priority.COMPLETING ? 0L : this.stream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setStream(long stream) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.stream == stream) {
                    return false;
                }
                this.stream = stream;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, this.priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPrioritySubOrderStream(Priority priority, long subOrder, long stream) {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING || this.priority == priority && this.subOrder == subOrder && this.stream == stream) {
                    return false;
                }
                this.priority = priority;
                this.subOrder = subOrder;
                this.stream = stream;
                if (this.holder != null) {
                    if (this.holder.markRemoved()) {
                        PrioritisedTaskQueue.this.tasks.remove(this.holder);
                    }
                    this.holder = new Holder(this, priority.priority, this.subOrder, this.stream, this.id);
                    PrioritisedTaskQueue.this.tasks.put(this.holder, Boolean.TRUE);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrioritisedExecutor.PriorityState getPriorityState() {
            PrioritisedQueuedTask prioritisedQueuedTask = this;
            synchronized (prioritisedQueuedTask) {
                if (this.priority == Priority.COMPLETING) {
                    return null;
                }
                return new PrioritisedExecutor.PriorityState(this.priority, this.subOrder, this.stream);
            }
        }

        private static final class Holder {
            private final PrioritisedQueuedTask task;
            private final int priority;
            private final long subOrder;
            private final long stream;
            private final long id;
            private volatile boolean removed;
            private static final VarHandle REMOVED_HANDLE = ConcurrentUtil.getVarHandle(Holder.class, "removed", Boolean.TYPE);

            private Holder(PrioritisedQueuedTask task, int priority, long subOrder, long stream, long id) {
                this.task = task;
                this.priority = priority;
                this.subOrder = subOrder;
                this.stream = stream;
                this.id = id;
            }

            public boolean markRemoved() {
                return false == REMOVED_HANDLE.compareAndExchange(this, false, true);
            }
        }
    }
}

