/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;

public final class FloatTypeAdapter
extends TypeAdapter<Float, Float> {
    public static final FloatTypeAdapter INSTANCE = new FloatTypeAdapter();

    private static Float cast(Object original, double value) {
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Byte value is out of range: " + original.toString());
        }
        return Float.valueOf((float)value);
    }

    @Override
    public Float deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            Number number = (Number)input;
            return FloatTypeAdapter.cast(input, number.doubleValue());
        }
        if (input instanceof String) {
            String string = (String)input;
            return FloatTypeAdapter.cast(input, Double.parseDouble(string));
        }
        throw new IllegalArgumentException("Not a byte type: " + String.valueOf(input.getClass()));
    }

    @Override
    public Float serialize(TypeAdapterRegistry registry, Float value, Type type) {
        return value;
    }
}

