/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.type;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigIntegerTypeAdapter
extends TypeAdapter<BigInteger, String> {
    public static final BigIntegerTypeAdapter INSTANCE = new BigIntegerTypeAdapter();

    @Override
    public BigInteger deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            Number number = (Number)input;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                return bigInteger;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                return bigDecimal.toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (input instanceof String) {
            String string = (String)input;
            return new BigDecimal(string).toBigInteger();
        }
        throw new IllegalArgumentException("Not an BigInteger type: " + String.valueOf(input.getClass()));
    }

    @Override
    public String serialize(TypeAdapterRegistry registry, BigInteger value, Type type) {
        return value.toString();
    }
}

