/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.config;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.DumperOptions;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.LoaderOptions;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.Yaml;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.comments.CommentLine;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.comments.CommentType;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.constructor.BaseConstructor;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.constructor.Constructor;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.nodes.Node;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer.Represent;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer.Representer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public final class YamlConfig<T> {
    public final TypeAdapterRegistry typeAdapters;
    private final Class<? extends T> clazz;
    public volatile T config;
    private final Yaml yaml;
    private final LoaderOptions loaderOptions;
    private final DumperOptions dumperOptions;

    public YamlConfig(Class<? extends T> clazz, T dfl) throws Exception {
        this(clazz, (T)dfl, new TypeAdapterRegistry());
    }

    public YamlConfig(Class<? extends T> clazz, T dfl, TypeAdapterRegistry registry) throws Exception {
        this.clazz = clazz;
        this.config = dfl;
        this.typeAdapters = registry;
        this.typeAdapters.makeAdapter(clazz);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setProcessComments(true);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setProcessComments(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions = loaderOptions;
        this.dumperOptions = dumperOptions;
        this.yaml = new Yaml((BaseConstructor)new YamlConstructor(loaderOptions), (Representer)new YamlRepresenter(dumperOptions), dumperOptions, loaderOptions);
    }

    public void load(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            this.load(is);
        }
    }

    public void load(InputStream is) throws IOException {
        Object serialized = this.yaml.load(new InputStreamReader(is, StandardCharsets.UTF_8));
        this.config = this.typeAdapters.deserialize(serialized, this.clazz);
    }

    public void save(File file) throws IOException {
        this.save(file, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String header) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File is a directory");
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        File tmp = new File(parent, file.getName() + ".tmp");
        tmp.delete();
        tmp.createNewFile();
        try {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));){
                this.save(os, header);
            }
            try {
                Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            tmp.delete();
        }
    }

    public void save(OutputStream os) throws IOException {
        os.write(this.saveToString().getBytes(StandardCharsets.UTF_8));
    }

    public void save(OutputStream os, String header) throws IOException {
        os.write(this.saveToString(header).getBytes(StandardCharsets.UTF_8));
    }

    public String saveToString() {
        return this.yaml.dump(this.typeAdapters.serialize(this.config, this.clazz));
    }

    public String saveToString(String header) {
        if (header.isBlank()) {
            return this.saveToString();
        }
        StringBuilder ret = new StringBuilder();
        String lineBreak = this.dumperOptions.getLineBreak().getString();
        for (String line : header.split("\n")) {
            ret.append("# ").append(line.trim()).append(lineBreak);
        }
        ret.append(lineBreak);
        return ret.append(this.saveToString()).toString();
    }

    public void callInitialisers() {
        this.typeAdapters.callInitialisers(this.config);
    }

    private static final class YamlConstructor
    extends Constructor {
        public YamlConstructor(LoaderOptions loadingConfig) {
            super(loadingConfig);
        }
    }

    private static final class YamlRepresenter
    extends Representer {
        public YamlRepresenter(DumperOptions options) {
            super(options);
            this.representers.put(TypeAdapterRegistry.CommentedData.class, new CommentedDataRepresenter());
        }

        private final class CommentedDataRepresenter
        implements Represent {
            private CommentedDataRepresenter() {
            }

            @Override
            public Node representData(Object data0) {
                TypeAdapterRegistry.CommentedData commentedData = (TypeAdapterRegistry.CommentedData)data0;
                Node node = YamlRepresenter.this.representData(commentedData.data);
                ArrayList<CommentLine> comments = new ArrayList<CommentLine>();
                for (String line : commentedData.comment.split("\n")) {
                    comments.add(new CommentLine(null, null, " ".concat(line.trim()), CommentType.BLOCK));
                }
                node.setBlockComments(comments);
                return node;
            }
        }
    }
}

