/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer;

import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.DumperOptions;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.nodes.Node;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.nodes.Tag;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer.Represent;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer.Representer;
import ca.spottedleaf.moonrise.libs.org.yaml.snakeyaml.representer.SafeRepresenter;
import java.util.Base64;
import java.util.Date;

public class JsonRepresenter
extends Representer {
    public JsonRepresenter(DumperOptions options) {
        super(options);
        this.representers.put(byte[].class, new RepresentByteArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        if (options.getDefaultScalarStyle() != DumperOptions.ScalarStyle.JSON_SCALAR_STYLE) {
            throw new IllegalStateException("JSON requires ScalarStyle.JSON_SCALAR_STYLE");
        }
        if (options.getNonPrintableStyle() != DumperOptions.NonPrintableStyle.ESCAPE) {
            throw new IllegalStateException("JSON requires NonPrintableStyle.ESCAPE");
        }
    }

    protected class RepresentByteArray
    implements Represent {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object data) {
            String binary = Base64.getEncoder().encodeToString((byte[])data);
            return JsonRepresenter.this.representScalar(Tag.STR, binary);
        }
    }

    protected class RepresentDate
    extends SafeRepresenter.RepresentDate {
        protected RepresentDate() {
            super(JsonRepresenter.this);
        }

        @Override
        public Tag getDefaultTag() {
            return Tag.STR;
        }
    }
}

