/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2867;
import net.minecraft.class_3360;
import net.minecraft.class_3977;
import net.minecraft.class_4698;
import net.minecraft.class_6830;
import net.minecraft.class_9240;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3977.class})
abstract class ChunkStorageMixin
implements ChunkSystemChunkStorage,
AutoCloseable {
    @Shadow
    public class_4698 field_21494;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private class_2867 storage;

    ChunkStorageMixin() {
    }

    @Inject(method={"<init>(Lnet/minecraft/class_9240;Ljava/nio/file/Path;Lcom/mojang/datafixers/DataFixer;Z)V"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.storage = this.field_21494.field_21499;
        this.field_21494 = null;
    }

    @Override
    public final class_2867 moonrise$getRegionStorage() {
        return this.storage;
    }

    @Overwrite
    public boolean method_42328(class_1923 pos, int radius) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"method_17907(Lnet/minecraft/class_5321;Ljava/util/function/Supplier;Lnet/minecraft/class_2487;Ljava/util/Optional;)Lnet/minecraft/class_2487;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3360;method_14735(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;"))
    private class_2487 synchroniseLegacyDataUpgrade(class_3360 instance, class_2487 compoundTag) {
        class_3360 class_33602 = instance;
        synchronized (class_33602) {
            return instance.method_14735(compoundTag);
        }
    }

    @Redirect(method={"method_23696(Lnet/minecraft/class_1923;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_4698;method_31738(Lnet/minecraft/class_1923;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Optional<class_2487>> redirectLoad(class_4698 instance, class_1923 chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.method_17911(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    @Redirect(method={"method_17910(Lnet/minecraft/class_1923;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_4698;method_61773(Lnet/minecraft/class_1923;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Void> redirectWrite(class_4698 instance, class_1923 chunkPos, Supplier<class_2487> compoundTag) {
        try {
            this.storage.method_23726(chunkPos, compoundTag.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"method_56564(Lnet/minecraft/class_1923;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3360;method_14744(J)V"))
    private void synchroniseLegacyDataWrite(class_3360 instance, long pos) {
        class_3360 class_33602 = instance;
        synchronized (class_33602) {
            instance.method_14744(pos);
        }
    }

    @Overwrite
    public void method_23697() {
        try {
            this.storage.method_26982();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    @Overwrite
    public void close() throws Exception {
        this.storage.close();
    }

    @Overwrite
    public class_6830 method_39800() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.method_39802(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Overwrite
    public class_9240 method_60999() {
        return this.storage.method_61005();
    }
}

