/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickConstants;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import it.unimi.dsi.fastutil.longs.LongIterator;
import net.minecraft.class_3204;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_9851;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3204.class})
abstract class DistanceManagerMixin
implements ChunkTickDistanceManager {
    @Shadow
    public class_3204.class_3205 field_17454;
    @Unique
    private final PositionCountingAreaMap<class_3222> spawnChunkTracker = new PositionCountingAreaMap();
    @Unique
    private final PositionCountingAreaMap<class_3222> narrowSpawnChunkTracker = new PositionCountingAreaMap();

    DistanceManagerMixin() {
    }

    @Override
    public final void moonrise$addPlayer(class_3222 player, class_4076 pos) {
        this.spawnChunkTracker.add(player, pos.method_18674(), pos.method_18687(), 8);
        this.narrowSpawnChunkTracker.add(player, pos.method_18674(), pos.method_18687(), ChunkTickConstants.NARROW_SPAWN_TRACK_RANGE);
    }

    @Override
    public final void moonrise$removePlayer(class_3222 player, class_4076 pos) {
        this.spawnChunkTracker.remove(player);
        this.narrowSpawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(class_3222 player, class_4076 oldPos, class_4076 newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
            this.narrowSpawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.method_18674(), newPos.method_18687(), 8);
            this.narrowSpawnChunkTracker.addOrUpdate(player, newPos.method_18674(), newPos.method_18687(), ChunkTickConstants.NARROW_SPAWN_TRACK_RANGE);
        }
    }

    @Override
    public final boolean moonrise$hasAnyNearbyNarrow(int chunkX, int chunkZ) {
        return this.narrowSpawnChunkTracker.hasObjectsNear(chunkX, chunkZ);
    }

    @Inject(method={"<init>(Lnet/minecraft/class_10592;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)V"}, at={@At(value="RETURN")})
    private void destroyFields(CallbackInfo ci) {
        this.field_17454 = null;
    }

    @Redirect(method={"method_14048(Lnet/minecraft/class_4076;Lnet/minecraft/class_3222;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3204$class_3205;method_14027(JIZ)V"))
    private void skipSpawnTrackerAdd(class_3204.class_3205 instance, long pos, int i0, boolean b0) {
    }

    @Redirect(method={"method_14051(Lnet/minecraft/class_4076;Lnet/minecraft/class_3222;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3204$class_3205;method_14027(JIZ)V"))
    private void skipSpawnTrackerRemove(class_3204.class_3205 instance, long pos, int i0, boolean b0) {
    }

    @Overwrite
    public int method_14052() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    @Overwrite
    public class_9851 method_20800(long pos) {
        if (this.narrowSpawnChunkTracker.hasObjectsNear(pos)) {
            return class_9851.field_52394;
        }
        return this.spawnChunkTracker.hasObjectsNear(pos) ? class_9851.field_52396 : class_9851.field_52395;
    }

    @Overwrite
    public LongIterator method_61262() {
        return this.spawnChunkTracker.getPositions().iterator();
    }
}

