/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_5362;
import net.minecraft.class_9892;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9892.class})
abstract class ServerExplosionMixin {
    @Shadow
    @Final
    private class_3218 field_52622;
    @Shadow
    @Final
    private class_5362 field_52627;
    @Shadow
    @Final
    private float field_52625;
    @Shadow
    @Final
    private boolean field_52620;
    @Shadow
    @Final
    private class_243 field_52623;
    @Unique
    private static final double[] CACHED_RAYS;
    @Unique
    private static final int CHUNK_CACHE_SHIFT = 2;
    @Unique
    private static final int CHUNK_CACHE_MASK = 3;
    @Unique
    private static final int CHUNK_CACHE_WIDTH = 4;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    @Unique
    private static final Float ZERO_RESISTANCE;
    @Unique
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    @Unique
    private long[] chunkPosCache = null;
    @Unique
    private class_2818[] chunkCache = null;
    @Unique
    private ExplosionBlockCache[] directMappedBlockCache;
    @Unique
    private class_2338.class_2339 mutablePos;

    ServerExplosionMixin() {
    }

    @Unique
    private ExplosionBlockCache getOrCacheExplosionBlock(int x, int y, int z, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        class_2338 pos = new class_2338(x, y, z);
        if (!this.field_52622.method_24794(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            class_2818 chunk;
            int chunkCacheKey = x >> 4 & 3 | z >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x >> 4, z >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.field_52622.method_8497(x >> 4, z >> 4);
            }
            class_2680 blockState = ((GetBlockChunk)chunk).moonrise$getBlock(x, y, z);
            class_3610 fluidState = blockState.method_26227();
            Optional resistance = !calculateResistance ? Optional.empty() : this.field_52627.method_29555((class_1927)this, (class_1922)this.field_52622, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    @Unique
    private boolean clipsAnything(class_243 from, class_243 to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, class_2338.class_2339 currPos) {
        double adjX = 1.0E-7 * (from.field_1352 - to.field_1352);
        double adjY = 1.0E-7 * (from.field_1351 - to.field_1351);
        double adjZ = 1.0E-7 * (from.field_1350 - to.field_1350);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.field_1352 - adjX;
        double toYAdj = to.field_1351 - adjY;
        double toZAdj = to.field_1350 - adjZ;
        double fromXAdj = from.field_1352 + adjX;
        double fromYAdj = from.field_1351 + adjY;
        double fromZAdj = from.field_1350 + adjZ;
        int currX = class_3532.method_15357((double)fromXAdj);
        int currY = class_3532.method_15357((double)fromYAdj);
        int currZ = class_3532.method_15357((double)fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - class_3532.method_15385((double)fromXAdj) : class_3532.method_15385((double)fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - class_3532.method_15385((double)fromYAdj) : class_3532.method_15385((double)fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - class_3532.method_15385((double)fromZAdj) : class_3532.method_15385((double)fromZAdj));
        while (true) {
            class_2680 blockState;
            currPos.method_10103(currX, currY, currZ);
            long key = class_2338.method_10064((int)currX, (int)currY, (int)currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !((CollisionBlockState)blockState).moonrise$emptyContextCollisionShape()) {
                class_265 collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = ((CollisionBlockState)blockState).moonrise$getConstantContextCollisionShape();
                    if (collision == null) {
                        collision = blockState.method_26194((class_1922)this.field_52622, (class_2338)currPos, (class_3726)context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.method_1110() && collision.method_1092(from, to, (class_2338)currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Unique
    private float getSeenFraction(class_243 source, class_1297 target, ExplosionBlockCache[] blockCache, class_2338.class_2339 blockPos) {
        class_238 boundingBox = target.method_5829();
        double diffX = boundingBox.field_1320 - boundingBox.field_1323;
        double diffY = boundingBox.field_1325 - boundingBox.field_1322;
        double diffZ = boundingBox.field_1324 - boundingBox.field_1321;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.field_1323;
        double offY = boundingBox.field_1322;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.field_1321;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    class_243 from = new class_243(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    @Inject(method={"method_61737()I"}, at={@At(value="HEAD")})
    private void initCacheFields(CallbackInfoReturnable<Integer> cir) {
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, class_1923.field_17348);
        this.chunkCache = new class_2818[16];
        this.directMappedBlockCache = new ExplosionBlockCache[512];
        this.mutablePos = new class_2338.class_2339();
    }

    @Overwrite
    public List<class_2338> method_61740() {
        ObjectArrayList ret = new ObjectArrayList();
        class_243 center = this.field_52623;
        ExplosionBlockCache[] blockCache = this.directMappedBlockCache;
        int blockX = class_3532.method_15357((double)center.field_1352);
        int blockY = class_3532.method_15357((double)center.field_1351);
        int blockZ = class_3532.method_15357((double)center.field_1350);
        long key = class_2338.method_10064((int)blockX, (int)blockY, (int)blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = center.field_1352;
            double currY = center.field_1351;
            double currZ = center.field_1350;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.field_52625 * (0.7f + this.field_52622.field_9229.method_43057() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = class_2338.method_10064((int)(blockX2 = class_3532.method_15357((double)currX)), (int)(blockY2 = class_3532.method_15357((double)currY)), (int)(blockZ2 = class_3532.method_15357((double)currZ)))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = this.field_52627.method_29554((class_1927)this, (class_1922)this.field_52622, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.field_52620 || !cachedBlock.blockState.method_26215())) {
                        ret.add((Object)cachedBlock.immutablePos);
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        return ret;
    }

    @Redirect(method={"method_61741()V", "hurtEntities(Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_9892;method_61731(Lnet/minecraft/class_243;Lnet/minecraft/class_1297;)F"))
    private float useBetterSeenPercent(class_243 center, class_1297 target) {
        return this.getSeenFraction(center, target, this.directMappedBlockCache, this.mutablePos);
    }

    @Inject(method={"method_61737()I"}, at={@At(value="RETURN")})
    private void destroyCacheFields(CallbackInfoReturnable<Integer> cir) {
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
        this.directMappedBlockCache = null;
        this.mutablePos = null;
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 15; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double xDir = (float)x / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }
}

