/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedToAABBs;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.MergedORCache;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_245;
import net.minecraft.class_247;
import net.minecraft.class_251;
import net.minecraft.class_259;
import net.minecraft.class_261;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_265.class})
abstract class VoxelShapeMixin
implements CollisionVoxelShape {
    @Shadow
    @Final
    public class_251 field_1401;
    @Unique
    private double offsetX;
    @Unique
    private double offsetY;
    @Unique
    private double offsetZ;
    @Unique
    private class_238 singleAABBRepresentation;
    @Unique
    private double[] rootCoordinatesX;
    @Unique
    private double[] rootCoordinatesY;
    @Unique
    private double[] rootCoordinatesZ;
    @Unique
    private CachedShapeData cachedShapeData;
    @Unique
    private boolean isEmpty;
    @Unique
    private CachedToAABBs cachedToAABBs;
    @Unique
    private class_238 cachedBounds;
    @Unique
    private Boolean isFullBlock;
    @Unique
    private Boolean occludesFullBlock;
    @Unique
    private static final int MERGED_CACHE_SIZE = 16;
    @Unique
    private MergedORCache[] mergedORCache;
    @Unique
    private class_265[] faceShapeClampedCache;

    VoxelShapeMixin() {
    }

    @Shadow
    public abstract DoubleList method_1109(class_2350.class_2351 var1);

    @Override
    public final double moonrise$offsetX() {
        return this.offsetX;
    }

    @Override
    public final double moonrise$offsetY() {
        return this.offsetY;
    }

    @Override
    public final double moonrise$offsetZ() {
        return this.offsetZ;
    }

    @Override
    public final class_238 moonrise$getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    @Override
    public final double[] moonrise$rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    @Override
    public final double[] moonrise$rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    @Override
    public final double[] moonrise$rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    @Unique
    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    @Override
    public final void moonrise$initCache() {
        class_261 offsetDoubleList;
        this.cachedShapeData = ((CollisionDiscreteVoxelShape)this.field_1401).moonrise$getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.method_1109(class_2350.class_2351.field_11048);
        DoubleList yList = this.method_1109(class_2350.class_2351.field_11052);
        DoubleList zList = this.method_1109(class_2350.class_2351.field_11051);
        if (xList instanceof class_261) {
            offsetDoubleList = (class_261)xList;
            this.offsetX = offsetDoubleList.field_1386;
            this.rootCoordinatesX = VoxelShapeMixin.extractRawArray(offsetDoubleList.field_1387);
        } else {
            this.rootCoordinatesX = VoxelShapeMixin.extractRawArray(xList);
        }
        if (yList instanceof class_261) {
            offsetDoubleList = (class_261)yList;
            this.offsetY = offsetDoubleList.field_1386;
            this.rootCoordinatesY = VoxelShapeMixin.extractRawArray(offsetDoubleList.field_1387);
        } else {
            this.rootCoordinatesY = VoxelShapeMixin.extractRawArray(yList);
        }
        if (zList instanceof class_261) {
            offsetDoubleList = (class_261)zList;
            this.offsetZ = offsetDoubleList.field_1386;
            this.rootCoordinatesZ = VoxelShapeMixin.extractRawArray(offsetDoubleList.field_1387);
        } else {
            this.rootCoordinatesZ = VoxelShapeMixin.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new class_238(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    @Override
    public final CachedShapeData moonrise$getCachedVoxelData() {
        return this.cachedShapeData;
    }

    @Override
    public final class_265 moonrise$getFaceShapeClamped(class_2350 direction) {
        class_265 ret;
        if (this.isEmpty) {
            return (class_265)this;
        }
        if ((class_265)this == class_259.method_1077()) {
            return (class_265)this;
        }
        class_265[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new class_265[6];
        }
        class_2350.class_2351 axis = direction.method_10166();
        class_265 ret2 = direction.method_10171() == class_2350.class_2352.field_11056 ? (DoubleMath.fuzzyEquals((double)this.method_1105(axis), (double)1.0, (double)1.0E-7) ? CollisionUtil.sliceShape((class_265)this, axis, this.field_1401.method_1051(axis) - 1) : class_259.method_1073()) : (DoubleMath.fuzzyEquals((double)this.method_1091(axis), (double)0.0, (double)1.0E-7) ? CollisionUtil.sliceShape((class_265)this, axis, 0) : class_259.method_1073());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    @Unique
    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.moonrise$isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        class_238 singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.field_1322 <= 1.0E-7 && singleAABB.field_1325 >= 0.9999999 && singleAABB.field_1323 <= 1.0E-7 && singleAABB.field_1320 >= 0.9999999 && singleAABB.field_1321 <= 1.0E-7 && singleAABB.field_1324 >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !class_259.method_1074((class_265)class_259.method_1077(), (class_265)((class_265)this), (class_247)class_247.field_16886);
        this.occludesFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    @Override
    public final boolean moonrise$occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    @Unique
    private static int hash(class_265 key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    @Override
    public final class_265 moonrise$orUnoptimized(class_265 other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if ((class_265)this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.method_1110()) {
            return (class_265)this;
        }
        int thisCacheKey = VoxelShapeMixin.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShapeMixin.hash((class_265)this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = ((VoxelShapeMixin)other).mergedORCache == null ? null : ((VoxelShapeMixin)other).mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == (class_265)this) {
            return otherCache.result();
        }
        class_265 result = class_259.method_1082((class_265)((class_265)this), (class_265)other, (class_247)class_247.field_1366);
        if (cached != null && otherCache == null) {
            if (((VoxelShapeMixin)other).mergedORCache == null) {
                ((VoxelShapeMixin)other).mergedORCache = new MergedORCache[16];
            }
            ((VoxelShapeMixin)other).mergedORCache[otherCacheKey] = new MergedORCache((class_265)this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    @Overwrite
    public boolean method_1110() {
        return this.isEmpty;
    }

    @Overwrite
    public class_265 method_52620() {
        if (this.isEmpty) {
            return class_259.method_1073();
        }
        return class_259.method_1078((class_238)this.method_1107());
    }

    @Overwrite
    protected double method_1099(class_2350.class_2351 axis, int idx) {
        switch (axis) {
            case field_11048: {
                return this.rootCoordinatesX[idx] + this.offsetX;
            }
            case field_11052: {
                return this.rootCoordinatesY[idx] + this.offsetY;
            }
            case field_11051: {
                return this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Overwrite
    public int method_1100(class_2350.class_2351 axis, double value) {
        switch (axis) {
            case field_11048: {
                double[] values = this.rootCoordinatesX;
                return CollisionUtil.findFloor(values, this.offsetX, value, 0, values.length - 1);
            }
            case field_11052: {
                double[] values = this.rootCoordinatesY;
                return CollisionUtil.findFloor(values, this.offsetY, value, 0, values.length - 1);
            }
            case field_11051: {
                double[] values = this.rootCoordinatesZ;
                return CollisionUtil.findFloor(values, this.offsetZ, value, 0, values.length - 1);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Unique
    private class_265 calculateFaceDirect(class_2350 direction, class_2350.class_2351 axis, double[] coords, double offset) {
        if (coords.length == 2 && DoubleMath.fuzzyEquals((double)(coords[0] + offset), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)(coords[1] + offset), (double)1.0, (double)1.0E-7)) {
            return (class_265)this;
        }
        boolean positiveDir = direction.method_10171() == class_2350.class_2352.field_11056;
        int index = CollisionUtil.findFloor(coords, offset, positiveDir ? 0.9999999 : 1.0E-7, 0, coords.length - 1);
        return CollisionUtil.sliceShape((class_265)this, axis, index);
    }

    @Overwrite
    public class_265 method_1098(class_2350 direction) {
        class_2350.class_2351 axis = direction.method_10166();
        switch (axis) {
            case field_11048: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesX, this.offsetX);
            }
            case field_11052: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesY, this.offsetY);
            }
            case field_11051: {
                return this.calculateFaceDirect(direction, axis, this.rootCoordinatesZ, this.offsetZ);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Overwrite
    public double method_1108(class_2350.class_2351 axis, class_238 source, double source_move) {
        if (this.isEmpty) {
            return source_move;
        }
        if (Math.abs(source_move) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case field_11048: {
                return CollisionUtil.collideX((class_265)this, source, source_move);
            }
            case field_11052: {
                return CollisionUtil.collideY((class_265)this, source, source_move);
            }
            case field_11051: {
                return CollisionUtil.collideZ((class_265)this, source, source_move);
            }
        }
        throw new RuntimeException("Unknown axis: " + String.valueOf(axis));
    }

    @Unique
    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new class_261((DoubleList)wrap, by);
    }

    @Overwrite
    public class_265 method_1096(double x, double y, double z) {
        if (this.isEmpty) {
            return class_259.method_1073();
        }
        class_245 ret = new class_245(this.field_1401, VoxelShapeMixin.offsetList(this.rootCoordinatesX, this.offsetX + x), VoxelShapeMixin.offsetList(this.rootCoordinatesY, this.offsetY + y), VoxelShapeMixin.offsetList(this.rootCoordinatesZ, this.offsetZ + z));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ((VoxelShapeMixin)ret).cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, x, y, z);
        }
        return ret;
    }

    @Unique
    private List<class_238> toAabbsUncached() {
        ArrayList<class_238> ret;
        if (this.singleAABBRepresentation != null) {
            ret = new ArrayList(1);
            ret.add(this.singleAABBRepresentation);
        } else {
            ret = new ArrayList<class_238>();
            double[] coordsX = this.rootCoordinatesX;
            double[] coordsY = this.rootCoordinatesY;
            double[] coordsZ = this.rootCoordinatesZ;
            double offX = this.offsetX;
            double offY = this.offsetY;
            double offZ = this.offsetZ;
            this.field_1401.method_1053((minX, minY, minZ, maxX, maxY, maxZ) -> ret.add(new class_238(coordsX[minX] + offX, coordsY[minY] + offY, coordsZ[minZ] + offZ, coordsX[maxX] + offX, coordsY[maxY] + offY, coordsZ[maxZ] + offZ)), true);
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    @Overwrite
    public List<class_238> method_1090() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    @Unique
    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if ((class_265)this == class_259.method_1077()) {
                ret = Boolean.TRUE;
            } else {
                class_238 singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x = sMinX; x < sMaxX; ++x) {
                            for (int y = sMinY; y < sMaxY; ++y) {
                                int baseIndex = y * sizeZ + x * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.field_1323) <= 1.0E-7 && Math.abs(singleAABB.field_1322) <= 1.0E-7 && Math.abs(singleAABB.field_1321) <= 1.0E-7 && Math.abs(1.0 - singleAABB.field_1320) <= 1.0E-7 && Math.abs(1.0 - singleAABB.field_1325) <= 1.0E-7 && Math.abs(1.0 - singleAABB.field_1324) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    @Unique
    private static class_3965 clip(class_238 aabb, class_243 from, class_243 to, class_2338 offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.field_1352 - from.field_1352;
        double diffY = to.field_1351 - from.field_1351;
        double diffZ = to.field_1350 - from.field_1350;
        class_2350 direction = class_238.method_1007((class_238)aabb.method_996(offset), (class_243)from, (double[])minDistanceArr, null, (double)diffX, (double)diffY, (double)diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new class_3965(from.method_1031(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    @Overwrite
    public class_3965 method_1092(class_243 from, class_243 to, class_2338 offset) {
        if (this.isEmpty) {
            return null;
        }
        class_243 directionOpposite = to.method_1020(from);
        if (directionOpposite.method_1027() < 1.0E-7) {
            return null;
        }
        class_243 fromBehind = from.method_1019(directionOpposite.method_1021(0.001));
        double fromBehindOffsetX = fromBehind.field_1352 - (double)offset.method_10263();
        double fromBehindOffsetY = fromBehind.field_1351 - (double)offset.method_10264();
        double fromBehindOffsetZ = fromBehind.field_1350 - (double)offset.method_10260();
        class_238 singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.method_1008(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new class_3965(fromBehind, class_2350.method_10142((double)directionOpposite.field_1352, (double)directionOpposite.field_1351, (double)directionOpposite.field_1350).method_10153(), offset, true);
            }
            return VoxelShapeMixin.clip(singleAABB, from, to, offset);
        }
        if (CollisionUtil.strictlyContains((class_265)this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new class_3965(fromBehind, class_2350.method_10142((double)directionOpposite.field_1352, (double)directionOpposite.field_1351, (double)directionOpposite.field_1350).method_10153(), offset, true);
        }
        return class_238.method_1010((Iterable)((class_265)this).method_1090(), (class_243)from, (class_243)to, (class_2338)offset);
    }

    @Overwrite
    public class_238 method_1107() {
        if (this.isEmpty) {
            throw (UnsupportedOperationException)class_156.method_22320((Throwable)new UnsupportedOperationException("No bounds for empty shape."));
        }
        class_238 cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new class_238(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    @Overwrite
    public double method_1091(class_2350.class_2351 axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case field_11048: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case field_11052: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case field_11051: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Overwrite
    public double method_1105(class_2350.class_2351 axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case field_11048: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case field_11052: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case field_11051: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Overwrite
    public class_265 method_1097() {
        if (this.isEmpty) {
            return class_259.method_1073();
        }
        if (this.singleAABBRepresentation != null) {
            return this.moonrise$isFullBlock() ? class_259.method_1077() : (class_265)this;
        }
        List<class_238> aabbs = this.method_1090();
        if (aabbs.isEmpty()) {
            return class_259.method_1073();
        }
        if (aabbs.size() == 1) {
            class_238 singleAABB = aabbs.get(0);
            class_265 ret = class_259.method_1078((class_238)singleAABB);
            if (((VoxelShapeMixin)ret).cachedToAABBs == null) {
                ((VoxelShapeMixin)ret).cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        class_265[] tmp = new class_265[aabbs.size()];
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            tmp[i] = class_259.method_1078((class_238)aabbs.get(i));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                class_265 first = tmp[i];
                class_265 second = tmp[next];
                tmp[newSize++] = class_259.method_1082((class_265)first, (class_265)second, (class_247)class_247.field_1366);
            }
            size = newSize;
        }
        class_265 ret = tmp[0];
        if (((VoxelShapeMixin)ret).cachedToAABBs == null) {
            ((VoxelShapeMixin)ret).cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    @Overwrite
    public Optional<class_243> method_33661(class_243 point) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        class_243 ret = null;
        double retDistance = Double.MAX_VALUE;
        List<class_238> aabbs = this.method_1090();
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            double z;
            double y;
            class_238 aabb = aabbs.get(i);
            double x = class_3532.method_15350((double)point.field_1352, (double)aabb.field_1323, (double)aabb.field_1320);
            double dist = point.method_1028(x, y = class_3532.method_15350((double)point.field_1351, (double)aabb.field_1322, (double)aabb.field_1325), z = class_3532.method_15350((double)point.field_1350, (double)aabb.field_1321, (double)aabb.field_1324));
            if (!(dist < retDistance)) continue;
            ret = new class_243(x, y, z);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }
}

