/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.fluid;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3609.class})
abstract class FlowingFluidMixin
extends class_3611 {
    @Shadow
    @Final
    public static class_2746 field_15902;
    @Shadow
    @Final
    public static class_2758 field_15900;
    @Unique
    private class_3610 sourceFalling;
    @Unique
    private class_3610 sourceNotFalling;
    @Unique
    private static final int TOTAL_FLOWING_STATES;
    @Unique
    private static final int MIN_LEVEL;
    @Unique
    private class_3610[] flowingLookUp;
    @Unique
    private volatile boolean init;
    @Unique
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    @Unique
    private static final ThreadLocal<FluidOcclusionCacheKey[]> COLLISION_OCCLUSION_CACHE;

    FlowingFluidMixin() {
    }

    @Shadow
    public abstract class_3611 method_15751();

    @Shadow
    public abstract class_3611 method_15750();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void init() {
        FlowingFluidMixin flowingFluidMixin = this;
        synchronized (flowingFluidMixin) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new class_3610[TOTAL_FLOWING_STATES];
            class_3610 defaultFlowState = this.method_15750().method_15785();
            for (int i = 0; i < TOTAL_FLOWING_STATES; ++i) {
                int falling = i & 1;
                int level = (i >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i] = (class_3610)((class_3610)defaultFlowState.method_11657((class_2769)field_15902, (Comparable)(falling == 1 ? Boolean.TRUE : Boolean.FALSE))).method_11657((class_2769)field_15900, (Comparable)Integer.valueOf(level));
            }
            class_3610 defaultFallState = this.method_15751().method_15785();
            this.sourceFalling = (class_3610)defaultFallState.method_11657((class_2769)field_15902, (Comparable)Boolean.TRUE);
            this.sourceNotFalling = (class_3610)defaultFallState.method_11657((class_2769)field_15902, (Comparable)Boolean.FALSE);
            this.init = true;
        }
    }

    @Overwrite
    public class_3610 method_15729(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    @Overwrite
    public class_3610 method_15728(int amount, boolean falling) {
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    @Overwrite
    public static boolean method_15732(class_2350 direction, class_1922 level, class_2338 fromPos, class_2680 fromState, class_2338 toPos, class_2680 toState) {
        class_265 shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (((CollisionBlockState)fromState).moonrise$emptyCollisionShape() & ((CollisionBlockState)toState).moonrise$emptyCollisionShape()) {
            return true;
        }
        if (((CollisionBlockState)fromState).moonrise$occludesFullBlock() | ((CollisionBlockState)toState).moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = ((CollisionBlockState)fromState).moonrise$hasCache() & ((CollisionBlockState)toState).moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE.get() : null;
        int keyIndex = (((CollisionBlockState)fromState).moonrise$uniqueId1() ^ ((CollisionBlockState)toState).moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        class_265 shape1 = fromState.method_26220(level, fromPos);
        boolean bl = result = !class_259.method_1080((class_265)shape1, (class_265)(shape2 = toState.method_26220(level, toPos)), (class_2350)direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    static {
        TOTAL_FLOWING_STATES = field_15902.method_11898().size() * field_15900.method_11898().size();
        MIN_LEVEL = (Integer)field_15900.method_11898().stream().sorted().findFirst().get();
        COLLISION_OCCLUSION_CACHE = ThreadLocal.withInitial(() -> new FluidOcclusionCacheKey[2048]);
    }
}

