/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.starlight.lightengine;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_10171;
import net.minecraft.class_10176;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2676;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_3244;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3227.class})
abstract class ThreadedLevelLightEngineMixin
extends class_3568
implements StarLightLightingProvider {
    @Shadow
    public class_10176 field_54049;
    @Shadow
    public class_10171 field_54050;
    @Unique
    private final AtomicLong chunkWorkCounter = new AtomicLong();

    public ThreadedLevelLightEngineMixin(class_2823 chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> supplier) {
        class_3218 world = (class_3218)this.starlight$getLightEngine().getWorld();
        class_2791 center = this.starlight$getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.method_12009().method_12165(class_2806.field_12805)) {
            return;
        }
        StarLightInterface.ServerLightQueue.ServerChunkTasks scheduledTask = (StarLightInterface.ServerLightQueue.ServerChunkTasks)supplier.get();
        if (scheduledTask == null) {
            return;
        }
        if (!scheduledTask.markTicketAdded()) {
            return;
        }
        Long ticketId = this.chunkWorkCounter.getAndIncrement();
        class_1923 pos = new class_1923(chunkX, chunkZ);
        ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.LIGHT_TICKET_LEVEL, ticketId);
        scheduledTask.queueOrRunTask(() -> ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.LIGHT_TICKET_LEVEL, ticketId));
    }

    @Override
    public final int starlight$serverRelightChunks(Collection<class_1923> chunks0, Consumer<class_1923> chunkLightCallback, IntConsumer onComplete) {
        LinkedHashSet<class_1923> chunks = new LinkedHashSet<class_1923>(chunks0);
        HashMap<class_1923, Long> ticketIds = new HashMap<class_1923, Long>();
        class_3218 world = (class_3218)this.starlight$getLightEngine().getWorld();
        if (chunks.isEmpty()) {
            if (onComplete != null) {
                onComplete.accept(0);
            }
            return 0;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            class_1923 pos = (class_1923)iterator.next();
            minX = Math.min(pos.field_9181, minX);
            minZ = Math.min(pos.field_9180, minZ);
            maxX = Math.max(pos.field_9181, maxX);
            maxZ = Math.max(pos.field_9180, maxZ);
            Long id = ChunkTaskScheduler.getNextChunkRelightId();
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.LIGHT_TICKET_LEVEL, id);
            ticketIds.put(pos, id);
            class_2791 chunk = (class_2791)world.method_14178().method_12246(pos.field_9181, pos.field_9180);
            if (chunk != null && chunk.method_12038() && chunk.method_12009().method_12165(class_2806.field_12805)) continue;
            iterator.remove();
            ticketIds.remove(pos);
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.LIGHT_TICKET_LEVEL, id);
        }
        ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().radiusAwareScheduler.queueTask(minX, minZ, maxX, maxZ, () -> this.starlight$getLightEngine().relightChunks(chunks, pos -> {
            if (chunkLightCallback != null) {
                chunkLightCallback.accept((class_1923)pos);
            }
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().scheduleChunkTask(pos.field_9181, pos.field_9180, () -> {
                NewChunkHolder chunkHolder = ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos.field_9181, pos.field_9180);
                if (chunkHolder == null) {
                    return;
                }
                List<class_3222> players = ((ChunkSystemChunkHolder)chunkHolder.vanillaChunkHolder).moonrise$getPlayers(false);
                if (players.isEmpty()) {
                    return;
                }
                class_2676 relightPacket = new class_2676(pos, (class_3568)((class_3227)this), null, null);
                for (class_3222 player : players) {
                    class_3244 conn = player.field_13987;
                    if (conn == null) continue;
                    conn.method_14364((class_2596)relightPacket);
                }
            });
        }, relight -> {
            if (onComplete != null) {
                onComplete.accept(relight);
            }
            for (Map.Entry entry : ticketIds.entrySet()) {
                ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_RELIGHT, (class_1923)entry.getKey(), StarLightInterface.LIGHT_TICKET_LEVEL, (Long)entry.getValue());
            }
        }));
        return chunks.size();
    }

    @Inject(method={"<init>(Lnet/minecraft/class_2823;Lnet/minecraft/class_3898;ZLnet/minecraft/class_10176;Lnet/minecraft/class_10171;)V"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.field_54049 = null;
        this.field_54050 = null;
    }

    @Overwrite
    public void method_17308(int x, int z, class_3227.class_3901 type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_17307(int x, int z, IntSupplier ticketLevelSupplier, class_3227.class_3901 type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_17303() {
    }

    @Overwrite
    public void method_14277() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_15513(class_2338 pos) {
        class_2338 posCopy = pos.method_10062();
        this.queueTaskForSection(posCopy.method_10263() >> 4, posCopy.method_10264() >> 4, posCopy.method_10260() >> 4, () -> this.starlight$getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void method_20386(class_1923 pos) {
    }

    @Overwrite
    public void method_15551(class_4076 pos, boolean notReady) {
        this.queueTaskForSection(pos.method_10263(), pos.method_10264(), pos.method_10260(), () -> this.starlight$getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void method_51471(class_1923 pos) {
    }

    @Overwrite
    public void method_15512(class_1923 pos, boolean lightEnabled) {
    }

    @Overwrite
    public void method_15558(class_1944 lightType, class_4076 pos, @Nullable class_2804 nibbles) {
    }

    @Overwrite
    public void method_20601(class_1923 pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<class_2791> method_51285(class_2791 chunk, boolean lit) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Overwrite
    public CompletableFuture<class_2791> method_17310(class_2791 chunk, boolean lit) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<?> method_53694(int chunkX, int chunkZ) {
        throw new UnsupportedOperationException();
    }
}

