/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.starlight.world;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_3568;
import net.minecraft.class_4153;
import net.minecraft.class_5539;
import net.minecraft.class_9240;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2852.class})
abstract class SerializableChunkDataMixin {
    @Shadow
    @Final
    private class_2806 comp_2950;
    @Shadow
    @Final
    private boolean comp_2958;
    @Shadow
    @Final
    private List<class_2852.class_9898> comp_2959;
    @Shadow
    @Final
    private static Logger field_13001;

    SerializableChunkDataMixin() {
    }

    @Redirect(method={"method_61794(Lnet/minecraft/class_5539;Lnet/minecraft/class_11897;Lnet/minecraft/class_2487;)Lnet/minecraft/class_2852;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2487;method_68566(Ljava/lang/String;Z)Z", ordinal=0))
    private static boolean setLightCorrect(class_2487 instance, String string, boolean dfl, @Local(ordinal=0, argsOnly=false) class_2806 status) {
        boolean starlightCorrect = instance.method_10580("isLightOn") != null && instance.method_68083("starlight.light_version", -1) == 10;
        return status.method_12165(class_2806.field_12805) && starlightCorrect;
    }

    @Redirect(method={"method_61794(Lnet/minecraft/class_5539;Lnet/minecraft/class_11897;Lnet/minecraft/class_2487;)Lnet/minecraft/class_2852;"}, at=@At(value="NEW", target="(ILnet/minecraft/class_2826;Lnet/minecraft/class_2804;Lnet/minecraft/class_2804;)Lnet/minecraft/class_2852$class_9898;", ordinal=0))
    private static class_2852.class_9898 readStarlightState(int y, class_2826 chunkSection, class_2804 blockLight, class_2804 skyLight, @Local(ordinal=2, argsOnly=false) class_2487 sectionData) {
        class_2852.class_9898 ret = new class_2852.class_9898(y, chunkSection, blockLight, skyLight);
        if (sectionData.method_10545("starlight.blocklight_state")) {
            ((StarlightSectionData)ret).starlight$setBlockLightState(sectionData.method_68083("starlight.blocklight_state", 0));
        }
        if (sectionData.method_10545("starlight.skylight_state")) {
            ((StarlightSectionData)ret).starlight$setSkyLightState(sectionData.method_68083("starlight.skylight_state", 0));
        }
        return ret;
    }

    @Inject(method={"method_12395(Lnet/minecraft/class_3218;Lnet/minecraft/class_4153;Lnet/minecraft/class_9240;Lnet/minecraft/class_1923;)Lnet/minecraft/class_2839;"}, at={@At(value="RETURN")})
    private void loadStarlightLightData(class_3218 world, class_4153 poiManager, class_9240 regionStorageInfo, class_1923 pos, CallbackInfoReturnable<class_2839> cir) {
        class_2839 ret = (class_2839)cir.getReturnValue();
        boolean hasSkyLight = world.method_8597().comp_642();
        int minSection = WorldUtil.getMinLightSection((class_5539)world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((class_5539)world);
        if (!this.comp_2958) {
            ((StarlightChunk)ret).starlight$setBlockNibbles(blockNibbles);
            ((StarlightChunk)ret).starlight$setSkyNibbles(skyNibbles);
            return;
        }
        try {
            for (class_2852.class_9898 sectionData : this.comp_2959) {
                int y = sectionData.comp_2963();
                class_2804 blockLight = sectionData.comp_2965();
                class_2804 skyLight = sectionData.comp_2966();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.method_12137()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.method_12137()), skyState);
                    continue;
                }
                skyNibbles[y - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ((StarlightChunk)ret).starlight$setBlockNibbles(blockNibbles);
            ((StarlightChunk)ret).starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.method_12020(false);
            field_13001.error("Failed to parse light data for chunk " + String.valueOf(ret.method_12004()) + " in world '" + WorldUtil.getWorldName((class_1937)world) + "'", thr);
        }
    }

    @Redirect(method={"method_61793(Lnet/minecraft/class_3218;Lnet/minecraft/class_2791;)Lnet/minecraft/class_2852;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3568;method_31929()I", ordinal=0))
    private static int rewriteSectionCopy(class_3568 instance, @Local(ordinal=0, argsOnly=true) class_3218 world, @Local(ordinal=0, argsOnly=true) class_2791 chunk, @Local(ordinal=0, argsOnly=false) List<class_2852.class_9898> sections) {
        int minLightSection = WorldUtil.getMinLightSection((class_5539)world);
        int maxLightSection = WorldUtil.getMaxLightSection((class_5539)world);
        int minBlockSection = WorldUtil.getMinSection((class_1937)world);
        class_2826[] chunkSections = chunk.method_12006();
        SWMRNibbleArray[] blockNibbles = ((StarlightChunk)chunk).starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = ((StarlightChunk)chunk).starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            class_2826 chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].method_61771() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState skyNibble = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && skyNibble == null) continue;
            class_2852.class_9898 sectionData = new class_2852.class_9898(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new class_2804(blockNibble.data)), skyNibble == null ? null : (skyNibble.data == null ? null : new class_2804(skyNibble.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (skyNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(skyNibble.state);
            }
            sections.add(sectionData);
        }
        return Integer.MAX_VALUE;
    }

    @Inject(method={"method_12410()Lnet/minecraft/class_2487;"}, at={@At(value="FIELD", target="Lnet/minecraft/class_2852$class_9898;comp_2964:Lnet/minecraft/class_2826;", ordinal=0)})
    private void storeStarlightState(CallbackInfoReturnable<class_2487> cir, @Local(ordinal=0, argsOnly=false) class_2852.class_9898 sectionData, @Local(ordinal=1, argsOnly=false) class_2487 sectionNBT) {
        int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
        int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
        if (blockState > 0) {
            sectionNBT.method_10569("starlight.blocklight_state", blockState);
        }
        if (skyState > 0) {
            sectionNBT.method_10569("starlight.skylight_state", skyState);
        }
    }

    @Inject(method={"method_12410()Lnet/minecraft/class_2487;"}, at={@At(value="RETURN")})
    private void writeStarlightCorrectLight(CallbackInfoReturnable<class_2487> cir) {
        if (this.comp_2950.method_60549(class_2806.field_12805) || !this.comp_2958) {
            return;
        }
        class_2487 ret = (class_2487)cir.getReturnValue();
        ret.method_10556("isLightOn", false);
        ret.method_10569("starlight.light_version", 10);
    }
}

