/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2867;
import net.minecraft.class_9240;

public final class EntityDataController
extends MoonriseRegionFileIO.RegionDataController {
    private final EntityRegionFileStorage storage;

    public EntityDataController(EntityRegionFileStorage storage, ChunkTaskScheduler taskScheduler) {
        super(MoonriseRegionFileIO.RegionFileType.ENTITY_DATA, taskScheduler.ioExecutor, taskScheduler.compressionExecutor);
        this.storage = storage;
    }

    @Override
    public class_2867 getCache() {
        return this.storage;
    }

    @Override
    public MoonriseRegionFileIO.RegionDataController.WriteData startWrite(int chunkX, int chunkZ, class_2487 compound) throws IOException {
        EntityDataController.checkPosition(new class_1923(chunkX, chunkZ), compound);
        return ((ChunkSystemRegionFileStorage)this.getCache()).moonrise$startWrite(chunkX, chunkZ, compound);
    }

    @Override
    public void finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        ((ChunkSystemRegionFileStorage)this.getCache()).moonrise$finishWrite(chunkX, chunkZ, writeData);
    }

    @Override
    public MoonriseRegionFileIO.RegionDataController.ReadData readData(int chunkX, int chunkZ) throws IOException {
        return ((ChunkSystemRegionFileStorage)this.getCache()).moonrise$readData(chunkX, chunkZ);
    }

    @Override
    public class_2487 finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        return ((ChunkSystemRegionFileStorage)this.getCache()).moonrise$finishRead(chunkX, chunkZ, readData);
    }

    private static void checkPosition(class_1923 pos, class_2487 nbt) {
        class_1923 nbtPos;
        class_1923 class_19232 = nbtPos = nbt == null ? null : (class_1923)nbt.method_67491("Position", class_1923.field_54241).orElse(null);
        if (nbtPos != null && !pos.equals((Object)nbtPos)) {
            throw new IllegalArgumentException("Entity chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + pos.toString() + " but compound says coordinate is " + String.valueOf(nbtPos));
        }
    }

    public static final class EntityRegionFileStorage
    extends class_2867 {
        public EntityRegionFileStorage(class_9240 regionStorageInfo, Path directory, boolean dsync) {
            super(regionStorageInfo, directory, dsync);
        }

        public void method_23726(class_1923 pos, class_2487 nbt) throws IOException {
            EntityDataController.checkPosition(pos, nbt);
            super.method_23726(pos, nbt);
        }
    }
}

