/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.EntityList;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5584;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.slf4j.Logger;

public final class ChunkEntitySlices {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final int minSection;
    public final int maxSection;
    public final int chunkX;
    public final int chunkZ;
    public final class_1937 world;
    private final EntityCollectionBySection allEntities;
    private final EntityCollectionBySection hardCollidingEntities;
    private final Reference2ObjectOpenHashMap<Class<? extends class_1297>, EntityCollectionBySection> entitiesByClass;
    private final Reference2ObjectOpenHashMap<class_1299<?>, EntityCollectionBySection> entitiesByType;
    private final EntityList entities = new EntityList();
    public class_3194 status;
    public final ChunkData chunkData;
    private boolean isTransient;
    private boolean preventStatusUpdates;

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public ChunkEntitySlices(class_1937 world, int chunkX, int chunkZ, class_3194 status, ChunkData chunkData, int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.allEntities = new EntityCollectionBySection(this);
        this.hardCollidingEntities = new EntityCollectionBySection(this);
        this.entitiesByClass = new Reference2ObjectOpenHashMap();
        this.entitiesByType = new Reference2ObjectOpenHashMap();
        this.status = status;
        this.chunkData = chunkData;
    }

    public static List<class_1297> readEntities(class_3218 world, class_1923 pos, class_2487 compoundTag) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(class_2791.method_71413((class_1923)pos), LOGGER);){
            class_11368 valueinput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)world.method_30349(), (class_2487)compoundTag);
            List list = (List)class_1299.method_31489((class_11368.class_11370)valueinput.method_71438("Entities"), (class_1937)world, (class_3730)class_3730.field_52444).collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public static void copyEntities(class_2487 from, class_2487 into) {
        if (from == null) {
            return;
        }
        class_2499 entitiesFrom = from.method_68569("Entities");
        if (entitiesFrom == null || entitiesFrom.isEmpty()) {
            return;
        }
        class_2499 entitiesInto = into.method_68569("Entities");
        into.method_10566("Entities", (class_2520)entitiesInto);
        entitiesInto.addAll(0, (Collection)entitiesFrom);
    }

    public static class_2487 saveEntityChunk(List<class_1297> entities, class_1923 chunkPos, class_3218 world) {
        return ChunkEntitySlices.saveEntityChunk0(entities, chunkPos, world, false);
    }

    public static class_2487 saveEntityChunk0(List<class_1297> entities, class_1923 chunkPos, class_3218 world, boolean force) {
        if (!force && entities.isEmpty()) {
            return null;
        }
        class_2499 entitiesTag = new class_2499();
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(class_2791.method_71413((class_1923)chunkPos), LOGGER);){
            for (class_1297 entity : PlatformHooks.get().modifySavedEntities(world, chunkPos.field_9181, chunkPos.field_9180, entities)) {
                class_11362 savedEntity = class_11362.method_71459((class_8942)scopedCollector.method_54946(entity.method_71370()), (class_7225.class_7874)entity.method_56673());
                try {
                    if (!entity.method_5662((class_11372)savedEntity)) continue;
                    entitiesTag.add((Object)savedEntity.method_71475());
                }
                catch (Exception ex) {
                    LOGGER.error("Entity type " + String.valueOf(entity.method_5864()) + " failed to serialize", (Throwable)ex);
                }
            }
        }
        class_2487 ret = class_2512.method_48310((class_2487)new class_2487());
        ret.method_10566("Entities", (class_2520)entitiesTag);
        ret.method_67494("Position", class_1923.field_54241, (Object)chunkPos);
        return !force && entitiesTag.isEmpty() ? null : ret;
    }

    public class_2487 save() {
        int len = this.entities.size();
        if (len == 0) {
            return null;
        }
        class_1297[] rawData = this.entities.getRawData();
        ArrayList<class_1297> collectedEntities = new ArrayList<class_1297>(len);
        for (int i = 0; i < len; ++i) {
            class_1297 entity = rawData[i];
            if (!entity.method_31746()) continue;
            collectedEntities.add(entity);
        }
        if (collectedEntities.isEmpty()) {
            return null;
        }
        return ChunkEntitySlices.saveEntityChunk(collectedEntities, new class_1923(this.chunkX, this.chunkZ), (class_3218)this.world);
    }

    public boolean unload() {
        int len = this.entities.size();
        class_1297[] collectedEntities = Arrays.copyOf(this.entities.getRawData(), len);
        for (int i = 0; i < len; ++i) {
            class_1297 entity = collectedEntities[i];
            if (entity.method_31481() || !entity.method_31746()) continue;
            PlatformHooks.get().unloadEntity(entity);
            if (!entity.method_5782()) continue;
            for (class_1297 passenger : entity.method_5736()) {
                PlatformHooks.get().unloadEntity(passenger);
            }
        }
        return this.entities.size() != 0;
    }

    public List<class_1297> getAllEntities() {
        int len = this.entities.size();
        if (len == 0) {
            return new ArrayList<class_1297>();
        }
        class_1297[] rawData = this.entities.getRawData();
        ArrayList<class_1297> collectedEntities = new ArrayList<class_1297>(len);
        for (int i = 0; i < len; ++i) {
            collectedEntities.add(rawData[i]);
        }
        return collectedEntities;
    }

    public boolean isEmpty() {
        return this.entities.size() == 0;
    }

    public void mergeInto(ChunkEntitySlices slices) {
        class_1297[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i = 0; i < size; ++i) {
            class_1297 entity = entities[i];
            slices.addEntity(entity, ((ChunkSystemEntity)entity).moonrise$getSectionY());
        }
    }

    public boolean startPreventingStatusUpdates() {
        boolean ret = this.preventStatusUpdates;
        this.preventStatusUpdates = true;
        return ret;
    }

    public boolean isPreventingStatusUpdates() {
        return this.preventStatusUpdates;
    }

    public void stopPreventingStatusUpdates(boolean prev) {
        this.preventStatusUpdates = prev;
    }

    public void updateStatus(class_3194 status, EntityLookup lookup) {
        this.status = status;
        class_1297[] entities = this.entities.getRawData();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            class_1297 entity = entities[i];
            class_5584 oldVisibility = EntityLookup.getEntityStatus(entity);
            ((ChunkSystemEntity)entity).moonrise$setChunkStatus(status);
            class_5584 newVisibility = EntityLookup.getEntityStatus(entity);
            lookup.entityStatusChange(entity, this, oldVisibility, newVisibility, false, false, false);
        }
    }

    public boolean addEntity(class_1297 entity, int chunkSection) {
        if (!this.entities.add(entity)) {
            return false;
        }
        ((ChunkSystemEntity)entity).moonrise$setChunkStatus(this.status);
        ((ChunkSystemEntity)entity).moonrise$setChunkData(this.chunkData);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.addEntity(entity, sectionIndex);
        if (((ChunkSystemEntity)entity).moonrise$isHardColliding()) {
            this.hardCollidingEntities.addEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).addEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get((Object)entity.method_5864());
        if (byType != null) {
            byType.addEntity(entity, sectionIndex);
        } else {
            byType = new EntityCollectionBySection(this);
            this.entitiesByType.put((Object)entity.method_5864(), (Object)byType);
            byType.addEntity(entity, sectionIndex);
        }
        return true;
    }

    public boolean removeEntity(class_1297 entity, int chunkSection) {
        if (!this.entities.remove(entity)) {
            return false;
        }
        ((ChunkSystemEntity)entity).moonrise$setChunkStatus(null);
        ((ChunkSystemEntity)entity).moonrise$setChunkData(null);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.removeEntity(entity, sectionIndex);
        if (((ChunkSystemEntity)entity).moonrise$isHardColliding()) {
            this.hardCollidingEntities.removeEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).removeEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get((Object)entity.method_5864());
        byType.removeEntity(entity, sectionIndex);
        return true;
    }

    public void getHardCollidingEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate) {
        this.hardCollidingEntities.getEntities(except, box, into, predicate);
    }

    public void getEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate) {
        this.allEntities.getEntities(except, box, into, predicate);
    }

    public boolean getEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate, int maxCount) {
        return this.allEntities.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    public <T extends class_1297> void getEntities(class_1299<?> type, class_238 box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            byType.getEntities(null, box, into, predicate);
        }
    }

    public <T extends class_1297> boolean getEntities(class_1299<?> type, class_238 box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            return byType.getEntitiesLimited(null, box, into, predicate, maxCount);
        }
        return false;
    }

    protected EntityCollectionBySection initClass(Class<? extends class_1297> clazz) {
        EntityCollectionBySection ret = new EntityCollectionBySection(this);
        for (int sectionIndex = 0; sectionIndex < this.allEntities.entitiesBySection.length; ++sectionIndex) {
            BasicEntityList<class_1297> sectionEntities = this.allEntities.entitiesBySection[sectionIndex];
            if (sectionEntities == null) continue;
            E[] storage = sectionEntities.storage;
            int len = Math.min(storage.length, sectionEntities.size());
            for (int i = 0; i < len; ++i) {
                Object entity = storage[i];
                if (!clazz.isInstance(entity)) continue;
                ret.addEntity((class_1297)entity, sectionIndex);
            }
        }
        return ret;
    }

    public <T extends class_1297> void getEntities(Class<? extends T> clazz, class_1297 except, class_238 box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            collection.getEntities(except, box, into, predicate);
        } else {
            collection = this.initClass(clazz);
            this.entitiesByClass.put(clazz, (Object)collection);
            collection.getEntities(except, box, into, predicate);
        }
    }

    public <T extends class_1297> boolean getEntities(Class<? extends T> clazz, class_1297 except, class_238 box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
        }
        collection = this.initClass(clazz);
        this.entitiesByClass.put(clazz, (Object)collection);
        return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    private static final class EntityCollectionBySection {
        private final ChunkEntitySlices slices;
        private final BasicEntityList<class_1297>[] entitiesBySection;
        private int count;

        public EntityCollectionBySection(ChunkEntitySlices slices) {
            this.slices = slices;
            int sectionCount = slices.maxSection - slices.minSection + 1;
            this.entitiesBySection = new BasicEntityList[sectionCount];
        }

        public void addEntity(class_1297 entity, int sectionIndex) {
            BasicEntityList<Object> list = this.entitiesBySection[sectionIndex];
            if (list != null && list.has(entity)) {
                return;
            }
            if (list == null) {
                this.entitiesBySection[sectionIndex] = list = new BasicEntityList();
            }
            list.add(entity);
            ++this.count;
        }

        public void removeEntity(class_1297 entity, int sectionIndex) {
            BasicEntityList<class_1297> list = this.entitiesBySection[sectionIndex];
            if (list == null || !list.remove(entity)) {
                return;
            }
            --this.count;
            if (list.isEmpty()) {
                this.entitiesBySection[sectionIndex] = null;
            }
        }

        public void getEntities(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = class_3532.method_15340((int)(class_3532.method_15357((double)(box.field_1322 - 2.0)) >> 4), (int)minSection, (int)maxSection);
            int max = class_3532.method_15340((int)(class_3532.method_15357((double)(box.field_1325 + 2.0)) >> 4), (int)minSection, (int)maxSection);
            BasicEntityList<class_1297>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<class_1297> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i = 0; i < len; ++i) {
                    Object entity = storage[i];
                    if (entity == null || entity == except || !entity.method_5829().method_994(box) || predicate != null && !predicate.test((class_1297)entity)) continue;
                    into.add((class_1297)entity);
                }
            }
        }

        public boolean getEntitiesLimited(class_1297 except, class_238 box, List<class_1297> into, Predicate<? super class_1297> predicate, int maxCount) {
            if (this.count == 0) {
                return false;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = class_3532.method_15340((int)(class_3532.method_15357((double)(box.field_1322 - 2.0)) >> 4), (int)minSection, (int)maxSection);
            int max = class_3532.method_15340((int)(class_3532.method_15357((double)(box.field_1325 + 2.0)) >> 4), (int)minSection, (int)maxSection);
            BasicEntityList<class_1297>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<class_1297> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i = 0; i < len; ++i) {
                    Object entity = storage[i];
                    if (entity == null || entity == except || !entity.method_5829().method_994(box) || predicate != null && !predicate.test((class_1297)entity)) continue;
                    into.add((class_1297)entity);
                    if (into.size() < maxCount) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BasicEntityList<E extends class_1297> {
        private static final class_1297[] EMPTY = new class_1297[0];
        private static final int DEFAULT_CAPACITY = 4;
        private E[] storage;
        private int size;

        public BasicEntityList() {
            this(0);
        }

        public BasicEntityList(int cap) {
            this.storage = cap <= 0 ? EMPTY : new class_1297[cap];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        private void resize() {
            this.storage = this.storage == EMPTY ? new class_1297[4] : (class_1297[])Arrays.copyOf(this.storage, this.storage.length * 2);
        }

        public void add(E entity) {
            int idx;
            if ((idx = this.size++) >= this.storage.length) {
                this.resize();
                this.storage[idx] = entity;
            } else {
                this.storage[idx] = entity;
            }
        }

        public int indexOf(E entity) {
            E[] storage = this.storage;
            int len = Math.min(this.storage.length, this.size);
            for (int i = 0; i < len; ++i) {
                if (storage[i] != entity) continue;
                return i;
            }
            return -1;
        }

        public boolean remove(E entity) {
            int idx = this.indexOf(entity);
            if (idx == -1) {
                return false;
            }
            int size = --this.size;
            E[] storage = this.storage;
            if (idx != size) {
                System.arraycopy(storage, idx + 1, storage, idx, size - idx);
            }
            storage[size] = null;
            return true;
        }

        public boolean has(E entity) {
            return this.indexOf(entity) != -1;
        }
    }
}

