/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5576;

public final class ServerEntityLookup
extends EntityLookup {
    private static final class_1297[] EMPTY_ENTITY_ARRAY = new class_1297[0];
    private final class_3218 serverWorld;
    public final ReferenceList<class_1297> trackerEntities = new ReferenceList<class_1297>(EMPTY_ENTITY_ARRAY);
    private static final class_3230 ENDER_PEARL_TICKER = ChunkSystemTicketType.create("chunk_system:ender_pearl_ticker", null, 0L, 14);
    private final Long2IntOpenHashMap enderPearlChunkCount = new Long2IntOpenHashMap();
    private final boolean keepEnderPearlsTicking;

    public ServerEntityLookup(class_3218 world, class_5576<class_1297> worldCallback) {
        super((class_1937)world, worldCallback);
        this.serverWorld = world;
        this.keepEnderPearlsTicking = PlatformHooks.get().addTicketForEnderPearls(world);
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.blockTicketUpdates();
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
        ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.unblockTicketUpdates(value);
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
        TickThread.ensureTickThread((class_1937)this.serverWorld, chunkX, chunkZ, reason);
    }

    @Override
    protected void checkThread(class_1297 entity, String reason) {
        TickThread.ensureTickThread(entity, reason);
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        return ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(chunkX, chunkZ, transientChunk);
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
    }

    @Override
    protected void entitySectionChangeCallback(class_1297 entity, int oldSectionX, int oldSectionY, int oldSectionZ, int newSectionX, int newSectionY, int newSectionZ) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().tickPlayer(player);
        }
        if (entity instanceof class_1684) {
            class_1684 enderpearl = (class_1684)entity;
            if (oldSectionX != newSectionX || oldSectionZ != newSectionZ) {
                this.removeEnderPearl(CoordinateUtils.getChunkKey(oldSectionX, oldSectionZ));
                this.addEnderPearl(CoordinateUtils.getChunkKey(newSectionX, newSectionZ));
            }
        }
        PlatformHooks.get().entityMove(entity, CoordinateUtils.getChunkSectionKey(oldSectionX, oldSectionY, oldSectionZ), CoordinateUtils.getChunkSectionKey(newSectionX, newSectionY, newSectionZ));
    }

    @Override
    protected void addEntityCallback(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().addPlayer(player);
        }
        if (entity instanceof class_1684) {
            class_1684 enderpearl = (class_1684)entity;
            this.addEnderPearl(CoordinateUtils.getChunkKey(enderpearl.method_31476()));
        }
    }

    @Override
    protected void removeEntityCallback(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ((ChunkSystemServerLevel)this.serverWorld).moonrise$getNearbyPlayers().removePlayer(player);
        }
        if (entity instanceof class_1684) {
            class_1684 enderpearl = (class_1684)entity;
            this.removeEnderPearl(CoordinateUtils.getChunkKey(enderpearl.method_31476()));
        }
    }

    @Override
    protected void entityStartLoaded(class_1297 entity) {
        this.trackerEntities.add(entity);
    }

    @Override
    protected void entityEndLoaded(class_1297 entity) {
        this.trackerEntities.remove(entity);
    }

    @Override
    protected void entityStartTicking(class_1297 entity) {
    }

    @Override
    protected void entityEndTicking(class_1297 entity) {
    }

    @Override
    protected boolean screenEntity(class_1297 entity, boolean fromDisk, boolean event) {
        return PlatformHooks.get().screenEntity(this.serverWorld, entity, fromDisk, event);
    }

    private void addEnderPearl(long coordinate) {
        if (!this.keepEnderPearlsTicking) {
            return;
        }
        int oldCount = this.enderPearlChunkCount.addTo(coordinate, 1);
        if (oldCount != 0) {
            return;
        }
        ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.addTicketAtLevel(ENDER_PEARL_TICKER, coordinate, 31, null);
    }

    private void removeEnderPearl(long coordinate) {
        if (!this.keepEnderPearlsTicking) {
            return;
        }
        int oldCount = this.enderPearlChunkCount.addTo(coordinate, -1);
        if (oldCount != 1) {
            return;
        }
        this.enderPearlChunkCount.remove(coordinate);
        ((ChunkSystemServerLevel)this.serverWorld).moonrise$getChunkTaskScheduler().chunkHolderManager.removeTicketAtLevel(ENDER_PEARL_TICKER, coordinate, 31, null);
    }
}

