/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.queue.AreaDependentQueue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.queue.PrioritisedTaskQueue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.thread.BalancedPrioritisedThreadPool;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkStatus;
import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkFullTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkLightTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkLoadTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkUpgradeGenericStatusTask;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import ca.spottedleaf.moonrise.patches.chunk_system.status.ChunkSystemChunkStep;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import ca.spottedleaf.moonrise.patches.chunk_system.util.ParallelSearchRadiusIteration;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import net.minecraft.class_8563;
import net.minecraft.class_9761;
import net.minecraft.class_9762;
import net.minecraft.class_9768;
import net.minecraft.class_9770;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkTaskScheduler.class);
    public static final class_3230 CHUNK_LOAD = ChunkSystemTicketType.create("chunk_system:chunk_load", Long::compareTo);
    private static final AtomicLong CHUNK_LOAD_IDS = new AtomicLong();
    public static final class_3230 NON_FULL_CHUNK_LOAD = ChunkSystemTicketType.create("chunk_system:non_full_load", Long::compareTo);
    private static final AtomicLong NON_FULL_CHUNK_LOAD_IDS = new AtomicLong();
    public static final class_3230 ENTITY_LOAD = ChunkSystemTicketType.create("chunk_system:entity_load", Long::compareTo);
    private static final AtomicLong ENTITY_LOAD_IDS = new AtomicLong();
    public static final class_3230 POI_LOAD = ChunkSystemTicketType.create("chunk_system:poi_load", Long::compareTo);
    private static final AtomicLong POI_LOAD_IDS = new AtomicLong();
    public static final class_3230 CHUNK_RELIGHT = ChunkSystemTicketType.create("starlight:chunk_relight", Long::compareTo);
    private static final AtomicLong CHUNK_RELIGHT_IDS = new AtomicLong();
    public final class_3218 world;
    public final AreaDependentQueue radiusAwareScheduler;
    public final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue parallelGenExecutor;
    public final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue loadExecutor;
    public final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue ioExecutor;
    public final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue compressionExecutor;
    public final BalancedPrioritisedThreadPool.OrderedStreamGroup.Queue saveExecutor;
    private final PrioritisedTaskQueue mainThreadExecutor = new PrioritisedTaskQueue();
    public final ChunkHolderManager chunkHolderManager;
    private static final int[] ACCESS_RADIUS_TABLE_LOAD;
    private static final int[] ACCESS_RADIUS_TABLE_GEN;
    private static final int[] ACCESS_RADIUS_TABLE;
    private static final int MAX_ACCESS_RADIUS;
    public final ReentrantAreaLock schedulingLockArea;
    private final int lockShift;
    private volatile boolean shutdown;
    private final AtomicBoolean failedChunkSystem = new AtomicBoolean();
    public static final ArrayDeque<ChunkInfo> WAITING_CHUNKS;

    public static Long getNextChunkLoadId() {
        return CHUNK_LOAD_IDS.getAndIncrement();
    }

    public static Long getNextNonFullLoadId() {
        return NON_FULL_CHUNK_LOAD_IDS.getAndIncrement();
    }

    public static Long getNextEntityLoadId() {
        return ENTITY_LOAD_IDS.getAndIncrement();
    }

    public static Long getNextPoiLoadId() {
        return POI_LOAD_IDS.getAndIncrement();
    }

    public static Long getNextChunkRelightId() {
        return CHUNK_RELIGHT_IDS.getAndIncrement();
    }

    public static int getTicketLevel(class_2806 status) {
        return class_8563.method_51829((class_2806)status);
    }

    private static int getAccessRadius0(class_2806 toStatus, class_9768 pyramid) {
        int radius;
        if (toStatus == class_2806.field_12798) {
            return 0;
        }
        class_9770 chunkStep = pyramid.method_60518(toStatus);
        int maxRange = radius = chunkStep.method_60559(class_2806.field_12798);
        for (int dist = 0; dist <= radius; ++dist) {
            class_2806 requiredNeighbourStatus = ((ChunkSystemChunkStep)chunkStep).moonrise$getRequiredStatusAtRadius(dist);
            int rad = ACCESS_RADIUS_TABLE[requiredNeighbourStatus.method_16559()];
            if (rad == -1) {
                throw new IllegalStateException();
            }
            maxRange = Math.max(maxRange, dist + rad);
        }
        return maxRange;
    }

    public static int getMaxAccessRadius() {
        return MAX_ACCESS_RADIUS;
    }

    public static int getAccessRadius(class_2806 genStatus) {
        return ACCESS_RADIUS_TABLE[genStatus.method_16559()];
    }

    public static int getAccessRadius(class_3194 status) {
        return status.ordinal() - 1 + ChunkTaskScheduler.getAccessRadius(class_2806.field_12803);
    }

    public final int getChunkSystemLockShift() {
        return this.lockShift;
    }

    public boolean hasShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public ChunkTaskScheduler(class_3218 world) {
        this.world = world;
        this.lockShift = Math.max(((ChunkSystemServerLevel)world).moonrise$getRegionChunkShift(), 6);
        this.schedulingLockArea = new ReentrantAreaLock(this.getChunkSystemLockShift());
        this.parallelGenExecutor = MoonriseCommon.SERVER_GROUP.createExecutor();
        this.loadExecutor = MoonriseCommon.SERVER_GROUP.createExecutor();
        this.radiusAwareScheduler = new AreaDependentQueue(this.parallelGenExecutor, 4);
        this.ioExecutor = MoonriseCommon.SERVER_IO_GROUP.createExecutor();
        this.compressionExecutor = MoonriseCommon.SERVER_GROUP.createExecutor();
        this.saveExecutor = MoonriseCommon.SERVER_GROUP.createExecutor();
        this.chunkHolderManager = new ChunkHolderManager(world, this);
    }

    public static Object stringIfNull(Object obj) {
        return obj == null ? "null" : obj;
    }

    public void unrecoverableChunkSystemFailure(int chunkX, int chunkZ, Map<String, Object> objectsOfInterest, Throwable thr) {
        NewChunkHolder holder = this.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        LOGGER.error("Chunk system error at chunk (" + chunkX + "," + chunkZ + "), holder: " + String.valueOf(holder) + ", exception:", new Throwable(thr));
        if (this.failedChunkSystem.getAndSet(true)) {
            return;
        }
        class_148 reportedException = thr instanceof class_148 ? (class_148)thr : new class_148(new class_128("Chunk system error", thr));
        class_129 crashReportCategory = reportedException.method_631().method_562("Chunk system details");
        crashReportCategory.method_578("Chunk coordinate", (Object)new class_1923(chunkX, chunkZ).toString());
        crashReportCategory.method_578("ChunkHolder", (Object)Objects.toString(holder));
        crashReportCategory.method_578("unrecoverableChunkSystemFailure caller thread", (Object)Thread.currentThread().getName());
        crashReportCategory = reportedException.method_631().method_562("Chunk System Objects of Interest");
        for (Map.Entry<String, Object> entry : objectsOfInterest.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Throwable) {
                Throwable thrObject = (Throwable)object;
                crashReportCategory.method_585(Objects.toString(entry.getKey()), thrObject);
                continue;
            }
            crashReportCategory.method_578(Objects.toString(entry.getKey()), (Object)Objects.toString(entry.getValue()));
        }
        Runnable crash = () -> {
            throw new RuntimeException("Chunk system crash propagated from unrecoverableChunkSystemFailure", (Throwable)reportedException);
        };
        this.scheduleChunkTask(chunkX, chunkZ, crash, Priority.BLOCKING);
        ((ChunkSystemMinecraftServer)this.world.method_8503()).moonrise$setChunkSystemCrash(new RuntimeException("Chunk system crash propagated from unrecoverableChunkSystemFailure", (Throwable)reportedException));
    }

    public boolean executeMainThreadTask() {
        TickThread.ensureTickThread("Cannot execute main thread task off-main");
        return this.mainThreadExecutor.executeTask();
    }

    public void executeAllRecentlyQueuedMainThreadTasks() {
        long executed = this.mainThreadExecutor.getTotalTasksExecuted();
        long scheduled = this.mainThreadExecutor.getTotalTasksScheduled();
        long left = scheduled - executed;
        for (long i = 0L; i < left && this.mainThreadExecutor.executeTask(); ++i) {
        }
    }

    public void raisePriority(int x, int z, Priority priority) {
        this.chunkHolderManager.raisePriority(x, z, priority);
    }

    public void setPriority(int x, int z, Priority priority) {
        this.chunkHolderManager.setPriority(x, z, priority);
    }

    public void lowerPriority(int x, int z, Priority priority) {
        this.chunkHolderManager.lowerPriority(x, z, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTickingState(int chunkX, int chunkZ, class_3194 toStatus, boolean addTicket, Priority priority, Consumer<class_2818> onComplete) {
        class_2818 chunk2;
        boolean scheduled;
        int radius = toStatus.ordinal() - 1;
        if (!TickThread.isTickThreadFor((class_1937)this.world, chunkX, chunkZ, Math.max(0, radius))) {
            this.scheduleChunkTask(chunkX, chunkZ, () -> this.scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete), priority);
            return;
        }
        int accessRadius = ChunkTaskScheduler.getAccessRadius(toStatus);
        if (this.chunkHolderManager.ticketLockArea.isHeldByCurrentThread(chunkX, chunkZ, accessRadius)) {
            throw new IllegalStateException("Cannot schedule chunk load during ticket level update");
        }
        if (this.schedulingLockArea.isHeldByCurrentThread(chunkX, chunkZ, accessRadius)) {
            throw new IllegalStateException("Cannot schedule chunk loading recursively");
        }
        if (toStatus == class_3194.field_19334) {
            throw new IllegalArgumentException("Cannot wait for INACCESSIBLE status");
        }
        int minLevel = 33 - (toStatus.ordinal() - 1);
        Long chunkReference = addTicket ? ChunkTaskScheduler.getNextChunkLoadId() : null;
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (addTicket) {
            this.chunkHolderManager.addTicketAtLevel(CHUNK_LOAD, chunkKey, minLevel, chunkReference);
            this.chunkHolderManager.processTicketUpdates();
        }
        Consumer<class_2818> loadCallback = onComplete == null && !addTicket ? null : chunk -> {
            try {
                if (onComplete != null) {
                    onComplete.accept((class_2818)chunk);
                }
            }
            finally {
                if (addTicket) {
                    this.chunkHolderManager.removeTicketAtLevel(CHUNK_LOAD, chunkKey, minLevel, chunkReference);
                }
            }
        };
        ReentrantAreaLock.Node ticketLock = this.chunkHolderManager.ticketLockArea.lock(chunkX, chunkZ, accessRadius);
        try {
            ReentrantAreaLock.Node schedulingLock = this.schedulingLockArea.lock(chunkX, chunkZ, accessRadius);
            try {
                NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkKey);
                if (chunkHolder == null || chunkHolder.getTicketLevel() > minLevel) {
                    scheduled = false;
                    chunk2 = null;
                } else {
                    class_3194 currStatus = chunkHolder.getChunkStatus();
                    if (currStatus.method_14014(toStatus)) {
                        scheduled = false;
                        chunk2 = (class_2818)chunkHolder.getCurrentChunk();
                    } else {
                        scheduled = true;
                        chunk2 = null;
                        for (int dz = -radius; dz <= radius; ++dz) {
                            for (int dx = -radius; dx <= radius; ++dx) {
                                NewChunkHolder neighbour;
                                NewChunkHolder newChunkHolder = neighbour = (dx | dz) == 0 ? chunkHolder : this.chunkHolderManager.getChunkHolder(dx + chunkX, dz + chunkZ);
                                if (neighbour == null) continue;
                                neighbour.raisePriority(priority);
                            }
                        }
                        if (loadCallback != null) {
                            chunkHolder.addFullStatusConsumer(toStatus, loadCallback);
                        }
                    }
                }
            }
            finally {
                this.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.chunkHolderManager.ticketLockArea.unlock(ticketLock);
        }
        if (loadCallback != null && !scheduled) {
            try {
                loadCallback.accept(chunk2);
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to process chunk full status callback", thr);
            }
        }
    }

    public void scheduleChunkLoad(int chunkX, int chunkZ, boolean gen, class_2806 toStatus, boolean addTicket, Priority priority, Consumer<class_2791> onComplete) {
        if (gen) {
            this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
            return;
        }
        this.scheduleChunkLoad(chunkX, chunkZ, class_2806.field_12798, addTicket, priority, chunk -> {
            if (chunk == null) {
                if (onComplete != null) {
                    onComplete.accept(null);
                }
            } else if (chunk.method_12009().method_12165(toStatus)) {
                this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
            } else if (onComplete != null) {
                onComplete.accept(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean beginChunkLoadForNonFullSync(int chunkX, int chunkZ, class_2806 toStatus, Priority priority) {
        int accessRadius = ChunkTaskScheduler.getAccessRadius(toStatus);
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int minLevel = ChunkTaskScheduler.getTicketLevel(toStatus);
        ArrayList<ChunkProgressionTask> tasks = new ArrayList<ChunkProgressionTask>();
        ReentrantAreaLock.Node ticketLock = this.chunkHolderManager.ticketLockArea.lock(chunkX, chunkZ, accessRadius);
        try {
            ReentrantAreaLock.Node schedulingLock = this.schedulingLockArea.lock(chunkX, chunkZ, accessRadius);
            try {
                NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkKey);
                if (chunkHolder == null || chunkHolder.getTicketLevel() > minLevel) {
                    boolean bl = false;
                    return bl;
                }
                class_2806 genStatus = chunkHolder.getCurrentGenStatus();
                if (genStatus != null && genStatus.method_12165(toStatus)) {
                    boolean bl = true;
                    return bl;
                }
                chunkHolder.raisePriority(priority);
                if (!chunkHolder.upgradeGenTarget(toStatus)) {
                    this.schedule(chunkX, chunkZ, toStatus, chunkHolder, tasks);
                }
            }
            finally {
                this.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.chunkHolderManager.ticketLockArea.unlock(ticketLock);
        }
        int i = 0;
        int len = tasks.size();
        while (i < len) {
            ((ChunkProgressionTask)tasks.get(i)).schedule();
            ++i;
        }
        return true;
    }

    public class_2791 syncLoadNonFull(int chunkX, int chunkZ, class_2806 status) {
        if (status == null || status.method_12165(class_2806.field_12803)) {
            throw new IllegalArgumentException("Status: " + String.valueOf(status));
        }
        if (!TickThread.isTickThread()) {
            return this.world.method_14178().method_12121(chunkX, chunkZ, status, true);
        }
        class_2791 loaded = ((ChunkSystemServerLevel)this.world).moonrise$getSpecificChunkIfLoaded(chunkX, chunkZ, status);
        if (loaded != null) {
            return loaded;
        }
        if (this.hasShutdown()) {
            throw new IllegalStateException("Chunk system has shut down, cannot process chunk requests in world '" + WorldUtil.getWorldName((class_1937)this.world) + "' at (" + chunkX + "," + chunkZ + ") status: " + String.valueOf(status));
        }
        Long ticketId = ChunkTaskScheduler.getNextNonFullLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(status);
        this.chunkHolderManager.addTicketAtLevel(NON_FULL_CHUNK_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        this.chunkHolderManager.processTicketUpdates();
        this.beginChunkLoadForNonFullSync(chunkX, chunkZ, status, Priority.BLOCKING);
        this.world.method_14178().field_18809.method_18857(() -> ((ChunkSystemServerLevel)this.world).moonrise$getSpecificChunkIfLoaded(chunkX, chunkZ, status) != null);
        loaded = ((ChunkSystemServerLevel)this.world).moonrise$getSpecificChunkIfLoaded(chunkX, chunkZ, status);
        this.chunkHolderManager.removeTicketAtLevel(NON_FULL_CHUNK_LOAD, chunkX, chunkZ, ticketLevel, ticketId);
        if (loaded == null) {
            throw new IllegalStateException("Expected chunk to be loaded for status " + String.valueOf(status));
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleChunkLoad(int chunkX, int chunkZ, class_2806 toStatus, boolean addTicket, Priority priority, Consumer<class_2791> onComplete) {
        class_2791 chunk2;
        boolean scheduled;
        if (!TickThread.isTickThreadFor((class_1937)this.world, chunkX, chunkZ)) {
            this.scheduleChunkTask(chunkX, chunkZ, () -> this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete), priority);
            return;
        }
        int accessRadius = ChunkTaskScheduler.getAccessRadius(toStatus);
        if (this.chunkHolderManager.ticketLockArea.isHeldByCurrentThread(chunkX, chunkZ, accessRadius)) {
            throw new IllegalStateException("Cannot schedule chunk load during ticket level update");
        }
        if (this.schedulingLockArea.isHeldByCurrentThread(chunkX, chunkZ, accessRadius)) {
            throw new IllegalStateException("Cannot schedule chunk loading recursively");
        }
        if (toStatus == class_2806.field_12803) {
            this.scheduleTickingState(chunkX, chunkZ, class_3194.field_44855, addTicket, priority, onComplete);
            return;
        }
        int minLevel = ChunkTaskScheduler.getTicketLevel(toStatus);
        Long chunkReference = addTicket ? ChunkTaskScheduler.getNextChunkLoadId() : null;
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (addTicket) {
            this.chunkHolderManager.addTicketAtLevel(CHUNK_LOAD, chunkKey, minLevel, chunkReference);
            this.chunkHolderManager.processTicketUpdates();
        }
        Consumer<class_2791> loadCallback = onComplete == null && !addTicket ? null : chunk -> {
            try {
                if (onComplete != null) {
                    onComplete.accept((class_2791)chunk);
                }
            }
            finally {
                if (addTicket) {
                    this.chunkHolderManager.removeTicketAtLevel(CHUNK_LOAD, chunkKey, minLevel, chunkReference);
                }
            }
        };
        ArrayList<ChunkProgressionTask> tasks = new ArrayList<ChunkProgressionTask>();
        ReentrantAreaLock.Node ticketLock = this.chunkHolderManager.ticketLockArea.lock(chunkX, chunkZ, accessRadius);
        try {
            ReentrantAreaLock.Node schedulingLock = this.schedulingLockArea.lock(chunkX, chunkZ, accessRadius);
            try {
                NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkKey);
                if (chunkHolder == null || chunkHolder.getTicketLevel() > minLevel) {
                    scheduled = false;
                    chunk2 = null;
                } else {
                    class_2806 genStatus = chunkHolder.getCurrentGenStatus();
                    if (genStatus != null && genStatus.method_12165(toStatus)) {
                        scheduled = false;
                        chunk2 = chunkHolder.getCurrentChunk();
                    } else {
                        scheduled = true;
                        chunk2 = null;
                        chunkHolder.raisePriority(priority);
                        if (!chunkHolder.upgradeGenTarget(toStatus)) {
                            this.schedule(chunkX, chunkZ, toStatus, chunkHolder, tasks);
                        }
                        if (loadCallback != null) {
                            chunkHolder.addStatusConsumer(toStatus, loadCallback);
                        }
                    }
                }
            }
            finally {
                this.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.chunkHolderManager.ticketLockArea.unlock(ticketLock);
        }
        int len = tasks.size();
        for (int i = 0; i < len; ++i) {
            ((ChunkProgressionTask)tasks.get(i)).schedule();
        }
        if (loadCallback != null && !scheduled) {
            try {
                loadCallback.accept(chunk2);
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to process chunk status callback", thr);
            }
        }
    }

    private ChunkProgressionTask createTask(int chunkX, int chunkZ, class_2791 chunk, NewChunkHolder chunkHolder, class_9762<class_9761> neighbours, class_2806 toStatus, Priority initialPriority) {
        if (toStatus == class_2806.field_12798) {
            return new ChunkLoadTask(this, this.world, chunkX, chunkZ, chunkHolder, initialPriority);
        }
        if (toStatus == class_2806.field_12805) {
            return new ChunkLightTask(this, this.world, chunkX, chunkZ, chunk, initialPriority);
        }
        if (toStatus == class_2806.field_12803) {
            return new ChunkFullTask(this, this.world, chunkX, chunkZ, chunkHolder, chunk, initialPriority);
        }
        return new ChunkUpgradeGenericStatusTask(this, this.world, chunkX, chunkZ, chunk, neighbours, toStatus, initialPriority);
    }

    ChunkProgressionTask schedule(int chunkX, int chunkZ, class_2806 targetStatus, NewChunkHolder chunkHolder, List<ChunkProgressionTask> allTasks) {
        return this.schedule(chunkX, chunkZ, targetStatus, chunkHolder, allTasks, chunkHolder.getEffectivePriority(Priority.NORMAL));
    }

    private ChunkProgressionTask schedule(int chunkX, int chunkZ, class_2806 targetStatus, NewChunkHolder chunkHolder, List<ChunkProgressionTask> allTasks, Priority minPriority) {
        if (!this.schedulingLockArea.isHeldByCurrentThread(chunkX, chunkZ, ChunkTaskScheduler.getAccessRadius(targetStatus))) {
            throw new IllegalStateException("Not holding scheduling lock");
        }
        if (chunkHolder.hasGenerationTask()) {
            chunkHolder.upgradeGenTarget(targetStatus);
            return null;
        }
        Priority requestedPriority = Priority.max(minPriority, chunkHolder.getEffectivePriority(Priority.NORMAL));
        class_2806 currentGenStatus = chunkHolder.getCurrentGenStatus();
        class_2791 chunk = chunkHolder.getCurrentChunk();
        if (currentGenStatus == null) {
            ChunkProgressionTask task = this.createTask(chunkX, chunkZ, chunk, chunkHolder, null, class_2806.field_12798, requestedPriority);
            allTasks.add(task);
            ArrayList<NewChunkHolder> chunkHolderNeighbours = new ArrayList<NewChunkHolder>(1);
            chunkHolderNeighbours.add(chunkHolder);
            chunkHolder.setGenerationTarget(targetStatus);
            chunkHolder.setGenerationTask(task, class_2806.field_12798, chunkHolderNeighbours);
            return task;
        }
        if (currentGenStatus.method_12165(targetStatus)) {
            return null;
        }
        chunkHolder.setGenerationTarget(targetStatus);
        class_2806 chunkRealStatus = chunk.method_12009();
        class_2806 toStatus = ((ChunkSystemChunkStatus)currentGenStatus).moonrise$getNextStatus();
        class_9768 chunkPyramid = chunkRealStatus.method_12165(toStatus) ? class_9768.field_51901 : class_9768.field_51900;
        class_9770 chunkStep = chunkPyramid.method_60518(toStatus);
        int neighbourReadRadius = Math.max(0, chunkStep.method_60559(class_2806.field_12798));
        boolean unGeneratedNeighbours = false;
        if (neighbourReadRadius > 0) {
            class_3898 chunkMap = this.world.method_14178().field_17254;
            for (long pos : ParallelSearchRadiusIteration.getSearchIteration(neighbourReadRadius)) {
                int x = CoordinateUtils.getChunkX(pos);
                int z = CoordinateUtils.getChunkZ(pos);
                int radius = Math.max(Math.abs(x), Math.abs(z));
                class_2806 requiredNeighbourStatus = ((ChunkSystemChunkStep)chunkStep).moonrise$getRequiredStatusAtRadius(radius);
                unGeneratedNeighbours |= this.checkNeighbour(chunkX + x, chunkZ + z, requiredNeighbourStatus, chunkHolder, allTasks, requestedPriority);
            }
        }
        if (unGeneratedNeighbours) {
            chunkHolder.recalculateNeighbourPriorities();
            return null;
        }
        ArrayList<NewChunkHolder> chunkHolderNeighbours = new ArrayList<NewChunkHolder>((2 * neighbourReadRadius + 1) * (2 * neighbourReadRadius + 1));
        class_9762 neighbours = class_9762.method_60483((int)chunkX, (int)chunkZ, (int)neighbourReadRadius, (nx, nz) -> {
            NewChunkHolder holder = nx == chunkX && nz == chunkZ ? chunkHolder : this.chunkHolderManager.getChunkHolder(nx, nz);
            chunkHolderNeighbours.add(holder);
            return holder.vanillaChunkHolder;
        });
        ChunkProgressionTask task = this.createTask(chunkX, chunkZ, chunk, chunkHolder, (class_9762<class_9761>)neighbours, toStatus, chunkHolder.getEffectivePriority(Priority.NORMAL));
        allTasks.add(task);
        chunkHolder.setGenerationTask(task, toStatus, chunkHolderNeighbours);
        return task;
    }

    private boolean checkNeighbour(int chunkX, int chunkZ, class_2806 requiredStatus, NewChunkHolder center, List<ChunkProgressionTask> tasks, Priority minPriority) {
        NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (chunkHolder == null) {
            throw new IllegalStateException("Missing chunkholder when required");
        }
        class_2806 holderStatus = chunkHolder.getCurrentGenStatus();
        if (holderStatus != null && holderStatus.method_12165(requiredStatus)) {
            return false;
        }
        if (chunkHolder.hasFailedGeneration()) {
            return true;
        }
        center.addGenerationBlockingNeighbour(chunkHolder);
        chunkHolder.addWaitingNeighbour(center, requiredStatus);
        if (chunkHolder.upgradeGenTarget(requiredStatus)) {
            return true;
        }
        this.schedule(chunkX, chunkZ, requiredStatus, chunkHolder, tasks, minPriority);
        return true;
    }

    @Deprecated
    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(Runnable run) {
        return this.scheduleChunkTask(run, Priority.NORMAL);
    }

    @Deprecated
    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(Runnable run, Priority priority) {
        return this.mainThreadExecutor.queueTask(run, priority);
    }

    public PrioritisedExecutor.PrioritisedTask createChunkTask(int chunkX, int chunkZ, Runnable run) {
        return this.createChunkTask(chunkX, chunkZ, run, Priority.NORMAL);
    }

    public PrioritisedExecutor.PrioritisedTask createChunkTask(int chunkX, int chunkZ, Runnable run, Priority priority) {
        return this.mainThreadExecutor.createTask(run, priority);
    }

    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(int chunkX, int chunkZ, Runnable run) {
        return this.scheduleChunkTask(chunkX, chunkZ, run, Priority.NORMAL);
    }

    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(int chunkX, int chunkZ, Runnable run, Priority priority) {
        return this.mainThreadExecutor.queueTask(run, priority);
    }

    public boolean halt(boolean sync, long maxWaitNS) {
        this.parallelGenExecutor.halt();
        this.loadExecutor.halt();
        if (sync) {
            long time = System.nanoTime();
            long failures = 9L;
            while (true) {
                if (!this.parallelGenExecutor.isActive() && !this.loadExecutor.isActive()) {
                    return true;
                }
                if (System.nanoTime() - time >= maxWaitNS) {
                    return false;
                }
                failures = ConcurrentUtil.linearLongBackoff(failures, 500000L, 50000000L);
            }
        }
        return true;
    }

    public boolean haltIO(boolean sync, long maxWaitNS) {
        this.ioExecutor.halt();
        this.saveExecutor.halt();
        this.compressionExecutor.halt();
        if (sync) {
            long time = System.nanoTime();
            long failures = 9L;
            while (true) {
                if (!(this.ioExecutor.isActive() || this.saveExecutor.isActive() || this.compressionExecutor.isActive())) {
                    return true;
                }
                if (System.nanoTime() - time >= maxWaitNS) {
                    return false;
                }
                failures = ConcurrentUtil.linearLongBackoff(failures, 500000L, 50000000L);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushChunkWait(class_3218 world, int chunkX, int chunkZ) {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.push(new ChunkInfo(chunkX, chunkZ, world));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popChunkWait() {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChunkInfo[] getChunkInfos() {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            return WAITING_CHUNKS.toArray(new ChunkInfo[0]);
        }
    }

    private static JsonObject debugPlayer(class_3222 player) {
        class_3218 world = player.method_51469();
        JsonObject ret = new JsonObject();
        ret.addProperty("name", player.method_5820());
        ret.addProperty("uuid", player.method_5667().toString());
        ret.addProperty("real", Boolean.valueOf(((ChunkSystemServerPlayer)player).moonrise$isRealPlayer()));
        ret.addProperty("world-name", WorldUtil.getWorldName((class_1937)world));
        class_243 pos = player.method_73189();
        ret.addProperty("x", (Number)pos.field_1352);
        ret.addProperty("y", (Number)pos.field_1351);
        ret.addProperty("z", (Number)pos.field_1350);
        class_1297.class_5529 removalReason = player.method_35049();
        ret.addProperty("removal-reason", removalReason == null ? "null" : removalReason.name());
        ret.add("view-distances", (JsonElement)((ChunkSystemServerPlayer)player).moonrise$getViewDistanceHolder().toJson());
        return ret;
    }

    public JsonObject getDebugJson() {
        JsonObject ret = new JsonObject();
        ret.addProperty("lock_shift", (Number)this.getChunkSystemLockShift());
        ret.addProperty("ticket_shift", (Number)6);
        ret.addProperty("region_shift", (Number)((ChunkSystemServerLevel)this.world).moonrise$getRegionChunkShift());
        ret.addProperty("name", WorldUtil.getWorldName((class_1937)this.world));
        ret.addProperty("view-distance", (Number)((ChunkSystemServerLevel)this.world).moonrise$getPlayerChunkLoader().getAPIViewDistance());
        ret.addProperty("tick-distance", (Number)((ChunkSystemServerLevel)this.world).moonrise$getPlayerChunkLoader().getAPITickDistance());
        ret.addProperty("send-distance", (Number)((ChunkSystemServerLevel)this.world).moonrise$getPlayerChunkLoader().getAPISendViewDistance());
        JsonArray players = new JsonArray();
        ret.add("players", (JsonElement)players);
        for (class_3222 player : this.world.method_18456()) {
            players.add((JsonElement)ChunkTaskScheduler.debugPlayer(player));
        }
        ret.add("chunk-holder-manager", (JsonElement)this.chunkHolderManager.getDebugJson());
        return ret;
    }

    public static JsonObject debugAllWorlds(MinecraftServer server) {
        JsonObject ret = new JsonObject();
        ret.addProperty("data-version", (Number)2);
        JsonArray allPlayers = new JsonArray();
        ret.add("all-players", (JsonElement)allPlayers);
        for (ChunkInfo[] player : server.method_3760().method_14571()) {
            allPlayers.add((JsonElement)ChunkTaskScheduler.debugPlayer((class_3222)player));
        }
        JsonArray chunkWaitInfos = new JsonArray();
        ret.add("chunk-wait-infos", (JsonElement)chunkWaitInfos);
        for (ChunkInfo info : ChunkTaskScheduler.getChunkInfos()) {
            chunkWaitInfos.add((JsonElement)info.toJson());
        }
        JsonArray worlds = new JsonArray();
        ret.add("worlds", (JsonElement)worlds);
        for (class_3218 world : server.method_3738()) {
            worlds.add((JsonElement)((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().getDebugJson());
        }
        return ret;
    }

    public static File getChunkDebugFile() {
        return new File(new File(new File("."), "debug"), "chunks-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
    }

    public static void dumpAllChunkLoadInfo(MinecraftServer server, boolean writeDebugInfo) {
        ChunkInfo[] chunkInfos = ChunkTaskScheduler.getChunkInfos();
        if (chunkInfos.length > 0) {
            LOGGER.error("Chunk wait task info below: ");
            for (ChunkInfo chunkInfo : chunkInfos) {
                NewChunkHolder holder = ((ChunkSystemServerLevel)chunkInfo.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkInfo.chunkX, chunkInfo.chunkZ);
                LOGGER.error("Chunk wait: " + String.valueOf(chunkInfo));
                LOGGER.error("Chunk holder: " + String.valueOf(holder));
            }
            if (writeDebugInfo) {
                File file = ChunkTaskScheduler.getChunkDebugFile();
                LOGGER.error("Writing chunk information dump to " + String.valueOf(file));
                try {
                    JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(server), file);
                    LOGGER.error("Successfully written chunk information!");
                }
                catch (Throwable thr) {
                    LOGGER.error("Failed to dump chunk information to file " + file.toString(), thr);
                }
            }
        }
    }

    static {
        ((ChunkSystemChunkStatus)class_2806.field_12798).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_16423).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_16422).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12794).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12804).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12796).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12801).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12795).moonrise$setWriteRadius(1);
        ((ChunkSystemChunkStatus)class_2806.field_44633).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12805).moonrise$setWriteRadius(2);
        ((ChunkSystemChunkStatus)class_2806.field_12786).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12803).moonrise$setWriteRadius(0);
        ((ChunkSystemChunkStatus)class_2806.field_12798).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_16422).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12794).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12804).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12796).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12801).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12795).moonrise$setEmptyLoadStatus(true);
        ((ChunkSystemChunkStatus)class_2806.field_12786).moonrise$setEmptyLoadStatus(true);
        List<class_2806> parallelCapableStatus = Arrays.asList(class_2806.field_12798, class_2806.field_16423, class_2806.field_16422, class_2806.field_12794, class_2806.field_12804, class_2806.field_12796, class_2806.field_12801, class_2806.field_44633);
        for (class_2806 status : parallelCapableStatus) {
            ((ChunkSystemChunkStatus)status).moonrise$setParallelCapable(true);
        }
        ACCESS_RADIUS_TABLE_LOAD = new int[class_2806.method_16558().size()];
        ACCESS_RADIUS_TABLE_GEN = new int[class_2806.method_16558().size()];
        ACCESS_RADIUS_TABLE = new int[class_2806.method_16558().size()];
        Arrays.fill(ACCESS_RADIUS_TABLE_LOAD, -1);
        Arrays.fill(ACCESS_RADIUS_TABLE_GEN, -1);
        Arrays.fill(ACCESS_RADIUS_TABLE, -1);
        List statuses = class_2806.method_16558();
        int len = statuses.size();
        for (int i = 0; i < len; ++i) {
            class_2806 status = (class_2806)statuses.get(i);
            ChunkTaskScheduler.ACCESS_RADIUS_TABLE_LOAD[i] = ChunkTaskScheduler.getAccessRadius0(status, class_9768.field_51901);
            ChunkTaskScheduler.ACCESS_RADIUS_TABLE_GEN[i] = ChunkTaskScheduler.getAccessRadius0(status, class_9768.field_51900);
            ChunkTaskScheduler.ACCESS_RADIUS_TABLE[i] = Math.max(ACCESS_RADIUS_TABLE_LOAD[i], ACCESS_RADIUS_TABLE_GEN[i]);
        }
        MAX_ACCESS_RADIUS = ACCESS_RADIUS_TABLE[ACCESS_RADIUS_TABLE.length - 1];
        WAITING_CHUNKS = new ArrayDeque();
    }

    public static final class ChunkInfo {
        public final int chunkX;
        public final int chunkZ;
        public final class_3218 world;

        public ChunkInfo(int chunkX, int chunkZ, class_3218 world) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.world = world;
        }

        public JsonObject toJson() {
            JsonObject ret = new JsonObject();
            ret.addProperty("chunk-x", (Number)this.chunkX);
            ret.addProperty("chunk-z", (Number)this.chunkZ);
            ret.addProperty("world-name", WorldUtil.getWorldName((class_1937)this.world));
            return ret;
        }

        public String toString() {
            return "[( " + this.chunkX + "," + this.chunkZ + ") in '" + WorldUtil.getWorldName((class_1937)this.world) + "']";
        }
    }
}

