/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;

public abstract class ChunkProgressionTask {
    private final MultiThreadedQueue<BiConsumer<class_2791, Throwable>> waiters = new MultiThreadedQueue();
    private class_2791 completedChunk;
    private Throwable completedThrowable;
    protected final ChunkTaskScheduler scheduler;
    protected final class_3218 world;
    protected final int chunkX;
    protected final int chunkZ;
    protected volatile boolean completed;
    protected static final VarHandle COMPLETED_HANDLE = ConcurrentUtil.getVarHandle(ChunkProgressionTask.class, "completed", Boolean.TYPE);

    protected ChunkProgressionTask(ChunkTaskScheduler scheduler, class_3218 world, int chunkX, int chunkZ) {
        this.scheduler = scheduler;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public abstract boolean isScheduled();

    public abstract class_2806 getTargetStatus();

    public abstract void schedule();

    public abstract void cancel();

    public abstract Priority getPriority();

    public abstract void lowerPriority(Priority var1);

    public abstract void setPriority(Priority var1);

    public abstract void raisePriority(Priority var1);

    public final void onComplete(BiConsumer<class_2791, Throwable> onComplete) {
        if (!this.waiters.add(onComplete)) {
            try {
                onComplete.accept(this.completedChunk, this.completedThrowable);
            }
            catch (Throwable throwable) {
                this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(onComplete), "Completed throwable", ChunkTaskScheduler.stringIfNull(this.completedThrowable)), throwable);
            }
        }
    }

    protected final void complete(class_2791 chunk, Throwable throwable) {
        try {
            this.complete0(chunk, throwable);
        }
        catch (Throwable thr2) {
            this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Completed throwable", ChunkTaskScheduler.stringIfNull(throwable)), thr2);
        }
    }

    private void complete0(class_2791 chunk, Throwable throwable) {
        BiConsumer<class_2791, Throwable> consumer;
        if (COMPLETED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Already completed");
        }
        this.completedChunk = chunk;
        this.completedThrowable = throwable;
        while ((consumer = this.waiters.pollOrBlockAdds()) != null) {
            consumer.accept(chunk, throwable);
        }
    }

    public String toString() {
        return "ChunkProgressionTask{class: " + this.getClass().getName() + ", for world: " + WorldUtil.getWorldName((class_1937)this.world) + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), hashcode: " + System.identityHashCode(this) + ", priority: " + String.valueOf((Object)this.getPriority()) + ", status: " + this.getTargetStatus().toString() + ", scheduled: " + this.isScheduled() + "}";
    }
}

