/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.util.stream;

import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_3228;

public final class TicketSet
extends AbstractSet<class_3228> {
    private class_3228[] tickets;
    private int size;

    public TicketSet(int initialCapacity) {
        this.tickets = new class_3228[initialCapacity];
    }

    private TicketSet(class_3228[] tickets, int size) {
        this.tickets = tickets;
        this.size = size;
    }

    private static int binarySearch(class_3228[] tickets, int start, int end, class_3228 key) {
        Objects.checkFromToIndex(start, end, tickets.length);
        --end;
        while (start <= end) {
            int middle = start + end >>> 1;
            class_3228 ticket = tickets[middle];
            int cmp = ((ChunkSystemTicket)ticket).compareTo(key);
            if (cmp < 0) {
                start = middle + 1;
                continue;
            }
            if (cmp > 0) {
                end = middle - 1;
                continue;
            }
            return middle;
        }
        return ~start;
    }

    private void expand() {
        int newSize = this.tickets.length + (this.tickets.length >> 1);
        if (newSize < 0 && (newSize = Integer.MAX_VALUE) == this.tickets.length) {
            throw new IllegalStateException("Cannot service more than Integer.MAX_VALUE elements!");
        }
        newSize = Math.max(4, newSize);
        this.tickets = Arrays.copyOf(this.tickets, newSize);
    }

    private void checkCapacity(int size) {
        if (size <= this.tickets.length) {
            return;
        }
        this.expand();
    }

    private void addAt(int index, class_3228 ticket) {
        this.checkCapacity(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.tickets, index, this.tickets, index + 1, this.size - index);
        }
        ++this.size;
        this.tickets[index] = ticket;
    }

    private void removeAt(int index) {
        if (index != --this.size) {
            System.arraycopy(this.tickets, index + 1, this.tickets, index, this.size - index);
        }
        this.tickets[this.size] = null;
    }

    public TicketSet copy() {
        int size = this.size;
        return new TicketSet(Arrays.copyOf(this.tickets, size), size);
    }

    public class_3228[] copyBackingArray() {
        return (class_3228[])this.tickets.clone();
    }

    public class_3228 replace(class_3228 object) {
        int index = TicketSet.binarySearch(this.tickets, 0, this.size, object);
        if (index >= 0) {
            class_3228 old = this.tickets[index];
            this.tickets[index] = object;
            return old;
        }
        this.addAt(~index, object);
        return object;
    }

    public class_3228 removeAndGet(class_3228 object) {
        int idx = TicketSet.binarySearch(this.tickets, 0, this.size, object);
        if (idx < 0) {
            return null;
        }
        class_3228 ret = this.tickets[idx];
        this.removeAt(idx);
        return ret;
    }

    public class_3228 first() {
        Objects.checkIndex(0, this.size);
        return this.tickets[0];
    }

    public class_3228 last() {
        Objects.checkIndex(this.size - 1, this.size);
        return this.tickets[this.size - 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean add(class_3228 ticket) {
        int index = TicketSet.binarySearch(this.tickets, 0, this.size, ticket);
        if (index >= 0) {
            return false;
        }
        this.addAt(~index, ticket);
        return true;
    }

    @Override
    public boolean remove(Object value) {
        int idx = TicketSet.binarySearch(this.tickets, 0, this.size, (class_3228)value);
        if (idx < 0) {
            return false;
        }
        this.removeAt(idx);
        return true;
    }

    public int expireAndRemoveInto(class_3228[] array) {
        class_3228 ticket;
        Objects.checkFromIndexSize(0, this.size, array.length);
        int removed = 0;
        int i = 0;
        int len = this.size;
        Object[] tickets = this.tickets;
        do {
            if (i < len) continue;
            return removed;
        } while (!ChunkHolderManager.tickTicket(ticket = tickets[i++]));
        array[removed++] = ticket;
        int lastIndex = i - 1;
        while (i < len) {
            class_3228 curr = tickets[i];
            if (!ChunkHolderManager.tickTicket(curr)) {
                tickets[lastIndex++] = curr;
            } else {
                array[removed++] = curr;
            }
            ++i;
        }
        Arrays.fill(tickets, lastIndex, len, null);
        this.size = lastIndex;
        return removed;
    }

    @Override
    public Iterator<class_3228> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<class_3228> {
        private static final int REMOVED = -1;
        private int index;
        private int lastReturned = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TicketSet.this.size;
        }

        @Override
        public class_3228 next() {
            if (this.index >= TicketSet.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.index++;
            return TicketSet.this.tickets[this.lastReturned];
        }

        @Override
        public void remove() {
            int lastReturned = this.lastReturned;
            if (lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.lastReturned = -1;
            this.index = lastReturned;
            TicketSet.this.removeAt(lastReturned);
        }

        @Override
        public void forEachRemaining(Consumer<? super class_3228> action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept((class_3228)this.next());
            }
        }
    }
}

