/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.render;

import java.util.Arrays;
import net.minecraft.class_2350;
import net.minecraft.class_854;

public final class VisibilityGraph {
    private static final int SECTION_WIDTH = 16;
    private static final int LOG2_SECTION_WIDTH = 4;
    private static final long LOG2_LONG = 6L;
    private static final long[] X_SET_FACES = new long[64];
    private static final int[] DIRECTIONS_BITSET_BY_INDEX = new int[4096];
    private static final int ALL_DIRECTIONS_BITSET = 63;
    private static final int TOTAL_BLOCKS_FACES;
    private static final int[] INDEX_ADD_BY_DIRECTION_ORDINAL;
    private static final int[] OPPOSITE_BITSET_BY_ORIDINAL;
    private static final long BLOCKS_PER_LONG = 4L;
    private static final int BITSET_SIZE = 64;
    private final long[] opaque = new long[64];
    private static final int TOTAL_DIRECTIONS = 6;
    private int opaqueEdgeCount = 0;
    private int[] bfsQueue = new int[256];
    private static final long EXCLUDING_EDGES = 0x7FFE7FFE7FFE7FFEL;
    private static final long EXCLUDING_LEFT_EDGES = -281479271743490L;
    private static final long EXCLUDING_RIGHT_EDGES = 0x7FFF7FFF7FFF7FFFL;

    public void setOpaque(int x, int y, int z) {
        int idx = x | z << 4 | y << 8;
        int bitsetIdx = idx >>> 6;
        long bitsetMask = 1L << idx;
        int n = bitsetIdx;
        this.opaque[n] = this.opaque[n] | bitsetMask;
        this.opaqueEdgeCount += Long.bitCount(X_SET_FACES[bitsetIdx] & bitsetMask);
    }

    public void reset() {
        if ((long)this.opaqueEdgeCount != 0L) {
            Arrays.fill(this.opaque, 0L);
            this.opaqueEdgeCount = 0;
        }
    }

    private static long maskMoveNeighbours(long from, long neighbour) {
        long leftMask = 0xFFFDFFFDFFFDFFFCL & (neighbour ^= 0xFFFFFFFFFFFFFFFFL);
        long rightMask = 0x3FFFBFFFBFFFBFFFL & neighbour;
        long ret = (from ^= 0xFFFFFFFFFFFFFFFFL) & neighbour;
        for (int i = 0; i < 15; ++i) {
            long left = ret << 1 & leftMask;
            long right = ret >>> 1 & rightMask;
            ret = left | right;
        }
        return ret ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private final int[] resizeBFSQueue() {
        this.bfsQueue = Arrays.copyOf(this.bfsQueue, this.bfsQueue.length * 2);
        return this.bfsQueue;
    }

    public class_854 findFaces() {
        class_854 ret = new class_854();
        if (this.opaqueEdgeCount < 256) {
            ret.method_3694(true);
            return ret;
        }
        if (this.opaqueEdgeCount == TOTAL_BLOCKS_FACES) {
            ret.method_3694(false);
            return ret;
        }
        long[] opaque = this.opaque;
        int[] queue = this.bfsQueue;
        for (int faceBitsetIndex = 0; faceBitsetIndex < 64; ++faceBitsetIndex) {
            long value;
            long valueMask;
            long faceMask = X_SET_FACES[faceBitsetIndex];
            while ((valueMask = ((value = opaque[faceBitsetIndex]) ^ 0xFFFFFFFFFFFFFFFFL) & faceMask) != 0L) {
                int setIndex = Long.numberOfTrailingZeros(valueMask);
                opaque[faceBitsetIndex] = value | 1L << setIndex;
                int directionBitset = DIRECTIONS_BITSET_BY_INDEX[setIndex |= faceBitsetIndex << 6];
                int bfsIndex = 0;
                int queued = 1;
                queue[0] = setIndex | directionBitset << 12;
                while (bfsIndex < queued) {
                    int queuedValue = queue[bfsIndex++];
                    int negatedBitset = (~queuedValue & 0x3F000) >>> 12;
                    int queuedIndex = queuedValue & 0xFFF;
                    int len = Integer.bitCount(negatedBitset);
                    for (int i = 0; i < len; ++i) {
                        int directionOrdinal = Integer.numberOfTrailingZeros(negatedBitset);
                        int add = INDEX_ADD_BY_DIRECTION_ORDINAL[directionOrdinal];
                        int neighbourIndex = add + queuedIndex;
                        long bitsetValue = opaque[neighbourIndex >>> 6];
                        int directionBitsetForNeighbour = DIRECTIONS_BITSET_BY_INDEX[neighbourIndex];
                        negatedBitset ^= -negatedBitset & negatedBitset;
                        long neighbourMask = 1L << neighbourIndex;
                        long newBitsetValue = bitsetValue | neighbourMask;
                        if (newBitsetValue == bitsetValue) continue;
                        int opposite = OPPOSITE_BITSET_BY_ORIDINAL[directionOrdinal];
                        directionBitset |= directionBitsetForNeighbour;
                        opaque[neighbourIndex >>> 6] = newBitsetValue;
                        if (queued >= queue.length) {
                            queue = this.resizeBFSQueue();
                        }
                        queue[queued++] = neighbourIndex | (directionBitsetForNeighbour | opposite) << 12;
                    }
                }
                int iter1 = directionBitset;
                int ilen = Integer.bitCount(directionBitset);
                for (int i = 0; i < ilen; ++i) {
                    int first = Integer.numberOfTrailingZeros(iter1);
                    iter1 ^= -iter1 & iter1;
                    int iter2 = directionBitset;
                    int klen = Integer.bitCount(directionBitset);
                    for (int k = 0; k < klen; ++k) {
                        int second = Integer.numberOfTrailingZeros(iter2);
                        iter2 ^= -iter2 & iter2;
                        ret.field_4492.set(first + second * class_854.field_4491);
                        ret.field_4492.set(second + first * class_854.field_4491);
                    }
                }
            }
        }
        return ret;
    }

    static {
        int set = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int bitsetIndex;
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    int idx = x | z << 4 | y << 8;
                    int n = bitsetIndex = idx >>> 6;
                    X_SET_FACES[n] = X_SET_FACES[n] | 1L << idx;
                    ++set;
                    int bitset = 0;
                    if (x == 0) {
                        bitset |= 1 << class_2350.field_11039.ordinal();
                    }
                    if (x == 15) {
                        bitset |= 1 << class_2350.field_11034.ordinal();
                    }
                    if (y == 0) {
                        bitset |= 1 << class_2350.field_11033.ordinal();
                    }
                    if (y == 15) {
                        bitset |= 1 << class_2350.field_11036.ordinal();
                    }
                    if (z == 0) {
                        bitset |= 1 << class_2350.field_11043.ordinal();
                    }
                    if (z == 15) {
                        bitset |= 1 << class_2350.field_11035.ordinal();
                    }
                    VisibilityGraph.DIRECTIONS_BITSET_BY_INDEX[idx] = bitset;
                }
            }
        }
        TOTAL_BLOCKS_FACES = set;
        INDEX_ADD_BY_DIRECTION_ORDINAL = new int[class_2350.values().length];
        OPPOSITE_BITSET_BY_ORIDINAL = new int[class_2350.values().length];
        for (class_2350 direction : class_2350.values()) {
            int x = Math.abs(direction.method_10148());
            int y = Math.abs(direction.method_10164());
            int z = Math.abs(direction.method_10165());
            int value = x | z << 4 | y << 8;
            if (direction.method_10171() == class_2350.class_2352.field_11060) {
                value = -value;
            }
            VisibilityGraph.INDEX_ADD_BY_DIRECTION_ORDINAL[direction.ordinal()] = value;
            VisibilityGraph.OPPOSITE_BITSET_BY_ORIDINAL[direction.ordinal()] = 1 << direction.method_10153().ordinal();
        }
    }
}

