/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.light;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkStatus;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.BlockStarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.SkyStarLightEngine;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_8563;

public final class StarLightInterface {
    public static final class_3230 CHUNK_WORK_TICKET = ChunkSystemTicketType.create("starlight:chunk_work_ticket", Long::compareTo);
    public static final int LIGHT_TICKET_LEVEL = class_8563.method_51829((class_2806)class_2806.field_12805);
    public final class_1937 world;
    public final class_2823 lightAccess;
    private static final ThreadLocal<SkyStarLightEngine> SKY_PROPAGATOR = new ThreadLocal();
    private static final ThreadLocal<BlockStarLightEngine> BLOCK_PROPAGATOR = new ThreadLocal();
    private final LightQueue lightQueue;
    private final class_3562 skyReader;
    private final class_3562 blockReader;
    private final boolean isClientSide;
    public final int minSection;
    public final int maxSection;
    public final int minLightSection;
    public final int maxLightSection;
    public final class_3568 lightEngine;
    private final boolean hasBlockLight;
    private final boolean hasSkyLight;

    public StarLightInterface(class_2823 lightAccess, boolean hasSkyLight, boolean hasBlockLight, class_3568 lightEngine) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (class_1937)lightAccess.method_16399();
        boolean bl = this.isClientSide = !(this.world instanceof class_3218);
        if (this.world == null) {
            this.minSection = -4;
            this.maxSection = 19;
            this.minLightSection = -5;
            this.maxLightSection = 20;
        } else {
            this.minSection = WorldUtil.getMinSection(this.world);
            this.maxSection = WorldUtil.getMaxSection(this.world);
            this.minLightSection = WorldUtil.getMinLightSection((class_5539)this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection((class_5539)this.world);
        }
        this.lightQueue = this.world instanceof class_3218 ? new ServerLightQueue(this) : new ClientLightQueue(this);
        this.lightEngine = lightEngine;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
        this.skyReader = !hasSkyLight ? class_3562.class_3563.field_15812 : new class_3562(){

            public void method_15513(class_2338 blockPos) {
                StarLightInterface.this.lightEngine.method_15513(blockPos.method_10062());
            }

            public void method_51471(class_1923 chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean method_15518() {
                return StarLightInterface.this.hasUpdates();
            }

            public int method_15516() {
                throw new UnsupportedOperationException();
            }

            public void method_15512(class_1923 chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public class_2804 method_15544(class_4076 pos) {
                class_2791 chunk = StarLightInterface.this.getAnyChunkNow(pos.method_10263(), pos.method_10260());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.method_12038() || !chunk.method_12009().method_12165(class_2806.field_12805)) {
                    return null;
                }
                int sectionY = pos.method_10264();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (((StarlightChunk)chunk).starlight$getSkyEmptinessMap() == null) {
                    return null;
                }
                return ((StarlightChunk)chunk).starlight$getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int method_15543(class_2338 blockPos) {
                return StarLightInterface.this.getSkyLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4));
            }

            public void method_15551(class_4076 pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? class_3562.class_3563.field_15812 : new class_3562(){

            public void method_15513(class_2338 blockPos) {
                StarLightInterface.this.lightEngine.method_15513(blockPos.method_10062());
            }

            public void method_51471(class_1923 chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean method_15518() {
                return StarLightInterface.this.hasUpdates();
            }

            public int method_15516() {
                throw new UnsupportedOperationException();
            }

            public void method_15512(class_1923 chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public class_2804 method_15544(class_4076 pos) {
                class_2791 chunk = StarLightInterface.this.getAnyChunkNow(pos.method_10263(), pos.method_10260());
                if (chunk == null || pos.method_10264() < StarLightInterface.this.minLightSection || pos.method_10264() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return ((StarlightChunk)chunk).starlight$getBlockNibbles()[pos.method_10264() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int method_15543(class_2338 blockPos) {
                return StarLightInterface.this.getBlockLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4));
            }

            public void method_15551(class_4076 pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
    }

    public ClientLightQueue getClientLightQueue() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ClientLightQueue) {
            ClientLightQueue clientLightQueue = (ClientLightQueue)lightQueue;
            return clientLightQueue;
        }
        return null;
    }

    public ServerLightQueue getServerLightQueue() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ServerLightQueue) {
            ServerLightQueue serverLightQueue = (ServerLightQueue)lightQueue;
            return serverLightQueue;
        }
        return null;
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasBlockLight() {
        return this.hasBlockLight;
    }

    public int getSkyLightValue(class_2338 blockPos, class_2791 chunk) {
        int currY;
        SWMRNibbleArray[] nibbles;
        SWMRNibbleArray immediate;
        if (!this.hasSkyLight) {
            return 0;
        }
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        int minSection = this.minSection;
        int maxSection = this.maxSection;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (chunk == null || !this.isClientSide && !chunk.method_12038() || !chunk.method_12009().method_12165(class_2806.field_12805)) {
            return 15;
        }
        int sectionY = y >> 4;
        if (sectionY > maxLightSection) {
            return 15;
        }
        if (sectionY < minLightSection) {
            sectionY = minLightSection;
            y = sectionY << 4;
        }
        if (!(immediate = (nibbles = ((StarlightChunk)chunk).starlight$getSkyNibbles())[sectionY - minLightSection]).isNullNibbleVisible()) {
            return immediate.getVisible(x, y, z);
        }
        boolean[] emptinessMap = ((StarlightChunk)chunk).starlight$getSkyEmptinessMap();
        if (emptinessMap == null) {
            return 15;
        }
        int lowestY = minLightSection - 1;
        for (currY = maxSection; currY >= minSection; --currY) {
            if (emptinessMap[currY - minSection]) continue;
            lowestY = currY;
            break;
        }
        if (sectionY > lowestY) {
            return 15;
        }
        for (currY = sectionY + 1; currY <= maxLightSection; ++currY) {
            SWMRNibbleArray nibble = nibbles[currY - minLightSection];
            if (nibble.isNullNibbleVisible()) continue;
            return nibble.getVisible(x, 0, z);
        }
        return 15;
    }

    public int getBlockLightValue(class_2338 blockPos, class_2791 chunk) {
        if (!this.hasBlockLight) {
            return 0;
        }
        int y = blockPos.method_10264();
        int cy = y >> 4;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (cy < minLightSection || cy > maxLightSection) {
            return 0;
        }
        if (chunk == null) {
            return 0;
        }
        SWMRNibbleArray nibble = ((StarlightChunk)chunk).starlight$getBlockNibbles()[cy - minLightSection];
        return nibble.getVisible(blockPos.method_10263(), y, blockPos.method_10260());
    }

    public int getRawBrightness(class_2338 pos, int ambientDarkness) {
        class_2791 chunk = this.getAnyChunkNow(pos.method_10263() >> 4, pos.method_10260() >> 4);
        int sky = this.getSkyLightValue(pos, chunk) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.getBlockLightValue(pos, chunk);
        return Math.max(sky, block);
    }

    public class_3562 getSkyReader() {
        return this.skyReader;
    }

    public class_3562 getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public class_2791 getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        return ((ChunkSystemLevel)this.world).moonrise$getAnyChunkIfLoaded(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public class_2823 getLightAccess() {
        return this.lightAccess;
    }

    public SkyStarLightEngine getSkyLightEngine() {
        if (!this.hasSkyLight || this.world == null) {
            return null;
        }
        SkyStarLightEngine ret = SKY_PROPAGATOR.get();
        SKY_PROPAGATOR.set(null);
        if (ret == null) {
            ret = new SkyStarLightEngine();
        }
        ret.setWorld(this.world);
        return ret;
    }

    public void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (engine != null) {
            engine.setWorld(null);
        }
        if (!this.hasSkyLight || this.world == null || SKY_PROPAGATOR.get() != null) {
            return;
        }
        SKY_PROPAGATOR.set(engine);
    }

    public BlockStarLightEngine getBlockLightEngine() {
        if (!this.hasBlockLight || this.world == null) {
            return null;
        }
        BlockStarLightEngine ret = BLOCK_PROPAGATOR.get();
        BLOCK_PROPAGATOR.set(null);
        if (ret == null) {
            ret = new BlockStarLightEngine();
        }
        ret.setWorld(this.world);
        return ret;
    }

    public void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (engine != null) {
            engine.setWorld(null);
        }
        if (!this.hasBlockLight || this.world == null || BLOCK_PROPAGATOR.get() != null) {
            return;
        }
        BLOCK_PROPAGATOR.set(engine);
    }

    public LightQueue.ChunkTasks blockChange(class_2338 pos) {
        if (this.world == null || pos.method_10264() < WorldUtil.getMinBlockY((class_5539)this.world) || pos.method_10264() > WorldUtil.getMaxBlockY((class_5539)this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public LightQueue.ChunkTasks sectionChange(class_4076 pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(class_2791 chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(class_2791 chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<class_1923> chunks, Consumer<class_1923> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void propagateChanges() {
        LightQueue lightQueue = this.lightQueue;
        if (lightQueue instanceof ClientLightQueue) {
            ClientLightQueue clientLightQueue = (ClientLightQueue)lightQueue;
            clientLightQueue.drainTasks();
        }
    }

    public static final class ServerLightQueue
    extends LightQueue {
        private final ConcurrentLong2ReferenceChainedHashTable<ServerChunkTasks> chunkTasks = new ConcurrentLong2ReferenceChainedHashTable();

        public ServerLightQueue(StarLightInterface lightInterface) {
            super(lightInterface);
        }

        public void lowerPriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.lowerPriority(priority);
            }
        }

        public void setPriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.setPriority(priority);
            }
        }

        public void raisePriority(int chunkX, int chunkZ, Priority priority) {
            ServerChunkTasks task = this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                task.raisePriority(priority);
            }
        }

        public Priority getPriority(int chunkX, int chunkZ) {
            ServerChunkTasks task = this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (task != null) {
                return task.getPriority();
            }
            return Priority.COMPLETING;
        }

        @Override
        public boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        @Override
        public ServerChunkTasks queueBlockChange(class_2338 pos) {
            ServerChunkTasks ret = this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addChangedPosition(pos);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueSectionChange(class_4076 pos, boolean newEmptyValue) {
            ServerChunkTasks ret = this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.setChangedSection(pos.method_10264(), newEmptyValue);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        public ServerChunkTasks queueChunkLightTask(class_1923 pos, BooleanSupplier lightTask, Priority priority) {
            ServerChunkTasks ret = this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this, priority);
                }
                valueInMap.addLightTask(lightTask);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueChunkSkylightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ServerChunkTasks ret = this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addEdgeChecksSky(sections);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        @Override
        public ServerChunkTasks queueChunkBlocklightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ServerChunkTasks ret = this.chunkTasks.compute(CoordinateUtils.getChunkKey(pos), (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    valueInMap = new ServerChunkTasks(keyInMap, this.lightInterface, this);
                }
                valueInMap.addEdgeChecksBlock(sections);
                return valueInMap;
            });
            ret.schedule();
            return ret;
        }

        public static final class ServerChunkTasks
        extends LightQueue.ChunkTasks {
            private final AtomicBoolean ticketAdded = new AtomicBoolean();
            private final PrioritisedExecutor.PrioritisedTask task;

            public ServerChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ServerLightQueue queue) {
                this(chunkCoordinate, lightEngine, queue, Priority.NORMAL);
            }

            public ServerChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ServerLightQueue queue, Priority priority) {
                super(chunkCoordinate, lightEngine, queue);
                this.task = ((ChunkSystemServerLevel)((class_3218)lightEngine.getWorld())).moonrise$getChunkTaskScheduler().radiusAwareScheduler.createTask(CoordinateUtils.getChunkX(chunkCoordinate), CoordinateUtils.getChunkZ(chunkCoordinate), ((ChunkSystemChunkStatus)class_2806.field_12805).moonrise$getWriteRadius(), this, priority);
            }

            public boolean markTicketAdded() {
                return !this.ticketAdded.get() && false == this.ticketAdded.compareAndExchange(false, true);
            }

            public void schedule() {
                this.task.queue();
            }

            public boolean cancel() {
                return this.task.cancel();
            }

            public Priority getPriority() {
                return this.task.getPriority();
            }

            public void lowerPriority(Priority priority) {
                this.task.lowerPriority(priority);
            }

            public void setPriority(Priority priority) {
                this.task.setPriority(priority);
            }

            public void raisePriority(Priority priority) {
                this.task.raisePriority(priority);
            }

            @Override
            public void run() {
                ((ServerLightQueue)this.queue).chunkTasks.remove(this.chunkCoordinate, this);
                this.runTasks();
            }
        }
    }

    public static abstract class LightQueue {
        protected final StarLightInterface lightInterface;

        public LightQueue(StarLightInterface lightInterface) {
            this.lightInterface = lightInterface;
        }

        public abstract boolean isEmpty();

        public abstract ChunkTasks queueBlockChange(class_2338 var1);

        public abstract ChunkTasks queueSectionChange(class_4076 var1, boolean var2);

        public abstract ChunkTasks queueChunkSkylightEdgeCheck(class_4076 var1, ShortCollection var2);

        public abstract ChunkTasks queueChunkBlocklightEdgeCheck(class_4076 var1, ShortCollection var2);

        public static abstract class ChunkTasks
        implements Runnable {
            public final long chunkCoordinate;
            protected final StarLightInterface lightEngine;
            protected final LightQueue queue;
            protected final MultiThreadedQueue<Runnable> onComplete = new MultiThreadedQueue();
            protected final Set<class_2338> changedPositions = new HashSet<class_2338>();
            protected Boolean[] changedSectionSet;
            protected ShortOpenHashSet queuedEdgeChecksSky;
            protected ShortOpenHashSet queuedEdgeChecksBlock;
            protected List<BooleanSupplier> lightTasks;

            public ChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, LightQueue queue) {
                this.chunkCoordinate = chunkCoordinate;
                this.lightEngine = lightEngine;
                this.queue = queue;
            }

            @Override
            public abstract void run();

            public void queueOrRunTask(Runnable run) {
                if (!this.onComplete.add(run)) {
                    run.run();
                }
            }

            protected void addChangedPosition(class_2338 pos) {
                this.changedPositions.add(pos.method_10062());
            }

            protected void setChangedSection(int y, Boolean newEmptyValue) {
                if (this.changedSectionSet == null) {
                    this.changedSectionSet = new Boolean[this.lightEngine.maxSection - this.lightEngine.minSection + 1];
                }
                this.changedSectionSet[y - this.lightEngine.minSection] = newEmptyValue;
            }

            protected void addLightTask(BooleanSupplier lightTask) {
                if (this.lightTasks == null) {
                    this.lightTasks = new ArrayList<BooleanSupplier>();
                }
                this.lightTasks.add(lightTask);
            }

            protected void addEdgeChecksSky(ShortCollection values) {
                if (this.queuedEdgeChecksSky == null) {
                    this.queuedEdgeChecksSky = new ShortOpenHashSet(Math.max(8, values.size()));
                }
                this.queuedEdgeChecksSky.addAll(values);
            }

            protected void addEdgeChecksBlock(ShortCollection values) {
                if (this.queuedEdgeChecksBlock == null) {
                    this.queuedEdgeChecksBlock = new ShortOpenHashSet(Math.max(8, values.size()));
                }
                this.queuedEdgeChecksBlock.addAll(values);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final void runTasks() {
                Runnable run;
                boolean litChunk = false;
                if (this.lightTasks != null) {
                    for (BooleanSupplier run2 : this.lightTasks) {
                        if (!run2.getAsBoolean()) continue;
                        litChunk = true;
                        break;
                    }
                }
                if (!litChunk) {
                    SkyStarLightEngine skyEngine = this.lightEngine.getSkyLightEngine();
                    BlockStarLightEngine blockEngine = this.lightEngine.getBlockLightEngine();
                    try {
                        long coordinate = this.chunkCoordinate;
                        int chunkX = CoordinateUtils.getChunkX(coordinate);
                        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
                        Set<class_2338> positions = this.changedPositions;
                        Boolean[] sectionChanges = this.changedSectionSet;
                        if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
                            skyEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                        }
                        if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
                            blockEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                        }
                        if (skyEngine != null && this.queuedEdgeChecksSky != null) {
                            skyEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksSky);
                        }
                        if (blockEngine != null && this.queuedEdgeChecksBlock != null) {
                            blockEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksBlock);
                        }
                    }
                    finally {
                        this.lightEngine.releaseSkyLightEngine(skyEngine);
                        this.lightEngine.releaseBlockLightEngine(blockEngine);
                    }
                }
                while ((run = this.onComplete.pollOrBlockAdds()) != null) {
                    run.run();
                }
            }
        }
    }

    public static final class ClientLightQueue
    extends LightQueue {
        private final Long2ObjectLinkedOpenHashMap<ClientChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();

        public ClientLightQueue(StarLightInterface lightInterface) {
            super(lightInterface);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        private ClientChunkTasks getOrCreate(long key) {
            return (ClientChunkTasks)this.chunkTasks.computeIfAbsent(key, keyInMap -> new ClientChunkTasks(keyInMap, this.lightInterface, this));
        }

        @Override
        public synchronized ClientChunkTasks queueBlockChange(class_2338 pos) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addChangedPosition(pos);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueSectionChange(class_4076 pos, boolean newEmptyValue) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.setChangedSection(pos.method_10264(), newEmptyValue);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueChunkSkylightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addEdgeChecksSky(sections);
            return tasks;
        }

        @Override
        public synchronized ClientChunkTasks queueChunkBlocklightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ClientChunkTasks tasks = this.getOrCreate(CoordinateUtils.getChunkKey(pos));
            tasks.addEdgeChecksBlock(sections);
            return tasks;
        }

        public synchronized ClientChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ClientChunkTasks)this.chunkTasks.removeFirst();
        }

        public void drainTasks() {
            ClientChunkTasks task;
            while ((task = this.removeFirstTask()) != null) {
                task.runTasks();
            }
        }

        public static final class ClientChunkTasks
        extends LightQueue.ChunkTasks {
            public ClientChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, ClientLightQueue queue) {
                super(chunkCoordinate, lightEngine, queue);
            }

            @Override
            public void run() {
                this.runTasks();
            }
        }
    }
}

