/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public final class SimpleThreadUnsafeRandom
implements BitRandomSource {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final int BITS = 48;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long value;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian((RandomSource)this);

    public SimpleThreadUnsafeRandom(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.value = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.gaussianSource.reset();
    }

    private long advanceSeed() {
        this.value = this.value * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return this.value;
    }

    public int next(int bits) {
        return (int)(this.advanceSeed() >>> 48 - bits);
    }

    public int nextInt() {
        long seed = this.advanceSeed();
        return (int)(seed >>> 16);
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        long value = this.advanceSeed() >>> 16;
        return (int)(value * (long)bound >>> 32);
    }

    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    public RandomSource fork() {
        return new SimpleThreadUnsafeRandom(this.nextLong());
    }

    public PositionalRandomFactory forkPositional() {
        return new SimpleRandomPositionalFactory(this.nextLong());
    }

    public static final class SimpleRandomPositionalFactory
    implements PositionalRandomFactory {
        private final long seed;

        public SimpleRandomPositionalFactory(long seed) {
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }

        public RandomSource fromHashOf(String string) {
            return new SimpleThreadUnsafeRandom((long)string.hashCode() ^ this.seed);
        }

        public RandomSource fromSeed(long seed) {
            return new SimpleThreadUnsafeRandom(seed);
        }

        public RandomSource at(int x, int y, int z) {
            return new SimpleThreadUnsafeRandom(Mth.getSeed((int)x, (int)y, (int)z) ^ this.seed);
        }

        public void parityConfigString(StringBuilder stringBuilder) {
            stringBuilder.append("SimpleRandomPositionalFactory{").append(this.seed).append('}');
        }
    }
}

