/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.queue;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntPairUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;

public final class AreaDependentQueue {
    public static final long FLAG_ORDER_BY_STREAM = 1L;
    private final AtomicLong idGenerator = new AtomicLong();
    private final PrioritisedExecutor executor;
    private final ConcurrentLong2ReferenceChainedHashTable<Position> tasks = ConcurrentLong2ReferenceChainedHashTable.createWithCapacity(1024, 0.25f);
    private final ReentrantAreaLock lock;
    private final boolean orderByLowerStream;

    public AreaDependentQueue(PrioritisedExecutor executor, int lockShift) {
        this(executor, lockShift, 0L);
    }

    public AreaDependentQueue(PrioritisedExecutor executor, int lockShift, long flags) {
        this.executor = executor;
        this.lock = new ReentrantAreaLock(lockShift);
        this.orderByLowerStream = (flags & 1L) != 0L;
    }

    public long generateNextSubOrder() {
        return this.executor.generateNextSubOrder();
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int x, int y, int radius, Runnable run) {
        return this.createTask(x - radius, y - radius, x + radius, y + radius, run);
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int x, int y, int radius, Runnable run, Priority priority) {
        return this.createTask(x - radius, y - radius, x + radius, y + radius, run, priority);
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int x, int y, int radius, Runnable run, Priority priority, long subOrder, long stream) {
        return this.createTask(x - radius, y - radius, x + radius, y + radius, run, priority, subOrder, stream);
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int minX, int minY, int maxX, int maxY, Runnable run) {
        return this.createTask(minX, minY, maxX, maxY, run, Priority.NORMAL);
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int minX, int minY, int maxX, int maxY, Runnable run, Priority priority) {
        return this.createTask(minX, minY, maxX, maxY, run, priority, this.generateNextSubOrder(), 0L);
    }

    public PrioritisedExecutor.PrioritisedTask createTask(int minX, int minY, int maxX, int maxY, Runnable run, Priority priority, long subOrder, long stream) {
        if (minX > maxX || minY > maxY) {
            throw new IllegalArgumentException("min should be <= max");
        }
        return new PositionedTask(this, this.idGenerator.getAndIncrement(), minX, minY, maxX, maxY, run, priority, subOrder, stream);
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int x, int y, int radius, Runnable run) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(x, y, radius, run);
        ret.queue();
        return ret;
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int x, int y, int radius, Runnable run, Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(x, y, radius, run, priority);
        ret.queue();
        return ret;
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int x, int y, int radius, Runnable run, Priority priority, long subOrder, long stream) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(x, y, radius, run, priority, subOrder, stream);
        ret.queue();
        return ret;
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int minX, int minY, int maxX, int maxY, Runnable run) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(minX, minY, maxX, maxY, run);
        ret.queue();
        return ret;
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int minX, int minY, int maxX, int maxY, Runnable run, Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(minX, minY, maxX, maxY, run, priority);
        ret.queue();
        return ret;
    }

    public PrioritisedExecutor.PrioritisedTask queueTask(int minX, int minY, int maxX, int maxY, Runnable run, Priority priority, long subOrder, long stream) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(minX, minY, maxX, maxY, run, priority, subOrder, stream);
        ret.queue();
        return ret;
    }

    boolean add(PositionedTask positionedTask, QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
        int minX = positionedTask.minX;
        int minY = positionedTask.minY;
        int maxX = positionedTask.maxX;
        int maxY = positionedTask.maxY;
        boolean first = true;
        for (int currY = minY; currY <= maxY; ++currY) {
            for (int currX = minX; currX <= maxX; ++currX) {
                long key = IntPairUtil.key(currX, currY);
                Position position = this.tasks.computeIfAbsent(key, keyInMap -> new Position());
                first &= position.addTask(task, toCancel);
            }
        }
        return first;
    }

    void remove(PositionedTask positionedTask, QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toQueue) {
        int minX = positionedTask.minX;
        int minY = positionedTask.minY;
        int maxX = positionedTask.maxX;
        int maxY = positionedTask.maxY;
        for (int currY = minY; currY <= maxY; ++currY) {
            for (int currX = minX; currX <= maxX; ++currX) {
                long key = IntPairUtil.key(currX, currY);
                Position position = this.tasks.get(key);
                if (position.removeTask(task, toQueue)) continue;
                this.tasks.remove(key);
            }
        }
    }

    void adjust(PositionedTask positionedTask, QueuedTask oldTask, QueuedTask newTask, List<PrioritisedExecutor.PrioritisedTask> toQueue, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
        int minX = positionedTask.minX;
        int minY = positionedTask.minY;
        int maxX = positionedTask.maxX;
        int maxY = positionedTask.maxY;
        for (int currY = minY; currY <= maxY; ++currY) {
            for (int currX = minX; currX <= maxX; ++currX) {
                this.tasks.get(IntPairUtil.key(currX, currY)).adjustTask(oldTask, newTask, toQueue, toCancel);
            }
        }
    }

    private static final class PositionedTask
    implements PrioritisedExecutor.PrioritisedTask {
        private static final int STATE_NOT_QUEUED = 1;
        private static final int STATE_WAITING = 2;
        private static final int STATE_SCHEDULED = 4;
        private static final int STATE_EXECUTING = 8;
        private int waitingPosCount;
        private int state = 1;
        private QueuedTask scheduledTask;
        private final AreaDependentQueue areaDependentQueue;
        private final long taskId;
        private final int minX;
        private final int minY;
        private final int maxX;
        private final int maxY;
        private final int maxWaitingPos;
        private final Runnable run;

        private PositionedTask(AreaDependentQueue areaDependentQueue, long taskId, int minX, int minY, int maxX, int maxY, Runnable run, Priority priority, long subOrder, long stream) {
            this.areaDependentQueue = areaDependentQueue;
            this.taskId = taskId;
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxWaitingPos = (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1);
            this.run = run;
            this.scheduledTask = new QueuedTask(priority, subOrder, stream, this, areaDependentQueue.executor);
        }

        void incWaitingPosRaw() {
            if (++this.waitingPosCount > this.maxWaitingPos) {
                throw new IllegalStateException("Waiting pos too large");
            }
        }

        void decWaitingPosRaw() {
            if (--this.waitingPosCount < 0) {
                throw new IllegalStateException("Waiting pos too small");
            }
        }

        synchronized boolean incWaitingPos(QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
            int state = this.state;
            switch (state) {
                case 2: {
                    this.incWaitingPosRaw();
                    return true;
                }
                case 4: {
                    this.state = 2;
                    this.incWaitingPosRaw();
                    if (toCancel != null) {
                        toCancel.add(task.swapTask(this.areaDependentQueue.executor));
                    }
                    return true;
                }
                case 8: {
                    return false;
                }
            }
            throw new IllegalStateException("Illegal or unknown state: " + state);
        }

        synchronized void decWaitingPos(QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toQueue) {
            int state = this.state;
            if (state == 2) {
                int newWaiting;
                if ((newWaiting = --this.waitingPosCount) == 0) {
                    this.state = 4;
                    toQueue.add(task.prioritisedTask);
                    return;
                }
                if (newWaiting < 0) {
                    throw new IllegalStateException("Waiting pos too small");
                }
                return;
            }
            throw new IllegalStateException("Illegal or unknown state: " + state);
        }

        synchronized boolean tryMarkExecuting(QueuedTask scheduledTask) {
            if (this.scheduledTask != scheduledTask || this.state != 4) {
                return false;
            }
            this.state = 8;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishTask(QueuedTask scheduledTask) {
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
            ReentrantAreaLock.Node lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
            try {
                this.areaDependentQueue.remove(this, scheduledTask, toQueue);
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toQueue.size();
            for (int i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
            }
        }

        private void adjustPriority(Priority priority, long subOrder, long stream, List<PrioritisedExecutor.PrioritisedTask> toQueue, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
            QueuedTask oldTask = this.scheduledTask;
            QueuedTask newTask = this.scheduledTask = new QueuedTask(priority, subOrder, stream, this, this.areaDependentQueue.executor);
            toCancel.add(oldTask.prioritisedTask);
            this.areaDependentQueue.adjust(this, oldTask, newTask, toQueue, toCancel);
            if (this.waitingPosCount == 0) {
                this.state = 4;
                toQueue.add(newTask.prioritisedTask);
            }
        }

        @Override
        public PrioritisedExecutor getExecutor() {
            return this.areaDependentQueue.executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean queue() {
            PrioritisedExecutor.PrioritisedTask toQueue;
            if (this.state != 1) {
                PositionedTask positionedTask = this;
                synchronized (positionedTask) {
                    return false;
                }
            }
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
            ReentrantAreaLock.Node lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
            try {
                PositionedTask positionedTask = this;
                synchronized (positionedTask) {
                    block16: {
                        if (this.state == 1) break block16;
                        boolean bl = false;
                        return bl;
                    }
                    boolean queue = this.areaDependentQueue.add(this, this.scheduledTask, toCancel);
                    if (queue) {
                        this.state = 4;
                        toQueue = this.scheduledTask.prioritisedTask;
                    } else {
                        this.state = 2;
                        toQueue = null;
                    }
                }
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (int i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            if (toQueue != null) {
                toQueue.queue();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isQueued() {
            PositionedTask positionedTask = this;
            synchronized (positionedTask) {
                return this.state != 1 && this.state != 8;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean cancel() {
            PrioritisedExecutor.PrioritisedTask toCancel;
            if (this.state == 1 || this.state == 8) {
                PositionedTask positionedTask = this;
                synchronized (positionedTask) {
                    if (this.state == 1) {
                        this.state = 8;
                        return true;
                    }
                    if (this.state == 8) {
                        return false;
                    }
                }
            }
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
            ReentrantAreaLock.Node lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
            try {
                PositionedTask positionedTask = this;
                synchronized (positionedTask) {
                    int state = this.state;
                    switch (this.state) {
                        case 2: {
                            this.state = 8;
                            toCancel = null;
                            break;
                        }
                        case 4: {
                            this.state = 8;
                            toCancel = this.scheduledTask.prioritisedTask;
                            break;
                        }
                        case 8: {
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + state);
                        }
                    }
                }
                this.areaDependentQueue.remove(this, this.scheduledTask, toQueue);
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            if (toCancel != null) {
                toCancel.cancel();
            }
            int i = 0;
            int len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        @Override
        public boolean execute() {
            if (!this.cancel()) {
                return false;
            }
            this.run.run();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Priority getPriority() {
            PositionedTask positionedTask = this;
            synchronized (positionedTask) {
                return this.state == 8 ? Priority.COMPLETING : this.scheduledTask.priority;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean setPriority(Priority priority) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.priority == priority) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.priority = priority;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.priority != priority) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(priority, this.scheduledTask.subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean raisePriority(Priority priority) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.priority.isHigherOrEqualPriority(priority)) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.priority = priority;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (!this.scheduledTask.priority.isHigherOrEqualPriority(priority)) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(priority, this.scheduledTask.subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean lowerPriority(Priority priority) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.priority.isLowerOrEqualPriority(priority)) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.priority = priority;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (!this.scheduledTask.priority.isLowerOrEqualPriority(priority)) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(priority, this.scheduledTask.subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSubOrder() {
            PositionedTask positionedTask = this;
            synchronized (positionedTask) {
                return this.state == 8 ? 0L : this.scheduledTask.subOrder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean setSubOrder(long subOrder) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.subOrder == subOrder) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.subOrder = subOrder;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.subOrder != subOrder) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(this.scheduledTask.priority, subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean raiseSubOrder(long subOrder) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.subOrder >= subOrder) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.subOrder = subOrder;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.subOrder < subOrder) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(this.scheduledTask.priority, subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean lowerSubOrder(long subOrder) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.subOrder <= subOrder) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.subOrder = subOrder;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.subOrder > subOrder) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(this.scheduledTask.priority, subOrder, this.scheduledTask.stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getStream() {
            PositionedTask positionedTask = this;
            synchronized (positionedTask) {
                return this.state == 8 ? 0L : this.scheduledTask.stream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean setStream(long stream) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.stream == stream) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.stream = stream;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.stream != stream) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(this.scheduledTask.priority, this.scheduledTask.subOrder, stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean setPrioritySubOrderStream(Priority priority, long subOrder, long stream) {
            int i;
            ReentrantAreaLock.Node lock;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toCancel;
            ArrayList<PrioritisedExecutor.PrioritisedTask> toQueue;
            block21: {
                switch (this.state) {
                    case 1: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        if (this.state != 1) {
                            // MONITOREXIT : positionedTask
                            break;
                        }
                        if (this.scheduledTask.priority == priority && this.scheduledTask.subOrder == subOrder && this.scheduledTask.stream == stream) {
                            // MONITOREXIT : positionedTask
                            return false;
                        }
                        this.scheduledTask.priority = priority;
                        this.scheduledTask.subOrder = subOrder;
                        this.scheduledTask.stream = stream;
                        // MONITOREXIT : positionedTask
                        return true;
                    }
                    case 8: {
                        PositionedTask positionedTask = this;
                        // MONITORENTER : positionedTask
                        // MONITOREXIT : positionedTask
                        return false;
                    }
                }
                toQueue = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                toCancel = new ArrayList<PrioritisedExecutor.PrioritisedTask>();
                lock = this.areaDependentQueue.lock.lock(this.minX, this.minY, this.maxX, this.maxY);
                PositionedTask positionedTask = this;
                // MONITORENTER : positionedTask
                if (this.state == 8) {
                    boolean bl = false;
                    // MONITOREXIT : positionedTask
                    this.areaDependentQueue.lock.unlock(lock);
                    return bl;
                }
                if (this.scheduledTask.priority != priority || this.scheduledTask.subOrder != subOrder || this.scheduledTask.stream != stream) break block21;
                boolean bl = false;
                this.areaDependentQueue.lock.unlock(lock);
                return bl;
            }
            try {
                this.adjustPriority(priority, subOrder, stream, toQueue, toCancel);
                // MONITOREXIT : positionedTask
            }
            finally {
                this.areaDependentQueue.lock.unlock(lock);
            }
            int len = toCancel.size();
            for (i = 0; i < len; ++i) {
                ((PrioritisedExecutor.PrioritisedTask)toCancel.get(i)).cancel();
            }
            i = 0;
            len = toQueue.size();
            while (i < len) {
                ((PrioritisedExecutor.PrioritisedTask)toQueue.get(i)).queue();
                ++i;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrioritisedExecutor.PriorityState getPriorityState() {
            PositionedTask positionedTask = this;
            synchronized (positionedTask) {
                if (this.state == 8) {
                    return null;
                }
                return new PrioritisedExecutor.PriorityState(this.scheduledTask.priority, this.scheduledTask.subOrder, this.scheduledTask.stream);
            }
        }
    }

    private static final class Position {
        private final PriorityQueue<QueuedTask> queue = new PriorityQueue();
        private QueuedTask firstOrRunning;

        private Position() {
        }

        boolean addTask(QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
            this.queue.add(task);
            if (this.queue.peek() != task) {
                task.positionedTask.incWaitingPosRaw();
                return false;
            }
            QueuedTask currentFirst = this.firstOrRunning;
            if (currentFirst == null || currentFirst.positionedTask.incWaitingPos(currentFirst, toCancel)) {
                this.firstOrRunning = task;
                return true;
            }
            task.positionedTask.incWaitingPosRaw();
            return false;
        }

        boolean removeTask(QueuedTask task, List<PrioritisedExecutor.PrioritisedTask> toQueue) {
            this.queue.remove(task);
            QueuedTask currentFirst = this.firstOrRunning;
            if (task != currentFirst) {
                return true;
            }
            QueuedTask nextFirst = this.queue.peek();
            if (nextFirst == null) {
                this.firstOrRunning = null;
                return false;
            }
            this.firstOrRunning = nextFirst;
            nextFirst.positionedTask.decWaitingPos(nextFirst, toQueue);
            return true;
        }

        void adjustTask(QueuedTask oldTask, QueuedTask newTask, List<PrioritisedExecutor.PrioritisedTask> toQueue, List<PrioritisedExecutor.PrioritisedTask> toCancel) {
            this.queue.remove(oldTask);
            this.queue.add(newTask);
            QueuedTask currentFirst = this.firstOrRunning;
            QueuedTask nextFirst = this.queue.peek();
            if (currentFirst == nextFirst) {
                return;
            }
            if (currentFirst == oldTask) {
                this.firstOrRunning = nextFirst;
                if (nextFirst != newTask) {
                    nextFirst.positionedTask.decWaitingPos(nextFirst, toQueue);
                    if (!oldTask.positionedTask.incWaitingPos(oldTask, null)) {
                        throw new IllegalStateException("Old task may not be in executing state");
                    }
                }
                return;
            }
            if (!currentFirst.positionedTask.incWaitingPos(currentFirst, toCancel)) {
                return;
            }
            this.firstOrRunning = nextFirst;
            if (nextFirst == newTask) {
                nextFirst.positionedTask.decWaitingPosRaw();
            } else {
                nextFirst.positionedTask.decWaitingPos(newTask, toQueue);
            }
        }
    }

    private static final class QueuedTask
    implements Runnable,
    Comparable<QueuedTask> {
        private Priority priority;
        private long subOrder;
        private long stream;
        private final PositionedTask positionedTask;
        private PrioritisedExecutor.PrioritisedTask prioritisedTask;

        private QueuedTask(Priority priority, long subOrder, long stream, PositionedTask positionedTask, PrioritisedExecutor executor) {
            this.priority = priority;
            this.subOrder = subOrder;
            this.stream = stream;
            this.positionedTask = positionedTask;
            this.prioritisedTask = executor.createTask(this, priority, subOrder, stream);
        }

        PrioritisedExecutor.PrioritisedTask swapTask(PrioritisedExecutor executor) {
            PrioritisedExecutor.PrioritisedTask ret = this.prioritisedTask;
            this.prioritisedTask = executor.createTask(this, this.priority, this.subOrder, this.stream);
            return ret;
        }

        @Override
        public void run() {
            PositionedTask task = this.positionedTask;
            if (!task.tryMarkExecuting(this)) {
                return;
            }
            try {
                task.run.run();
            }
            finally {
                task.finishTask(this);
            }
        }

        @Override
        public int compareTo(QueuedTask other) {
            int streamCompare;
            int priorityCompare = this.priority.priority - other.priority.priority;
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            if (this.positionedTask.areaDependentQueue.orderByLowerStream && (streamCompare = Long.compare(this.stream, other.stream)) != 0) {
                return streamCompare;
            }
            int subOrderCompare = Long.compare(this.subOrder, other.subOrder);
            if (subOrderCompare != 0) {
                return subOrderCompare;
            }
            return Long.signum(this.positionedTask.taskId - other.positionedTask.taskId);
        }
    }
}

