/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.bitstorage;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntegerUtil;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SimpleBitStorage.class})
abstract class SimpleBitStorageMixin
implements BitStorage {
    @Shadow
    @Final
    private int bits;
    @Shadow
    @Final
    private long[] data;
    @Shadow
    @Final
    private long mask;
    @Shadow
    @Final
    private int size;
    @Unique
    private static final int[] BETTER_MAGIC = new int[33];
    @Unique
    private int magic;
    @Unique
    private int mulBits;

    SimpleBitStorageMixin() {
    }

    @Inject(method={"<init>(II[J)V"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.magic = BETTER_MAGIC[this.bits];
        this.mulBits = 64 / this.bits * this.bits;
        if (this.size > 4096) {
            throw new IllegalStateException("Size > 4096 not supported");
        }
    }

    @Overwrite
    public int getAndSet(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.data;
        long data = dataArray[divQ];
        long mask = this.mask;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
        return (int)(data >>> divR & mask);
    }

    @Overwrite
    public void set(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.data;
        long data = dataArray[divQ];
        long mask = this.mask;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
    }

    @Overwrite
    public int get(int index) {
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        return (int)(this.data[divQ] >>> divR & this.mask);
    }

    static {
        for (int bits = 1; bits < BETTER_MAGIC.length; ++bits) {
            SimpleBitStorageMixin.BETTER_MAGIC[bits] = (int)IntegerUtil.getUnsignedDivisorMagic(64L / (long)bits, 20);
        }
    }
}

