/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.blockstate_propertyaccess;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnumProperty.class})
abstract class EnumPropertyMixin<T extends Enum<T>>
extends Property<T>
implements PropertyAccess<T> {
    @Unique
    private int[] idLookupTable;

    protected EnumPropertyMixin(String string, Class<T> class_) {
        super(string, class_);
    }

    @Override
    public final int moonrise$getIdFor(T value) {
        Class target = this.getValueClass();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        List values = this.getPossibleValues();
        Class clazz = this.getValueClass();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Object[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.moonrise$setById(byId);
    }

    @Overwrite
    public boolean equals(Object obj) {
        return this == obj;
    }
}

