/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkStorage.class})
abstract class ChunkStorageMixin
implements ChunkSystemChunkStorage,
AutoCloseable {
    @Shadow
    public IOWorker worker;
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private RegionFileStorage storage;

    ChunkStorageMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.storage = this.worker.storage;
        this.worker = null;
    }

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    @Overwrite
    public boolean isOldChunkAround(ChunkPos pos, int radius) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"upgradeChunkTag"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/LegacyStructureDataHandler;updateFromLegacy(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag synchroniseLegacyDataUpgrade(LegacyStructureDataHandler instance, CompoundTag compoundTag) {
        LegacyStructureDataHandler legacyStructureDataHandler = instance;
        synchronized (legacyStructureDataHandler) {
            return instance.updateFromLegacy(compoundTag);
        }
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/IOWorker;loadAsync(Lnet/minecraft/world/level/ChunkPos;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Optional<CompoundTag>> redirectLoad(IOWorker instance, ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.read(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    @Redirect(method={"write"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/IOWorker;store(Lnet/minecraft/world/level/ChunkPos;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Void> redirectWrite(IOWorker instance, ChunkPos chunkPos, Supplier<CompoundTag> compoundTag) {
        try {
            this.storage.write(chunkPos, compoundTag.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"handleLegacyStructureIndex"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/LegacyStructureDataHandler;removeIndex(J)V"))
    private void synchroniseLegacyDataWrite(LegacyStructureDataHandler instance, long pos) {
        LegacyStructureDataHandler legacyStructureDataHandler = instance;
        synchronized (legacyStructureDataHandler) {
            instance.removeIndex(pos);
        }
    }

    @Overwrite
    public void flushWorker() {
        try {
            this.storage.flush();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    @Overwrite
    public void close() throws Exception {
        this.storage.close();
    }

    @Overwrite
    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Overwrite
    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }
}

