/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.client.ClientEntityLookup;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
abstract class ClientLevelMixin
extends Level
implements ChunkSystemLevel {
    @Shadow
    private TransientEntitySectionManager<Entity> entityStorage;
    @Shadow
    @Final
    private ClientChunkCache chunkSource;

    protected ClientLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ClientPacketListener clientPacketListener, ClientLevel.ClientLevelData clientLevelData, ResourceKey<Level> resourceKey, Holder<DimensionType> holder, int i, int j, LevelRenderer levelRenderer, boolean bl, long l, int k, CallbackInfo ci) {
        this.entityStorage = null;
        this.moonrise$setEntityLookup(new ClientEntityLookup(this, (LevelCallback<Entity>)new ClientLevel.EntityCallbacks((ClientLevel)this)));
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ClientChunkCache chunkSource = this.chunkSource;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Overwrite
    public int getEntityCount() {
        return this.moonrise$getEntityLookup().getEntityCount();
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus status, boolean load) {
        return this.chunkSource.getChunk(x, z, status, load);
    }

    public LevelChunk getChunk(int x, int z) {
        return this.chunkSource.getChunk(x, z, ChunkStatus.FULL, true);
    }

    @Redirect(method={"addEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/TransientEntitySectionManager;addEntity(Lnet/minecraft/world/level/entity/EntityAccess;)V"))
    private <T extends EntityAccess> void addEntityHook(TransientEntitySectionManager<T> instance, T entityAccess) {
        this.moonrise$getEntityLookup().addNewEntity((Entity)entityAccess);
    }

    @Redirect(method={"getEntities()Lnet/minecraft/world/level/entity/LevelEntityGetter;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/TransientEntitySectionManager;getEntityGetter()Lnet/minecraft/world/level/entity/LevelEntityGetter;"))
    private LevelEntityGetter<Entity> redirectGetEntities(TransientEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup();
    }

    @Redirect(method={"gatherChunkSourceStats"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/TransientEntitySectionManager;gatherStats()Ljava/lang/String;"))
    private String redirectGatherChunkSourceStats(TransientEntitySectionManager<Entity> instance) {
        return this.moonrise$getEntityLookup().getDebugInfo();
    }

    @Redirect(method={"unload"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/TransientEntitySectionManager;stopTicking(Lnet/minecraft/world/level/ChunkPos;)V"))
    private <T extends EntityAccess> void chunkUnloadHook(TransientEntitySectionManager<T> instance, ChunkPos pos) {
        ((ClientEntityLookup)this.moonrise$getEntityLookup()).markNonTicking(pos.toLong());
    }

    @Redirect(method={"onChunkLoaded"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/TransientEntitySectionManager;startTicking(Lnet/minecraft/world/level/ChunkPos;)V"))
    private <T extends EntityAccess> void chunkLoadHook(TransientEntitySectionManager<T> instance, ChunkPos pos) {
        ((ClientEntityLookup)this.moonrise$getEntityLookup()).markTicking(pos.toLong());
    }
}

