/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketStorage;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.LoadingChunkTracker;
import net.minecraft.server.level.SimulationChunkTracker;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
abstract class DistanceManagerMixin
implements ChunkSystemDistanceManager {
    @Shadow
    public LoadingChunkTracker loadingChunkTracker;
    @Shadow
    public SimulationChunkTracker simulationChunkTracker;
    @Shadow
    @Final
    private TicketStorage ticketStorage;
    @Shadow
    private DistanceManager.PlayerTicketTracker playerTicketManager;
    @Shadow
    Set<ChunkHolder> chunksToUpdateFutures;
    @Shadow
    ThrottlingChunkTaskDispatcher ticketDispatcher;
    @Shadow
    LongSet ticketsToRelease;
    @Shadow
    Executor mainThreadExecutor;
    @Shadow
    private int simulationDistance;

    DistanceManagerMixin() {
    }

    @Override
    public ChunkMap moonrise$getChunkMap() {
        throw new AbstractMethodError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void destroyFields(CallbackInfo ci) {
        this.loadingChunkTracker = null;
        this.simulationChunkTracker = null;
        this.playerTicketManager = null;
        this.chunksToUpdateFutures = null;
        this.ticketDispatcher = null;
        this.ticketsToRelease = null;
        this.mainThreadExecutor = null;
        this.simulationDistance = -1;
        ((ChunkSystemTicketStorage)this.ticketStorage).moonrise$setChunkMap(this.moonrise$getChunkMap());
    }

    @Override
    public final ChunkHolderManager moonrise$getChunkHolderManager() {
        return ((ChunkSystemServerLevel)this.moonrise$getChunkMap().level).moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Overwrite
    public boolean runAllUpdates(ChunkMap chunkStorage) {
        return this.moonrise$getChunkHolderManager().processTicketUpdates();
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V"))
    private void skipTickingTicketTrackerAdd(DistanceManager.PlayerTicketTracker instance, long l, int i, boolean b) {
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/TicketStorage;addTicket(Lnet/minecraft/server/level/Ticket;Lnet/minecraft/world/level/ChunkPos;)V"))
    private void skipTickingTicketTrackerAdd(TicketStorage instance, Ticket ticket, ChunkPos pos) {
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getPlayerTicketLevel()I"))
    private int skipTicketLevelAdd(DistanceManager instance) {
        return 0;
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V"))
    private void skipTickingTicketTrackerRemove(DistanceManager.PlayerTicketTracker instance, long l, int i, boolean b) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/TicketStorage;removeTicket(Lnet/minecraft/server/level/Ticket;Lnet/minecraft/world/level/ChunkPos;)V"))
    private void skipTickingTicketTrackerRemove(TicketStorage instance, Ticket ticket, ChunkPos pos) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getPlayerTicketLevel()I"))
    private int skipTicketLevelRemove(DistanceManager instance) {
        return 0;
    }

    @Overwrite
    public int getPlayerTicketLevel() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean inEntityTickingRange(long pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(pos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Overwrite
    public boolean inBlockTickingRange(long pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(pos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    @Overwrite
    public int getChunkLevel(long pos, boolean simulation) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(pos);
        return chunkHolder == null ? ChunkHolderManager.MAX_TICKET_LEVEL + 1 : chunkHolder.getTicketLevel();
    }

    @Overwrite
    public void updatePlayerTickets(int viewDistance) {
        this.moonrise$getChunkMap().setServerViewDistance(viewDistance);
    }

    @Overwrite
    public void updateSimulationDistance(int simulationDistance) {
        int clamped = Mth.clamp((int)simulationDistance, (int)0, (int)MoonriseConstants.MAX_VIEW_DISTANCE);
        ((ChunkSystemServerLevel)this.moonrise$getChunkMap().level).moonrise$getPlayerChunkLoader().setTickDistance(clamped);
    }

    @Overwrite
    public void forEachEntityTickingChunk(LongConsumer consumer) {
        ReferenceList<LevelChunk> chunks = ((ChunkSystemServerLevel)this.moonrise$getChunkMap().level).moonrise$getEntityTickingChunks();
        LevelChunk[] raw = chunks.getRawDataUnchecked();
        int size = chunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i = 0; i < size; ++i) {
            LevelChunk chunk = raw[i];
            consumer.accept(CoordinateUtils.getChunkKey(chunk.getPos()));
        }
    }

    @Overwrite
    public String getDebugStatus() {
        return "N/A";
    }
}

