/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiSection;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PoiManager.class})
public abstract class PoiManagerMixin
extends SectionStorage<Object, Object>
implements ChunkSystemPoiManager {
    @Unique
    private ServerLevel world;
    @Unique
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    @Unique
    private static final int POI_DATA_SOURCE = 7;

    public PoiManagerMixin(SimpleRegionStorage simpleRegionStorage, Codec<Object> codec, Function<Object, Object> function, BiFunction<Object, Runnable, Object> biFunction, Function<Runnable, Object> function2, RegistryAccess registryAccess, ChunkIOErrorReporter chunkIOErrorReporter, LevelHeightAccessor levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Shadow
    abstract boolean isVillageCenter(long var1);

    @Shadow
    public abstract void checkConsistencyWithBlocks(SectionPos var1, LevelChunkSection var2);

    @Unique
    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    @Unique
    private void updateDistanceTracking(long section) {
        if (this.isVillageCenter(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(RegionStorageInfo regionStorageInfo, Path path, DataFixer dataFixer, boolean bl, RegistryAccess registryAccess, ChunkIOErrorReporter chunkIOErrorReporter, LevelHeightAccessor levelHeightAccessor, CallbackInfo ci) {
        this.world = (ServerLevel)levelHeightAccessor;
    }

    @Overwrite
    public int sectionsToVillage(SectionPos pos) {
        this.villageDistanceTracker.propagateUpdates();
        return PoiManagerMixin.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(pos)));
    }

    @Overwrite
    public void tick(BooleanSupplier shouldKeepTicking) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Overwrite
    public void setDirty(long pos) {
        int chunkZ;
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(pos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(pos);
    }

    @Overwrite
    public void onSectionLoad(long pos) {
        this.updateDistanceTracking(pos);
    }

    public Optional<Object> get(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        PoiChunk ret = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    public Optional<Object> getOrLoad(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection((Level)this.world) && chunkY <= WorldUtil.getMaxSection((Level)this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    protected Object getOrCreate(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final ServerLevel moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        int minY = WorldUtil.getMinSection((Level)this.world);
        int maxY = WorldUtil.getMaxSection((Level)this.world);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            long sectionPos = SectionPos.asLong((int)chunkX, (int)sectionY, (int)chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        int minY = WorldUtil.getMinSection((Level)this.world);
        int maxY = WorldUtil.getMaxSection((Level)this.world);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            PoiSection section = poiChunk.getSection(sectionY);
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty()) continue;
            this.onSectionLoad(SectionPos.asLong((int)chunkX, (int)sectionY, (int)chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(ChunkAccess chunk) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        int minY = WorldUtil.getMinSection((LevelHeightAccessor)chunk);
        int maxY = WorldUtil.getMaxSection((LevelHeightAccessor)chunk);
        LevelChunkSection[] sections = chunk.getSections();
        for (int section = minY; section <= maxY; ++section) {
            this.checkConsistencyWithBlocks(SectionPos.of((int)chunkX, (int)section, (int)chunkZ), sections[section - minY]);
        }
    }

    @Redirect(method={"ensureLoadedAndValid"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=1))
    private <T> Stream<T> skipLoadedSet(Stream<T> instance, Predicate<? super T> predicate) {
        return instance;
    }
}

